/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.JxtaError;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;

public class ConfigDialog
extends Frame {
    static final GridBagConstraints stdConstr = new GridBagConstraints();
    static final GridBagConstraints centerConstr;
    static final GridBagConstraints centerLastConstr;
    static final GridBagConstraints fillConstr;
    static final GridBagConstraints fillInsetConstr;
    private final PlatformConfig configAdv;
    private final Label helpLabel;
    private final IdPanel idPanel;
    private final EnablingPanel enablingPanel;
    private final IPTptPanel tcpPanel;
    private final IPTptPanel httpPanel;
    private final RdvPanel rdvPanel;
    private final RelayPanel relayPanel;
    private final Button ok;
    private final Button cancel;
    private final PagesPanel pages = new PagesPanel();
    boolean done = false;
    boolean canceled = false;
    String tcpMulticastAddr;
    int tcpMulticastPort;
    int tcpMulticastLength;

    public ConfigDialog(PlatformConfig configAdv) throws ConfiguratorException {
        super("JXTA Configurator");
        boolean useOnlySeedRelays;
        boolean useRelay;
        boolean isRelay;
        boolean onlySeeds;
        boolean isAdhoc;
        boolean isRendezvous;
        boolean noPublicAddressesH;
        String defaultServerPortH;
        String defaultServerNameH;
        String defaultPortH;
        String defaultInterfaceAddressH;
        boolean serverDefaultH;
        boolean clientDefaultH;
        boolean httpEnabled;
        boolean multicastEnabledT;
        boolean noPublicAddressesT;
        String defaultServerPortT;
        String defaultServerNameT;
        String defaultPortT;
        String defaultInterfaceAddressT;
        boolean serverDefaultT;
        boolean clientDefaultT;
        boolean tcpEnabled;
        this.configAdv = configAdv;
        String peerName = configAdv.getName();
        if (null == peerName || 0 == peerName.trim().length()) {
            peerName = "";
        }
        boolean needSecurityConfig = true;
        XMLElement param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.membershipClassID));
        if (param != null) {
            Advertisement adv = null;
            try {
                adv = AdvertisementFactory.newAdvertisement(param);
            }
            catch (NoSuchElementException notAnAdv) {
            }
            catch (IllegalArgumentException badAdv) {
                // empty catch block
            }
            if (adv instanceof PSEConfigAdv) {
                PSEConfigAdv pseConfig = (PSEConfigAdv)adv;
                needSecurityConfig = null == pseConfig.getCertificate();
            }
        }
        boolean isJxmeProxy = false;
        try {
            param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.proxyClassID));
            if (param != null && configAdv.isSvcEnabled(PeerGroup.proxyClassID)) {
                isJxmeProxy = true;
            }
        }
        catch (Exception nobigdeal) {
            nobigdeal.printStackTrace();
        }
        try {
            int index;
            param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.tcpProtoClassID));
            tcpEnabled = configAdv.isSvcEnabled(PeerGroup.tcpProtoClassID);
            Enumeration tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (!tcpChilds.hasMoreElements()) {
                throw new IllegalStateException("Missing TCP Advertisment");
            }
            param = (XMLElement)tcpChilds.nextElement();
            TCPAdv tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(param);
            clientDefaultT = tcpAdv.isClientEnabled();
            serverDefaultT = tcpAdv.isServerEnabled();
            defaultInterfaceAddressT = tcpAdv.getInterfaceAddress();
            if (null == defaultInterfaceAddressT || 0 == defaultInterfaceAddressT.trim().length()) {
                defaultInterfaceAddressT = null;
            }
            if ((defaultPortT = Integer.toString(tcpAdv.getPort())) == null || 0 == defaultPortT.trim().length()) {
                defaultPortT = "9701";
            }
            if (null == (defaultServerNameT = tcpAdv.getServer()) || 0 == defaultServerNameT.trim().length()) {
                defaultServerNameT = "";
            }
            if (defaultServerNameT != null && (index = defaultServerNameT.lastIndexOf(":")) != -1) {
                if (0 == index || index == defaultServerNameT.length()) {
                    throw new IllegalArgumentException("Bad TCP server name . Cannot proceed.");
                }
                defaultServerPortT = defaultServerNameT.substring(index + 1);
                defaultServerNameT = defaultServerNameT.substring(0, index);
            } else {
                defaultServerNameT = "";
                defaultServerPortT = "9701";
            }
            noPublicAddressesT = tcpAdv.getPublicAddressOnly();
            multicastEnabledT = tcpAdv.getMulticastState();
            this.tcpMulticastAddr = tcpAdv.getMulticastAddr();
            this.tcpMulticastPort = tcpAdv.getMulticastPort();
            this.tcpMulticastLength = tcpAdv.getMulticastSize();
        }
        catch (Exception failure) {
            throw new ConfiguratorException("Broken Platform Config. Cannot proceed.", failure);
        }
        try {
            int index;
            param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.httpProtoClassID));
            httpEnabled = configAdv.isSvcEnabled(PeerGroup.httpProtoClassID);
            Enumeration httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (!httpChilds.hasMoreElements()) {
                throw new IllegalStateException("Missing HTTP Advertisment");
            }
            param = (XMLElement)httpChilds.nextElement();
            HTTPAdv httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(param);
            clientDefaultH = httpAdv.isClientEnabled();
            serverDefaultH = httpAdv.isServerEnabled();
            defaultInterfaceAddressH = httpAdv.getInterfaceAddress();
            if (null == defaultInterfaceAddressH || 0 == defaultInterfaceAddressH.trim().length()) {
                defaultInterfaceAddressH = null;
            }
            if ((defaultPortH = Integer.toString(httpAdv.getPort())) == null || 0 == defaultPortH.trim().length()) {
                defaultPortH = "9700";
            }
            if (null != (defaultServerNameH = httpAdv.getServer()) && 0 == defaultServerNameH.trim().length()) {
                defaultServerNameH = "";
            }
            defaultServerPortH = "9700";
            if (defaultServerNameH != null && (index = defaultServerNameH.lastIndexOf(":")) != -1) {
                if (0 == index || index == defaultServerNameH.length()) {
                    throw new IllegalArgumentException("Bad HTTP server name. Cannot proceed.");
                }
                defaultServerPortH = defaultServerNameH.substring(index + 1);
                defaultServerNameH = defaultServerNameH.substring(0, index);
            } else {
                defaultServerNameH = "";
                defaultServerPortH = "9700";
            }
            noPublicAddressesH = httpAdv.getPublicAddressOnly();
        }
        catch (Exception failure) {
            throw new ConfiguratorException("Broken Platform Config. Cannot proceed.", failure);
        }
        ArrayList<String> seedRdvs = new ArrayList<String>();
        ArrayList<String> seedingRdvs = new ArrayList<String>();
        try {
            param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.rendezvousClassID));
            RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(param);
            isRendezvous = RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS == rdvConfigAdv.getConfiguration();
            isAdhoc = RdvConfigAdv.RendezVousConfiguration.AD_HOC == rdvConfigAdv.getConfiguration();
            onlySeeds = rdvConfigAdv.getUseOnlySeeds();
            for (URI uri : Arrays.asList(rdvConfigAdv.getSeedRendezvous())) {
                seedRdvs.add(uri.toString());
            }
            for (URI uri1 : Arrays.asList(rdvConfigAdv.getSeedingURIs())) {
                seedingRdvs.add(uri1.toString());
            }
        }
        catch (Exception failure) {
            throw new ConfiguratorException("Broken Platform Config. Cannot proceed.", failure);
        }
        ArrayList<String> seedRelays = new ArrayList<String>();
        ArrayList<String> seedingRelays = new ArrayList<String>();
        try {
            param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.relayProtoClassID));
            RelayConfigAdv relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement(param);
            isRelay = relayConfig.isServerEnabled();
            useRelay = relayConfig.isClientEnabled();
            useOnlySeedRelays = relayConfig.getUseOnlySeeds();
            for (EndpointAddress endpointAddress : Arrays.asList(relayConfig.getSeedRelays())) {
                seedRelays.add(endpointAddress.toString());
            }
            for (URI uri : Arrays.asList(relayConfig.getSeedingURIs())) {
                seedingRelays.add(uri.toString());
            }
        }
        catch (Exception failure) {
            throw new ConfiguratorException("Broken Platform Config. Cannot proceed.", failure);
        }
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigDialog.this.beCanceled();
            }
        });
        this.helpLabel = new Label("See \"http://jxta-jxse.dev.java.net/confighelp.html\" for config help", 1);
        this.helpLabel.setBackground(new Color(220, 220, 220));
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ConfigDialog.this.helpLabel.setForeground(Color.black);
                ConfigDialog.this.helpLabel.setText("See \"http://jxta-jxse.dev.java.net/confighelp.html\" for config help");
            }
        });
        this.idPanel = new IdPanel(peerName, needSecurityConfig);
        this.enablingPanel = new EnablingPanel(isRelay, isRendezvous, isJxmeProxy);
        this.tcpPanel = new IPTptPanel(IPTptPanel.TransportType.TYPE_TCP, tcpEnabled, "TCP Settings", defaultInterfaceAddressT, defaultPortT, clientDefaultT, serverDefaultT, defaultServerNameT, defaultServerPortT, noPublicAddressesT, multicastEnabledT);
        this.httpPanel = new IPTptPanel(IPTptPanel.TransportType.TYPE_HTTP, httpEnabled, "HTTP Settings", defaultInterfaceAddressH, defaultPortH, clientDefaultH, serverDefaultH, defaultServerNameH, defaultServerPortH, noPublicAddressesH);
        this.rdvPanel = new RdvPanel(!isAdhoc, onlySeeds);
        for (String seedRdv : seedRdvs) {
            this.rdvPanel.seeds.addItem(seedRdv);
        }
        for (String seedingRdv : seedingRdvs) {
            this.rdvPanel.seeding.addItem(seedingRdv);
        }
        this.relayPanel = new RelayPanel(useRelay, useOnlySeedRelays);
        for (String seedRelay : seedRelays) {
            this.relayPanel.seeds.addItem(seedRelay);
        }
        for (String seedingRelay : seedingRelays) {
            this.relayPanel.seeding.addItem(seedingRelay);
        }
        this.ok = new Button("  OK  ");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConfigDialog.this.verifyInput()) {
                    if (ConfigDialog.this.saveValues()) {
                        ConfigDialog.this.beDone();
                    } else {
                        ConfigDialog.this.beCanceled();
                    }
                }
            }
        });
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.beCanceled();
            }
        });
        Panel okPanel = new Panel();
        okPanel.add(this.ok);
        okPanel.add(this.cancel);
        PanelGBL basicsPanel = this.pages.addPage("Basic", "Basic settings");
        GridBagConstraints centerWConstr = (GridBagConstraints)centerConstr.clone();
        centerWConstr.weighty = 1.0;
        basicsPanel.add((Component)this.idPanel, centerWConstr);
        PanelGBL advancedPanel = this.pages.addPage("Advanced", "Experienced Users Only");
        advancedPanel.add((Component)this.enablingPanel, fillInsetConstr);
        advancedPanel.add((Component)this.tcpPanel, fillInsetConstr);
        advancedPanel.add((Component)this.httpPanel, fillInsetConstr);
        PanelGBL proxyRdvRelayPanel = this.pages.addPage("Rendezvous/Relays", "Experienced Users Only");
        proxyRdvRelayPanel.add((Component)this.rdvPanel, fillInsetConstr);
        proxyRdvRelayPanel.add((Component)this.relayPanel, fillInsetConstr);
        this.add((Component)this.helpLabel, fillConstr);
        this.add((Component)this.pages, fillInsetConstr);
        this.add((Component)okPanel, centerLastConstr);
        this.pack();
        this.setVisible(true);
    }

    public synchronized boolean untilDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (this.canceled) {
            throw new JxtaError("Canceled during configuration");
        }
        return this.done;
    }

    private synchronized boolean beDone() {
        this.done = true;
        this.notify();
        this.dispose();
        return this.canceled;
    }

    private synchronized boolean beCanceled() {
        this.canceled = true;
        this.done = true;
        this.notify();
        this.dispose();
        return this.canceled;
    }

    private boolean verifyPort(String portName, String ports, boolean dynamicok) {
        int p1;
        if (null == ports || 0 == ports.trim().length()) {
            ports = "0";
        }
        try {
            p1 = Integer.parseInt(ports);
        }
        catch (Exception ex) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(portName + " port number must be an integer: " + ports);
            return false;
        }
        if (p1 > 65535 || p1 < (dynamicok ? 0 : 1)) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(portName + " port number must be an integer between " + (dynamicok ? "0" : "1") + " and 65535, found " + p1);
            return false;
        }
        return true;
    }

    private boolean verifyAddr(String proto, boolean serverOn, String localPort, String publicAddress, String publicPort) {
        if (serverOn && publicAddress.length() > 0) {
            if (!this.verifyPort(proto + " local", localPort, false)) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Dynamic tcp port selection not supported when server public address is specified.");
                this.pages.showPage("Advanced");
                return false;
            }
            if (!this.verifyPort(proto + " public", publicPort, false)) {
                this.pages.showPage("Advanced");
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Dynamic tcp port selection not supported for server public address.");
                return false;
            }
        } else if (!this.verifyPort(proto + " local", localPort, true)) {
            this.pages.showPage("Advanced");
            return false;
        }
        return true;
    }

    private boolean verifyInput() {
        if (0 == this.idPanel.getName().trim().length()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("A peer name is required.");
            this.pages.showPage("Basic");
            return false;
        }
        if (null != this.idPanel.passwd) {
            String passwd = this.idPanel.getPassword();
            String vpasswd = this.idPanel.getVerifyPassword();
            if (passwd.length() < 8) {
                this.idPanel.clearPasswords();
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Passwords must be at least 8 characters");
                this.pages.showPage("Basic");
                return false;
            }
            if (!passwd.equals(vpasswd)) {
                this.idPanel.clearPasswords();
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password does not match Verify Password");
                this.pages.showPage("Basic");
                return false;
            }
        }
        if (!this.httpPanel.useMe.getState() && !this.tcpPanel.useMe.getState()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("At least one of TCP or HTTP must be enabled.");
            this.pages.showPage("Advanced");
            return false;
        }
        if (this.httpPanel.useMe.getState()) {
            if (!this.httpPanel.clientEnabled.getState() && !this.httpPanel.publicAddr.getState()) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Must enable incoming and/or outcoming to enable HTTP");
                this.pages.showPage("Advanced");
                return false;
            }
            boolean valid = this.verifyAddr("HTTP", this.httpPanel.publicAddr.getState(), this.httpPanel.ifAddr.getPort(), this.httpPanel.publicAddr.getHost(), this.httpPanel.publicAddr.getPort());
            if (!valid) {
                return false;
            }
        }
        if (this.tcpPanel.useMe.getState()) {
            if (!(this.tcpPanel.clientEnabled.getState() || this.tcpPanel.publicAddr.getState() || this.tcpPanel.multicast.getState())) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Must enable at least one of incoming, outcoming or multicast to enable TCP");
                this.pages.showPage("Advanced");
                return false;
            }
            boolean valid = this.verifyAddr("TCP", this.tcpPanel.publicAddr.getState(), this.tcpPanel.ifAddr.getPort(), this.tcpPanel.publicAddr.getHost(), this.tcpPanel.publicAddr.getPort());
            if (!valid) {
                return false;
            }
        }
        if (!(this.relayPanel.useRelay.getState() || this.httpPanel.useMe.getState() && this.httpPanel.publicAddr.getState() || this.tcpPanel.useMe.getState() && this.tcpPanel.publicAddr.getState())) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Must use Relay if incoming not enabled for TCP and/or HTTP");
            this.pages.showPage("Relay/Rendezvous");
            return false;
        }
        if (!(!this.enablingPanel.isRelay.getState() || this.httpPanel.useMe.getState() && this.httpPanel.publicAddr.getState() || this.tcpPanel.useMe.getState() && this.tcpPanel.publicAddr.getState())) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Must enable incoming for TCP and/or HTTP to enable Relay");
            this.pages.showPage("Advanced");
            return false;
        }
        if (!(!this.enablingPanel.isRendezvous.getState() || this.httpPanel.useMe.getState() && this.httpPanel.publicAddr.getState() || this.tcpPanel.useMe.getState() && this.tcpPanel.publicAddr.getState())) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Must enable incoming for TCP and/or HTTP to enable Rendezvous");
            this.pages.showPage("Advanced");
            return false;
        }
        if (this.rdvPanel.useOnlySeeds.getState()) {
            String[] rdvAddrs = this.rdvPanel.seeds.getItems();
            String[] rdvSeedAddrs = this.rdvPanel.seeding.getItems();
            if (rdvAddrs.length == 0 && rdvSeedAddrs.length == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Must provide at least one seed rendezvous");
                this.pages.showPage("Rendezvous/Relays");
                return false;
            }
        }
        if (this.relayPanel.useRelay.getState()) {
            String[] relayaddrs = this.relayPanel.seeds.getItems();
            String[] relaySeedaddrs = this.relayPanel.seeding.getItems();
            if (relayaddrs.length == 0 && relaySeedaddrs.length == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Must provide at least one seed Relay address");
                this.pages.showPage("Rendezvous/Relays");
                return false;
            }
        }
        return true;
    }

    private boolean saveValues() {
        try {
            boolean relayDisabled;
            this.configAdv.setName(this.idPanel.getName());
            HTTPAdv httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(HTTPAdv.getAdvertisementType());
            httpAdv.setConfigMode(this.httpPanel.getConfigMode());
            String chosenIntf = this.httpPanel.getInterfaceAddress();
            if (chosenIntf.startsWith("A")) {
                httpAdv.setInterfaceAddress(null);
            } else {
                httpAdv.setInterfaceAddress(chosenIntf);
            }
            httpAdv.setPort(Integer.parseInt(this.httpPanel.ifAddr.getPort()));
            httpAdv.setClientEnabled(this.httpPanel.clientEnabled.getState());
            httpAdv.setServerEnabled(this.httpPanel.publicAddr.getState());
            if (0 == this.httpPanel.publicAddr.getHost().trim().length()) {
                httpAdv.setServer(null);
            } else {
                httpAdv.setServer(this.httpPanel.publicAddr.getHost() + ":" + this.httpPanel.publicAddr.getPort());
            }
            httpAdv.setPublicAddressOnly(this.httpPanel.getPubAddrOnly());
            this.configAdv.putServiceParam(PeerGroup.httpProtoClassID, this.wrapParm(httpAdv, this.httpPanel.useMe.getState()));
            TCPAdv tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(TCPAdv.getAdvertisementType());
            tcpAdv.setConfigMode(this.tcpPanel.getConfigMode());
            chosenIntf = this.tcpPanel.getInterfaceAddress();
            if (chosenIntf.startsWith("A")) {
                tcpAdv.setInterfaceAddress(null);
            } else {
                tcpAdv.setInterfaceAddress(chosenIntf);
            }
            try {
                int theTcpPort = Integer.parseInt(this.tcpPanel.ifAddr.getPort());
                tcpAdv.setPort(theTcpPort);
                if (0 == theTcpPort) {
                    tcpAdv.setStartPort(0);
                    tcpAdv.setEndPort(0);
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            tcpAdv.setClientEnabled(this.tcpPanel.clientEnabled.getState());
            tcpAdv.setServerEnabled(this.tcpPanel.publicAddr.getState());
            if (0 == this.tcpPanel.publicAddr.getHost().trim().length()) {
                tcpAdv.setServer(null);
            } else {
                tcpAdv.setServer(this.tcpPanel.publicAddr.getHost() + ":" + this.tcpPanel.publicAddr.getPort());
            }
            tcpAdv.setMulticastState(this.tcpPanel.multicast.getState());
            tcpAdv.setMulticastAddr(this.tcpMulticastAddr);
            tcpAdv.setMulticastPort(this.tcpMulticastPort);
            tcpAdv.setMulticastSize(this.tcpMulticastLength);
            tcpAdv.setPublicAddressOnly(this.tcpPanel.getPubAddrOnly());
            this.configAdv.putServiceParam(PeerGroup.tcpProtoClassID, this.wrapParm(tcpAdv, this.tcpPanel.useMe.getState()));
            XMLDocument proxy = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            if (!this.enablingPanel.isJxmeProxy.getState()) {
                proxy.appendChild(proxy.createElement("isOff"));
            }
            this.configAdv.putServiceParam(PeerGroup.proxyClassID, proxy);
            RdvConfigAdv rdvConf = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
            rdvConf.setConfiguration(this.enablingPanel.isRendezvous.getState() ? RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS : (this.rdvPanel.useRdv.getState() ? RdvConfigAdv.RendezVousConfiguration.EDGE : RdvConfigAdv.RendezVousConfiguration.AD_HOC));
            rdvConf.setUseOnlySeeds(this.rdvPanel.useOnlySeeds.getState());
            for (String s2 : Arrays.asList(this.rdvPanel.seeds.getItems())) {
                rdvConf.addSeedRendezvous(s2);
            }
            for (String s3 : Arrays.asList(this.rdvPanel.seeding.getItems())) {
                rdvConf.addSeedingURI(s3);
            }
            XMLDocument rdvDoc = (XMLDocument)rdvConf.getDocument(MimeMediaType.XMLUTF8);
            this.configAdv.putServiceParam(PeerGroup.rendezvousClassID, rdvDoc);
            RelayConfigAdv relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement(RelayConfigAdv.getAdvertisementType());
            relayConfig.setServerEnabled(this.enablingPanel.isRelay.getState());
            relayConfig.setClientEnabled(this.relayPanel.useRelay.getState());
            for (String s : Arrays.asList(this.relayPanel.seeds.getItems())) {
                relayConfig.addSeedRelay(s);
            }
            for (String s1 : Arrays.asList(this.relayPanel.seeding.getItems())) {
                relayConfig.addSeedingURI(s1);
            }
            relayConfig.setUseOnlySeeds(this.relayPanel.useOnlySeeds.getState());
            XMLDocument relayDoc = (XMLDocument)relayConfig.getDocument(MimeMediaType.XMLUTF8);
            boolean bl = relayDisabled = !this.enablingPanel.isRelay.getState() && !this.relayPanel.useRelay.getState();
            if (relayDisabled) {
                relayDoc.appendChild(relayDoc.createElement("isOff"));
            }
            this.configAdv.putServiceParam(PeerGroup.relayProtoClassID, relayDoc);
            if (null != this.idPanel.passwd) {
                PSEConfigAdv pseConf = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
                PSEUtils.IssuerInfo info = PSEUtils.genCert(this.idPanel.getName(), null);
                pseConf.setCertificate(info.cert);
                pseConf.setPrivateKey(info.subjectPkey, this.idPanel.getPassword().toCharArray());
                XMLDocument pseDoc = (XMLDocument)pseConf.getDocument(MimeMediaType.XMLUTF8);
                this.configAdv.putServiceParam(PeerGroup.membershipClassID, pseDoc);
            }
        }
        catch (Throwable bad) {
            bad.printStackTrace();
            return false;
        }
        return true;
    }

    private XMLDocument wrapParm(Advertisement srcAdv, boolean enabled) {
        try {
            XMLDocument advDoc = (XMLDocument)srcAdv.getDocument(MimeMediaType.XMLUTF8);
            XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            StructuredDocumentUtils.copyElements(doc, doc, advDoc);
            if (!enabled) {
                doc.appendChild(doc.createElement("isOff"));
            }
            return doc;
        }
        catch (Throwable ez1) {
            ez1.printStackTrace();
            return null;
        }
    }

    static {
        ConfigDialog.stdConstr.gridwidth = 0;
        ConfigDialog.stdConstr.gridheight = 1;
        ConfigDialog.stdConstr.gridx = 0;
        ConfigDialog.stdConstr.gridy = -1;
        ConfigDialog.stdConstr.fill = 0;
        ConfigDialog.stdConstr.weightx = 1.0;
        ConfigDialog.stdConstr.anchor = 18;
        ConfigDialog.stdConstr.insets = new Insets(0, 0, 0, 0);
        fillConstr = (GridBagConstraints)stdConstr.clone();
        ConfigDialog.fillConstr.fill = 2;
        centerConstr = (GridBagConstraints)stdConstr.clone();
        ConfigDialog.centerConstr.anchor = 11;
        centerLastConstr = (GridBagConstraints)centerConstr.clone();
        ConfigDialog.centerLastConstr.weighty = 1.0;
        fillInsetConstr = (GridBagConstraints)fillConstr.clone();
        ConfigDialog.fillInsetConstr.insets = new Insets(5, 5, 5, 5);
    }

    static final class RelayPanel
    extends BorderPanelGBL
    implements ItemListener {
        private final Checkbox useRelay;
        private final Checkbox useOnlySeeds;
        private final HostListPanel seeding;
        private final HostListPanel seeds;

        public RelayPanel(boolean useARelay, boolean onlySeeds) {
            super("Relay Settings");
            this.useRelay = new Checkbox("Use a relay", null, useARelay);
            this.useOnlySeeds = new Checkbox("Use only configured seeds", null, onlySeeds);
            this.useOnlySeeds.setEnabled(useARelay);
            this.seeds = new HostListPanel("Seeds", "Relay seed peers", useARelay, false);
            this.seeding = new HostListPanel("Seeding", "Relay seeding URIs", useARelay, false);
            GridBagConstraints c1 = new GridBagConstraints();
            c1.gridx = 0;
            c1.gridy = 0;
            c1.anchor = 21;
            this.add((Component)this.useRelay, c1);
            this.useRelay.addItemListener(this);
            ++c1.gridx;
            c1.anchor = 22;
            this.add((Component)this.useOnlySeeds, c1);
            c1.gridx = 0;
            ++c1.gridy;
            c1.gridwidth = 2;
            c1.weightx = 1.0;
            c1.fill = 2;
            c1.anchor = 21;
            this.add((Component)this.seeding, c1);
            ++c1.gridy;
            this.add((Component)this.seeds, c1);
        }

        public void itemStateChanged(ItemEvent e) {
            this.seeds.setEnabled(this.useRelay.getState());
            this.seeding.setEnabled(this.useRelay.getState());
            this.useOnlySeeds.setEnabled(this.useRelay.getState());
        }
    }

    static final class RdvPanel
    extends BorderPanelGBL
    implements ItemListener {
        private final Checkbox useRdv;
        private final Checkbox useOnlySeeds;
        private final HostListPanel seeding;
        private final HostListPanel seeds;

        RdvPanel(boolean useARdv, boolean onlySeeds) {
            super("Rendezvous Settings");
            this.useRdv = new Checkbox("Use a rendezvous", null, useARdv);
            this.useOnlySeeds = new Checkbox("Use only configured seeds", null, onlySeeds);
            this.seeds = new HostListPanel("Seeds", "Rendezvous seed peers", true, false);
            this.seeding = new HostListPanel("Seeding", "Rendezvous seeding URIs", true, false);
            GridBagConstraints c1 = new GridBagConstraints();
            c1.gridx = 0;
            c1.gridy = 0;
            c1.anchor = 21;
            this.add((Component)this.useRdv, c1);
            this.useRdv.addItemListener(this);
            ++c1.gridx;
            c1.anchor = 22;
            this.add((Component)this.useOnlySeeds, c1);
            c1.gridx = 0;
            ++c1.gridy;
            c1.gridwidth = 2;
            c1.weightx = 1.0;
            c1.fill = 2;
            c1.anchor = 21;
            this.add((Component)this.seeding, c1);
            ++c1.gridy;
            this.add((Component)this.seeds, c1);
        }

        public void itemStateChanged(ItemEvent e) {
            this.seeds.setEnabled(this.useRdv.getState());
            this.seeding.setEnabled(this.useRdv.getState());
            this.useOnlySeeds.setEnabled(this.useRdv.getState());
        }
    }

    static final class EnablingPanel
    extends BorderPanelGBL {
        private final Checkbox isRelay;
        private final Checkbox isRendezvous;
        private final Checkbox isJxmeProxy;

        EnablingPanel(boolean actAsRelay, boolean actAsRendezvous, boolean actAsJxmeProxy) {
            super("Services Settings");
            this.isRelay = new Checkbox("Act as a Relay", null, actAsRelay);
            this.isRendezvous = new Checkbox("Act as a Rendezvous", null, actAsRendezvous);
            this.isJxmeProxy = new Checkbox("Act as a JXME proxy", null, actAsJxmeProxy);
            this.add((Component)this.isRelay, stdConstr);
            this.add((Component)this.isRendezvous, stdConstr);
            this.add((Component)this.isJxmeProxy, stdConstr);
        }
    }

    final class IdPanel
    extends Panel
    implements ActionListener {
        private final TextField peerName;
        private final TextField passwd;
        private final TextField vpasswd;

        public IdPanel(String defaultPeerName, boolean needSecurityConfig) {
            super(new GridBagLayout());
            this.peerName = new TextField(defaultPeerName, 20);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 24;
            this.add((Component)new Label("Peer Name", 2), constraints);
            ++constraints.gridx;
            constraints.anchor = 23;
            this.add((Component)this.peerName, constraints);
            if (needSecurityConfig) {
                this.passwd = new TextField("", 20);
                this.vpasswd = new TextField("", 20);
                this.passwd.setEchoChar('*');
                this.vpasswd.setEchoChar('*');
                constraints.gridx = 0;
                ++constraints.gridy;
                constraints.anchor = 22;
                this.add((Component)new Label("Password", 2), constraints);
                ++constraints.gridx;
                constraints.anchor = 21;
                this.add((Component)this.passwd, constraints);
                constraints.gridx = 0;
                ++constraints.gridy;
                constraints.anchor = 22;
                this.add((Component)new Label("Verify Password", 2), constraints);
                ++constraints.gridx;
                constraints.anchor = 21;
                this.add((Component)this.vpasswd, constraints);
            } else {
                this.passwd = null;
                this.vpasswd = null;
            }
        }

        public String getName() {
            return this.peerName.getText().trim();
        }

        public String getPassword() {
            return this.passwd.getText();
        }

        public String getVerifyPassword() {
            return this.vpasswd.getText();
        }

        public void clearPasswords() {
            this.passwd.setText("");
            this.vpasswd.setText("");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    static final class IPTptPanel
    extends BorderPanelGBL
    implements ItemListener {
        private final Checkbox useMe;
        private final Checkbox pubAddrOnly;
        private final Checkbox multicast;
        private final Checkbox clientEnabled;
        private final IfAddrPanel ifAddr;
        private final HostPortPanel publicAddr;

        public IPTptPanel(TransportType type, boolean defaultState, String name, String defaultInterfaceAddr, String defaultPort, boolean clientState, boolean serverState, String defaultPublicAddr, String defaultPublicPort, boolean pubAddrOnlyState) {
            this(type, defaultState, name, defaultInterfaceAddr, defaultPort, clientState, serverState, defaultPublicAddr, defaultPublicPort, pubAddrOnlyState, false);
        }

        public IPTptPanel(TransportType type, boolean defaultState, String name, String defaultInterfaceAddr, String defaultPort, boolean clientState, boolean serverState, String defaultPublicAddr, String defaultPublicPort, boolean pubAddrOnlyState, boolean multicastState) {
            super(name);
            this.ifAddr = new IfAddrPanel(defaultInterfaceAddr, defaultPort);
            this.useMe = new Checkbox("Enabled", null, defaultState);
            this.multicast = type == TransportType.TYPE_TCP ? new Checkbox("Multicast", null, multicastState) : null;
            this.clientEnabled = new Checkbox("Enable Outgoing connections", null, clientState);
            this.pubAddrOnly = new Checkbox("Hide private addresses", null, pubAddrOnlyState);
            this.publicAddr = new HostPortPanel("Enable Incoming Connections", "(Optional) Public address", defaultPublicAddr, defaultPublicPort, serverState);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = 23;
            this.add((Component)this.useMe, constraints);
            if (type == TransportType.TYPE_TCP) {
                constraints.anchor = 24;
                this.add((Component)this.multicast, constraints);
            }
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 21;
            this.add((Component)this.ifAddr, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 21;
            this.add((Component)this.clientEnabled, constraints);
            constraints.anchor = 13;
            this.add((Component)this.pubAddrOnly, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 21;
            this.add((Component)this.publicAddr, constraints);
            this.publicAddr.setState(serverState);
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }

        public void setState(boolean state) {
            this.useMe.setState(state);
            this.ifAddr.setEnabled(state);
            this.publicAddr.setEnabled(state);
            if (this.multicast != null) {
                this.multicast.setEnabled(state);
            }
            this.clientEnabled.setEnabled(state);
            this.pubAddrOnly.setEnabled(state);
        }

        public void itemStateChanged(ItemEvent e) {
            this.setState(this.useMe.getState());
        }

        public String getInterfaceAddress() {
            return this.ifAddr.getAddress().trim();
        }

        public String getConfigMode() {
            return this.ifAddr.getMode();
        }

        public boolean getPubAddrOnly() {
            return this.pubAddrOnly.getState();
        }

        public void setPubAddrOnly(boolean state) {
            this.pubAddrOnly.setState(state);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum TransportType {
            TYPE_HTTP,
            TYPE_TCP;

        }
    }

    static class IfAddrPanel
    extends Panel
    implements ItemListener {
        private final Checkbox manual;
        private final CardLayout addrLayout;
        private final Panel addrPanel;
        private final TextField interfaceAddr;
        private final TextField localPort;
        private final Choice ips = new Choice();

        public IfAddrPanel(String defaultInterfaceAddr, String defaultPort) {
            super(new FlowLayout(3, 0, 0));
            boolean modeManual = false;
            this.ips.add("Any/All Local Addresses");
            try {
                InetAddress defaultIntf;
                Iterator<InetAddress> allIntf = IPUtils.getAllLocalAddresses();
                boolean sawValid = false;
                while (allIntf.hasNext()) {
                    InetAddress anAddr = allIntf.next();
                    if (IPUtils.LOOPBACK.equals(anAddr)) continue;
                    this.ips.add(IPUtils.getHostAddress(anAddr));
                    sawValid = true;
                }
                if (!sawValid) {
                    modeManual = true;
                }
                if (defaultInterfaceAddr != null && !IPUtils.ANYADDRESS.equals(defaultIntf = InetAddress.getByName(defaultInterfaceAddr))) {
                    modeManual = true;
                    allIntf = IPUtils.getAllLocalAddresses();
                    while (allIntf.hasNext()) {
                        InetAddress anAddr = allIntf.next();
                        if (!defaultIntf.equals(anAddr)) continue;
                        modeManual = false;
                        this.ips.select(defaultInterfaceAddr);
                    }
                }
            }
            catch (Exception e) {
                modeManual = true;
            }
            this.manual = new Checkbox("Manual", null, modeManual);
            this.add(this.manual);
            this.manual.addItemListener(this);
            this.addrLayout = new CardLayout();
            this.addrPanel = new Panel(this.addrLayout);
            Panel autoPanel = new Panel(new FlowLayout(3));
            autoPanel.add(this.ips);
            Panel manPanel = new Panel(new FlowLayout(3));
            this.interfaceAddr = new TextField(defaultInterfaceAddr, 20);
            manPanel.add(this.interfaceAddr);
            this.addrPanel.add((Component)manPanel, "man");
            this.addrPanel.add((Component)autoPanel, "auto");
            this.add(this.addrPanel);
            this.localPort = new TextField(defaultPort, 6);
            this.add(this.localPort);
            this.setManual(modeManual);
        }

        private void setManual(boolean manMode) {
            this.addrLayout.show(this.addrPanel, manMode ? "man" : "auto");
            this.validate();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.manual.setEnabled(enabled);
            this.ips.setEnabled(enabled);
            this.interfaceAddr.setEnabled(enabled);
            this.localPort.setEnabled(enabled);
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.manual) {
                this.setManual(this.manual.getState());
            }
        }

        public String getAddress() {
            if (this.manual.getState()) {
                return this.interfaceAddr.getText().trim();
            }
            return this.ips.getSelectedItem().trim();
        }

        public String getPort() {
            return this.localPort.getText().trim();
        }

        public String getMode() {
            return this.manual.getState() ? "manual" : "auto";
        }
    }

    static class HostListPanel
    extends Panel
    implements ActionListener {
        private final String purpose;
        private final TextField host;
        private final TextField port;
        private final List list;
        private final Label listLabel;
        private final Button insert;
        private final Button remove;

        public HostListPanel(String purpose, String lstLabel, boolean defaultState, boolean showPort) {
            super(new GridBagLayout());
            this.purpose = purpose;
            this.host = new TextField("", showPort ? 25 : 30);
            this.port = showPort ? new TextField("", 5) : null;
            this.insert = new Button("+");
            this.remove = new Button("-");
            this.list = new List(2, true);
            this.listLabel = new Label(lstLabel);
            GridBagConstraints c1 = new GridBagConstraints();
            c1.gridx = 0;
            c1.gridy = 0;
            c1.anchor = 23;
            c1.fill = 0;
            this.add((Component)this.listLabel, c1);
            c1.gridx = 0;
            ++c1.gridy;
            if (!showPort) {
                c1.gridwidth = 2;
            }
            c1.weightx = 2.0;
            c1.anchor = 21;
            c1.fill = 2;
            this.add((Component)this.host, c1);
            if (showPort) {
                c1.weightx = 0.0;
                c1.gridx = 1;
                c1.anchor = 22;
                c1.fill = 0;
                this.add((Component)this.port, c1);
            }
            c1.gridx = 0;
            ++c1.gridy;
            c1.gridwidth = 1;
            c1.weightx = 2.0;
            c1.anchor = 25;
            c1.fill = 2;
            this.add((Component)this.list, c1);
            Panel p2 = new Panel(new GridLayout(2, 1, 1, 1));
            p2.add(this.insert);
            p2.add(this.remove);
            ++c1.gridx;
            c1.weightx = 0.0;
            c1.anchor = 26;
            c1.fill = 0;
            c1.insets = new Insets(0, 4, 0, 1);
            this.add((Component)p2, c1);
            this.host.addActionListener(this);
            this.insert.addActionListener(this);
            this.remove.addActionListener(this);
            this.list.addActionListener(this);
            this.setEnabled(defaultState);
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.listLabel.setEnabled(state);
            this.host.setEnabled(state);
            if (null != this.port) {
                this.port.setEnabled(state);
            }
            this.list.setEnabled(state);
            this.insert.setEnabled(state);
            this.remove.setEnabled(state);
        }

        public boolean isEnabled() {
            return this.listLabel.isEnabled();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.insert == e.getSource() || this.host == e.getSource()) {
                String portText;
                StringBuilder addHost = new StringBuilder(this.host.getText());
                if (null != this.port && (portText = this.port.getText().trim()).length() > 0) {
                    addHost.append(':');
                    addHost.append(portText);
                }
                if (this.addItem(addHost.toString())) {
                    this.host.setText("");
                    this.host.setCaretPosition(0);
                    if (null != this.port) {
                        this.port.setText("");
                        this.port.setCaretPosition(0);
                    }
                }
                return;
            }
            if (e.getSource() == this.remove) {
                int[] sel = this.list.getSelectedIndexes();
                int i = sel.length;
                while (i-- > 0) {
                    this.list.remove(sel[i]);
                }
                return;
            }
            if (e.getSource() == this.list) {
                String cmd = e.getActionCommand();
                if (null != this.port) {
                    int colonAt = cmd.lastIndexOf(58);
                    String newHost = cmd.substring(0, colonAt);
                    String newPort = cmd.substring(colonAt + 1);
                    this.host.setText(newHost);
                    this.host.setCaretPosition(newHost.length());
                    this.port.setText(newPort);
                    this.port.setCaretPosition(newHost.length());
                } else {
                    this.host.setText(cmd);
                    this.host.setCaretPosition(cmd.length());
                }
            }
        }

        public boolean addItem(String item) {
            String hostURI = item.trim();
            if (0 == hostURI.trim().length()) {
                return false;
            }
            try {
                new URI(hostURI);
            }
            catch (URISyntaxException failed) {
                return false;
            }
            try {
                try {
                    while (true) {
                        this.list.remove(hostURI);
                    }
                }
                catch (IllegalArgumentException notThere) {
                    this.list.add(hostURI);
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public String[] getItems() {
            return this.list.getItems();
        }
    }

    static class HostPortPanel
    extends Panel
    implements ItemListener {
        private final Checkbox useMe;
        private Label addressLabel = null;
        private final TextField host;
        private final TextField port;

        HostPortPanel(String checkLabel, String addrLabel, String defaultHost, String defaultPort, boolean defaultState) {
            super(new GridBagLayout());
            this.useMe = new Checkbox(checkLabel, defaultState);
            this.host = new TextField(defaultHost, 25);
            this.port = new TextField(defaultPort, 6);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = null == addrLabel ? 2 : 3;
            constraints.anchor = 23;
            if (null != checkLabel) {
                this.add((Component)this.useMe, constraints);
                if (null != addrLabel) {
                    ++constraints.gridy;
                    constraints.gridx = 0;
                    constraints.anchor = 25;
                } else {
                    ++constraints.gridx;
                    constraints.gridx = -1;
                }
            }
            if (null != addrLabel) {
                constraints.gridwidth = 1;
                this.addressLabel = new Label(addrLabel, 2);
                this.add((Component)this.addressLabel, constraints);
            }
            constraints.gridx = -1;
            this.add((Component)this.host, constraints);
            this.add((Component)this.port, constraints);
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            this.setState(this.useMe.getState());
        }

        public boolean getState() {
            return this.useMe.getState() && this.isEnabled();
        }

        public void setEnabled(boolean enabling) {
            super.setEnabled(enabling);
            this.useMe.setEnabled(enabling);
            if (null != this.addressLabel) {
                this.addressLabel.setEnabled(this.useMe.getState());
            }
            this.host.setEnabled(this.useMe.getState());
            this.port.setEnabled(this.useMe.getState());
        }

        public void setState(boolean state) {
            this.useMe.setState(state);
            if (null != this.addressLabel) {
                this.addressLabel.setEnabled(state);
            }
            this.host.setEnabled(state);
            this.port.setEnabled(state);
        }

        public String getHost() {
            return this.host.getText().trim();
        }

        public String getPort() {
            return this.port.getText().trim();
        }
    }

    static class PagesPanel
    extends Panel
    implements ActionListener {
        private final CardLayout layout = new CardLayout();
        private final Panel pages = new Panel(this.layout);
        private final Panel buttons = new Panel(new FlowLayout(0, 0, 0));

        public PagesPanel() {
            super(new BorderLayout());
            this.add((Component)this.pages, "Center");
            this.add((Component)this.buttons, "North");
        }

        public void actionPerformed(ActionEvent e) {
            this.layout.show(this.pages, e.getActionCommand());
        }

        public PanelGBL addPage(String buttonName, String comment) {
            BorderPanelGBL p = new BorderPanelGBL(buttonName, comment, 1);
            this.pages.add((Component)p, buttonName);
            Button b = new Button(buttonName);
            this.buttons.add(b);
            b.addActionListener(this);
            return p;
        }

        public void showPage(String pageName) {
            this.layout.show(this.pages, pageName);
        }
    }

    static class BorderPanelGBL
    extends PanelGBL {
        public static final int NONE = 0;
        public static final int RAISED = 1;
        public static final int LOWERED = 2;
        public static final int GROOVE = 3;
        public static final int BUMP = 4;
        int style = 3;
        String title;
        int ascent = 0;
        int descent = 0;
        int leading = 0;
        int titleWidth = 0;

        public BorderPanelGBL(String title) {
            this.title = title;
        }

        public BorderPanelGBL(String title, String advice) {
            super(advice);
            this.title = title;
        }

        public BorderPanelGBL(String title, String advice, int s) {
            super(advice);
            this.title = title;
            if (s < 0 && s > 4) {
                return;
            }
            if (s == 1 || s == 2) {
                this.title = null;
            }
            this.style = s;
        }

        private void checkMetrics() {
            Font font = this.getFont();
            if (this.title == null || font == null) {
                this.ascent = 2;
            } else {
                FontMetrics fmetrics = this.getFontMetrics(font);
                this.ascent = fmetrics.getAscent();
                this.descent = fmetrics.getDescent();
                this.leading = fmetrics.getLeading();
                this.titleWidth = fmetrics.stringWidth(this.title);
            }
            this.insets = new Insets(this.descent + this.ascent + this.leading + 2, 7, 7, 7);
        }

        public Insets getInsets() {
            this.checkMetrics();
            return this.insets;
        }

        private void paintLowered(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.black);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(this.getBackground());
            g.drawRect(2, this.ascent - 1, d.width - 5, d.height - this.ascent - 1);
        }

        private void paintRaised(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.black);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(this.getBackground());
            g.drawRect(2, this.ascent - 1, d.width - 5, d.height - this.ascent - 1);
        }

        private void paintGroove(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.black);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
            g.drawString(this.title, 12, this.ascent + 1);
            g.setColor(Color.black);
            g.drawString(this.title, 13, this.ascent + 2);
            g.clearRect(0, 0, d.width, 1);
        }

        private void paintBump(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.black);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
            g.drawString(this.title, 12, this.ascent + 1);
            g.setColor(Color.black);
            g.drawString(this.title, 13, this.ascent + 2);
            g.clearRect(0, 0, d.width, 1);
        }

        public void paint(Graphics g) {
            switch (this.style) {
                case 3: {
                    this.paintGroove(g);
                    break;
                }
                case 4: {
                    this.paintBump(g);
                    break;
                }
                case 1: {
                    this.paintRaised(g);
                    break;
                }
                case 2: {
                    this.paintLowered(g);
                    break;
                }
            }
            super.paint(g);
        }
    }

    static class PanelGBL
    extends Panel {
        protected Insets insets = new Insets(0, 0, 0, 0);
        GridBagLayout lay = new GridBagLayout();
        private static final GridBagConstraints constrLabel = new GridBagConstraints();

        public PanelGBL(String label) {
            this();
            this.add((Component)new Label(label, 0), constrLabel);
        }

        public PanelGBL() {
            this.setLayout(this.lay);
        }

        public Insets getInsets() {
            return this.insets;
        }

        static {
            PanelGBL.constrLabel.gridwidth = 0;
            PanelGBL.constrLabel.gridheight = 1;
            PanelGBL.constrLabel.gridy = -1;
            PanelGBL.constrLabel.weightx = 1.0;
            PanelGBL.constrLabel.weighty = 1.0;
            PanelGBL.constrLabel.anchor = 23;
            PanelGBL.constrLabel.fill = 2;
        }
    }
}

