/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.meter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.meter.MonitorFilterException;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class MonitorFilter
implements DocumentSerializable {
    private String description;
    private Map<ModuleClassID, ServiceMonitorFilter> serviceMonitorFilters = new HashMap<ModuleClassID, ServiceMonitorFilter>();
    private List<ModuleClassID> unknownModuleClassIDs;

    public MonitorFilter() {
    }

    public MonitorFilter(String description) {
        this.description = description;
    }

    public ServiceMonitorFilter addServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter) throws MonitorFilterException {
        ModuleClassID moduleClassID = serviceMonitorFilter.getModuleClassID();
        if (this.serviceMonitorFilters.get(moduleClassID) != null) {
            throw new MonitorFilterException("Attempt to add a second Monitor Filter for: " + moduleClassID);
        }
        this.serviceMonitorFilters.put(moduleClassID, serviceMonitorFilter);
        return serviceMonitorFilter;
    }

    public ServiceMonitorFilter getServiceMonitorFilter(ModuleClassID moduleClassID) {
        return this.serviceMonitorFilters.get(moduleClassID);
    }

    public void removeServiceMonitorFilter(ModuleClassID moduleClassID) {
        this.serviceMonitorFilters.remove(moduleClassID);
    }

    public int getServiceMonitorFilterCount() {
        return this.serviceMonitorFilters.size();
    }

    public Iterator getModuleClassIDs() {
        return this.serviceMonitorFilters.keySet().iterator();
    }

    public Iterator getServiceMonitorFilters() {
        return this.serviceMonitorFilters.values().iterator();
    }

    public boolean isUnknownModuleClassIDs() {
        return this.unknownModuleClassIDs != null;
    }

    public Iterator getUnknownModuleClassIDs() {
        if (this.unknownModuleClassIDs != null) {
            return this.unknownModuleClassIDs.iterator();
        }
        return new LinkedList().iterator();
    }

    public String getDescription() {
        return this.description;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "description", this.description);
        for (ServiceMonitorFilter serviceMonitorFilter : this.serviceMonitorFilters.values()) {
            Element serviceElement = DocumentSerializableUtilities.createChildElement(element2, "service");
            DocumentSerializableUtilities.addString(serviceElement, "moduleClassID", serviceMonitorFilter.getModuleClassID().toString());
            DocumentSerializableUtilities.addDocumentSerializable(serviceElement, "serviceFilter", serviceMonitorFilter);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement serviceElement = (TextElement)e.nextElement();
            String tagName = (String)serviceElement.getKey();
            if (!tagName.equals("service")) continue;
            try {
                ModuleClassID moduleClassID = (ModuleClassID)IDFactory.fromURI(new URI(DocumentSerializableUtilities.getString(serviceElement, "moduleClassID", "ERROR")));
                try {
                    ServiceMonitorFilter serviceMonitorFilter = MonitorResources.createServiceMonitorFilter(moduleClassID);
                    serviceMonitorFilter.init(moduleClassID);
                    Element serviceMonitorFilterElement = DocumentSerializableUtilities.getChildElement(serviceElement, "serviceFilter");
                    serviceMonitorFilter.initializeFrom(serviceMonitorFilterElement);
                    this.serviceMonitorFilters.put(moduleClassID, serviceMonitorFilter);
                }
                catch (Exception ex) {
                    if (this.unknownModuleClassIDs == null) {
                        this.unknownModuleClassIDs = new LinkedList<ModuleClassID>();
                    }
                    this.unknownModuleClassIDs.add(moduleClassID);
                }
            }
            catch (URISyntaxException jex) {
                throw new DocumentSerializationException("Can't get ModuleClassID", jex);
            }
        }
    }
}

