/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;

class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator();
    private static final Type DISPATCHER = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.Dispatcher");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    DispatcherGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context) {
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            if (Modifier.isProtected(method.getModifiers())) continue;
            CodeEmitter e = ce.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            context.emitCallback(e, context.getIndex(method));
            e.invoke_interface(DISPATCHER, LOAD_OBJECT);
            e.checkcast(Type.getType(method.getDeclaringClass()));
            e.load_args();
            e.invoke(method);
            e.return_value();
            e.end_method();
        }
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context) {
    }
}

