/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.logicalcobwebs.concurrent.ReaderPreferenceReadWriteLock;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.CompositeConnectionListener;
import org.logicalcobwebs.proxool.CompositeStateListener;
import org.logicalcobwebs.proxool.ConnectionInfo;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionListenerIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.ConnectionResetter;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.Prototyper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyFactory;
import org.logicalcobwebs.proxool.ShutdownHook;
import org.logicalcobwebs.proxool.StateListenerIF;
import org.logicalcobwebs.proxool.admin.Admin;
import org.logicalcobwebs.proxool.util.FastArrayList;

class ConnectionPool
implements ConnectionPoolStatisticsIF {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ConnectionPool == null ? (class$org$logicalcobwebs$proxool$ConnectionPool = ConnectionPool.class$("org.logicalcobwebs.proxool.ConnectionPool")) : class$org$logicalcobwebs$proxool$ConnectionPool);
    private Log log;
    private ReaderPreferenceReadWriteLock connectionStatusReadWriteLock = new ReaderPreferenceReadWriteLock();
    private WriterPreferenceReadWriteLock primaryReadWriteLock = new WriterPreferenceReadWriteLock();
    private static final String[] STATUS_DESCRIPTIONS = new String[]{"NULL", "AVAILABLE", "ACTIVE", "OFFLINE"};
    private static final String MSG_MAX_CONNECTION_COUNT = "Couldn't get connection because we are at maximum connection count and there are none available";
    private List proxyConnections;
    private int nextAvailableConnection = 0;
    private int connectionCount = 0;
    private long connectionsServedCount = 0L;
    private long connectionsRefusedCount = 0L;
    private int[] connectionCountByState = new int[4];
    private ConnectionPoolDefinition definition;
    private CompositeConnectionListener compositeConnectionListener = new CompositeConnectionListener();
    private CompositeStateListener compositeStateListener = new CompositeStateListener();
    private long timeOfLastRefusal = 0L;
    private int upState;
    private static boolean loggedLegend;
    private Admin admin;
    private boolean locked = false;
    private Date dateStarted = new Date();
    private boolean connectionPoolUp = false;
    private Thread shutdownThread;
    private Prototyper prototyper;
    private ConnectionResetter connectionResetter;
    protected static final boolean FORCE_EXPIRY = true;
    protected static final boolean REQUEST_EXPIRY = false;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ConnectionPool;

    protected ConnectionPool(ConnectionPoolDefinition definition) throws ProxoolException {
        FastArrayList fal = new FastArrayList();
        fal.setFast(true);
        this.proxyConnections = fal;
        this.log = LogFactory.getLog("org.logicalcobwebs.proxool." + definition.getAlias());
        this.connectionResetter = new ConnectionResetter(this.log, definition.getDriver());
        this.setDefinition(definition);
        if (definition.getStatistics() != null) {
            try {
                this.admin = new Admin(definition);
            }
            catch (ProxoolException e) {
                this.log.error("Failed to initialise statistics", e);
            }
        }
        ShutdownHook.init();
    }

    protected void start() throws ProxoolException {
        this.connectionPoolUp = true;
        this.prototyper = new Prototyper(this);
        HouseKeeperController.register(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection getConnection() throws SQLException {
        ProxyConnectionIF proxyConnection;
        block26: {
            String requester = Thread.currentThread().getName();
            if (this.connectionCount >= this.getDefinition().getMaximumConnectionCount() && this.getAvailableConnectionCount() < 1) {
                ++this.connectionsRefusedCount;
                if (this.admin != null) {
                    this.admin.connectionRefused();
                }
                this.log.info(this.displayStatistics() + " - " + MSG_MAX_CONNECTION_COUNT);
                this.timeOfLastRefusal = System.currentTimeMillis();
                this.setUpState(2);
                throw new SQLException(MSG_MAX_CONNECTION_COUNT);
            }
            try {
                PrototyperController.checkSimultaneousBuildThrottle(this.getDefinition().getAlias());
            }
            catch (ProxoolException e) {
                this.log.error("Unexpected problem", e);
                throw new SQLException(e.getMessage());
            }
            proxyConnection = null;
            try {
                try {
                    for (int connectionsTried = 0; connectionsTried < this.proxyConnections.size(); ++this.nextAvailableConnection, ++connectionsTried) {
                        try {
                            proxyConnection = (ProxyConnectionIF)this.proxyConnections.get(this.nextAvailableConnection);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.nextAvailableConnection = 0;
                            proxyConnection = (ProxyConnectionIF)this.proxyConnections.get(this.nextAvailableConnection);
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.nextAvailableConnection = 0;
                            proxyConnection = (ProxyConnectionIF)this.proxyConnections.get(this.nextAvailableConnection);
                        }
                        if (proxyConnection != null && proxyConnection.setStatus(1, 2)) {
                            if (this.getDefinition().isTestBeforeUse() && !this.testConnection(proxyConnection)) {
                                proxyConnection = null;
                            }
                            if (proxyConnection == null) continue;
                            ++this.nextAvailableConnection;
                            break;
                        }
                        proxyConnection = null;
                    }
                    if (proxyConnection == null) {
                        try {
                            proxyConnection = PrototyperController.buildConnection(this.getDefinition().getAlias(), 2, "on demand");
                            if (this.getDefinition().isTestBeforeUse() && !this.testConnection(proxyConnection)) {
                                throw new SQLException("Created a new connection but it failed its test");
                            }
                        }
                        catch (SQLException e) {
                            throw e;
                        }
                        catch (ProxoolException e) {
                            this.log.debug("Couldn't get connection", e);
                            throw new SQLException(e.toString());
                        }
                        catch (Throwable e) {
                            this.log.error("Couldn't get connection", e);
                            throw new SQLException(e.toString());
                        }
                    }
                    Object var6_13 = null;
                    if (proxyConnection != null) {
                        ++this.connectionsServedCount;
                        proxyConnection.setRequester(requester);
                        break block26;
                    }
                    ++this.connectionsRefusedCount;
                    if (this.admin != null) {
                        this.admin.connectionRefused();
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Throwable t) {
                    this.log.error("Problem getting connection", t);
                    throw new SQLException(t.toString());
                }
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                if (proxyConnection != null) {
                    ++this.connectionsServedCount;
                    proxyConnection.setRequester(requester);
                    throw throwable;
                }
                ++this.connectionsRefusedCount;
                if (this.admin != null) {
                    this.admin.connectionRefused();
                }
                this.timeOfLastRefusal = System.currentTimeMillis();
                this.setUpState(2);
                throw throwable;
            }
            this.timeOfLastRefusal = System.currentTimeMillis();
            this.setUpState(2);
        }
        if (proxyConnection == null) {
            throw new SQLException("Unknown reason for not getting connection. Sorry.");
        }
        if (!this.log.isDebugEnabled()) return ProxyFactory.getConnection(proxyConnection);
        if (!this.getDefinition().isVerbose()) return ProxyFactory.getConnection(proxyConnection);
        this.log.debug(this.displayStatistics() + " - Connection #" + proxyConnection.getId() + " served");
        return ProxyFactory.getConnection(proxyConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean testConnection(ProxyConnectionIF proxyConnection) {
        Statement s;
        boolean success;
        block8: {
            success = false;
            String testSql = this.getDefinition().getHouseKeepingTestSql();
            if (testSql == null) return success;
            if (testSql.length() <= 0) return success;
            s = null;
            s = proxyConnection.getConnection().createStatement();
            s.execute(testSql);
            success = true;
            if (!LOG.isDebugEnabled()) break block8;
            LOG.debug(this.displayStatistics() + " - Connection #" + proxyConnection.getId() + " tested: OK");
        }
        Object var7_5 = null;
        if (s == null) return success;
        try {
            s.close();
            return success;
        }
        catch (Throwable t2) {
            return false;
        }
        {
            catch (Throwable t) {
                proxyConnection.setStatus(0);
                this.removeProxyConnection(proxyConnection, "it has problems: " + t, false, true);
                Object var7_6 = null;
                if (s == null) return success;
                try {
                    s.close();
                    return success;
                }
                catch (Throwable t2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Throwable t2) {
                success = false;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyConnection(ProxyConnectionIF proxyConnection) {
        try {
            this.acquireConnectionStatusWriteLock();
            this.proxyConnections.add(proxyConnection);
            int n = proxyConnection.getStatus();
            this.connectionCountByState[n] = this.connectionCountByState[n] + 1;
        }
        finally {
            this.releaseConnectionStatusWriteLock();
        }
    }

    protected static String getStatusDescription(int status) {
        try {
            return STATUS_DESCRIPTIONS[status];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown status: " + status;
        }
    }

    protected void putConnection(ProxyConnectionIF proxyConnection) {
        if (this.admin != null) {
            long start;
            long now = System.currentTimeMillis();
            if (now - (start = proxyConnection.getTimeLastStartActive()) < 0L) {
                this.log.warn("Future start time detected. #" + proxyConnection.getId() + " start = " + new Date(start) + " (" + (now - start) + " milliseconds)");
            } else if (now - start > 1000000L) {
                this.log.warn("Suspiciously long active time. #" + proxyConnection.getId() + " start = " + new Date(start));
            }
            this.admin.connectionReturned(now - start);
        }
        if (proxyConnection.isMarkedForExpiry()) {
            if (proxyConnection.setStatus(2, 0)) {
                this.expireProxyConnection(proxyConnection, proxyConnection.getReasonForMark(), false);
            }
        } else {
            if (this.getDefinition().isTestAfterUse()) {
                this.testConnection(proxyConnection);
            }
            if (!proxyConnection.setStatus(2, 1)) {
                this.log.warn("Unable to set status of connection " + proxyConnection.getId() + " from " + ConnectionPool.getStatusDescription(2) + "to " + ConnectionPool.getStatusDescription(1) + ". It remains " + ConnectionPool.getStatusDescription(proxyConnection.getStatus()));
            }
        }
        if (this.log.isDebugEnabled() && this.getDefinition().isVerbose()) {
            this.log.debug(this.displayStatistics() + " - Connection #" + proxyConnection.getId() + " returned (now " + ConnectionPool.getStatusDescription(proxyConnection.getStatus()) + ")");
        }
    }

    protected void throwConnection(ProxyConnectionIF proxyConnection, String reason) {
        this.expireConnectionAsSoonAsPossible(proxyConnection, reason, true);
    }

    private ProxyConnectionIF getProxyConnection(int i) {
        return (ProxyConnectionIF)this.proxyConnections.get(i);
    }

    protected ProxyConnectionIF[] getProxyConnections() {
        return this.proxyConnections.toArray(new ProxyConnectionIF[this.proxyConnections.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProxyConnection(ProxyConnectionIF proxyConnection, String reason, boolean forceExpiry, boolean triggerSweep) {
        if (forceExpiry || proxyConnection.isNull()) {
            proxyConnection.setStatus(0);
            try {
                this.onDeath(proxyConnection.getConnection());
            }
            catch (SQLException e) {
                this.log.error("Problem during onDeath (ignored)", e);
            }
            try {
                proxyConnection.reallyClose();
            }
            catch (SQLException e) {
                this.log.error(e);
            }
            try {
                if (this.isConnectionPoolUp()) {
                    this.acquireConnectionStatusWriteLock();
                }
                this.proxyConnections.remove(proxyConnection);
            }
            finally {
                if (this.isConnectionPoolUp()) {
                    this.releaseConnectionStatusWriteLock();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " removed because " + reason + ".");
            }
            if (triggerSweep) {
                PrototyperController.triggerSweep(this.getDefinition().getAlias());
            }
        } else {
            this.log.error(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " was not removed because isNull() was false.");
        }
    }

    protected void expireProxyConnection(ProxyConnectionIF proxyConnection, String reason, boolean forceExpiry) {
        this.removeProxyConnection(proxyConnection, reason, forceExpiry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void shutdown(int delay, String finalizerName) throws Throwable {
        String alias = this.getDefinition().getAlias();
        try {
            this.acquirePrimaryWriteLock();
            if (this.connectionPoolUp) {
                block34: {
                    this.connectionPoolUp = false;
                    long startFinalize = System.currentTimeMillis();
                    this.shutdownThread = Thread.currentThread();
                    if (delay > 0) {
                        this.log.info("Shutting down '" + alias + "' pool started at " + this.dateStarted + " - waiting for " + delay + " milliseconds for everything to stop.  [ " + finalizerName + "]");
                    } else {
                        this.log.info("Shutting down '" + alias + "' pool immediately [" + finalizerName + "]");
                    }
                    boolean connectionClosedManually = false;
                    try {
                        try {
                            block33: {
                                try {
                                    HouseKeeperController.cancel(alias);
                                }
                                catch (ProxoolException e) {
                                    this.log.error("Shutdown couldn't cancel house keeper", e);
                                }
                                if (this.admin != null) {
                                    this.admin.cancelAll();
                                }
                                if (this.connectionCountByState[2] != 0) {
                                    int activeCount;
                                    long endWait = startFinalize + (long)delay;
                                    LOG.info("Waiting until " + new Date(endWait) + " for all connections to become inactive (active count is " + this.connectionCountByState[2] + ").");
                                    while (true) {
                                        long timeout;
                                        if ((timeout = endWait - System.currentTimeMillis()) > 0L) {
                                            Thread thread = Thread.currentThread();
                                            synchronized (thread) {
                                                try {
                                                    Thread.currentThread().wait(timeout);
                                                }
                                                catch (InterruptedException e) {
                                                    this.log.debug("Interrupted whilst sleeping.");
                                                }
                                            }
                                        }
                                        if ((activeCount = this.connectionCountByState[2]) == 0) break block33;
                                        if (System.currentTimeMillis() >= endWait) break;
                                        LOG.info("Still waiting for active count to reach zero (currently " + activeCount + ").");
                                        Thread.sleep(100L);
                                    }
                                    LOG.warn("Shutdown waited for " + (System.currentTimeMillis() - startFinalize) + " milliseconds for all " + "the connections to become inactive but the active count is still " + activeCount + ". Shutting down anyway.");
                                }
                            }
                            try {
                                PrototyperController.cancel(alias);
                            }
                            catch (NullPointerException e) {
                                this.log.error("PrototypingThread already dead", e);
                            }
                            catch (Exception e) {
                                this.log.error("Can't wake prototypingThread", e);
                            }
                            for (int i = this.proxyConnections.size() - 1; i >= 0; --i) {
                                long id = this.getProxyConnection(i).getId();
                                try {
                                    connectionClosedManually = true;
                                    this.removeProxyConnection(this.getProxyConnection(i), "of shutdown", true, false);
                                    if (!this.log.isDebugEnabled()) continue;
                                    this.log.debug("Connection #" + id + " closed");
                                    continue;
                                }
                                catch (Throwable t) {
                                    if (!this.log.isDebugEnabled()) continue;
                                    this.log.debug("Problem closing connection #" + id, t);
                                }
                            }
                            Object var15_20 = null;
                            ConnectionPoolManager.getInstance().removeConnectionPool(alias);
                            if (!this.log.isDebugEnabled()) break block34;
                            this.log.info("'" + alias + "' pool has been closed down by " + finalizerName + " in " + (System.currentTimeMillis() - startFinalize) + " milliseconds.");
                            if (!connectionClosedManually) {
                                this.log.debug("No connections required manual removal.");
                            }
                        }
                        catch (Throwable t) {
                            this.log.error("Unknown problem finalizing pool", t);
                            Object var15_21 = null;
                            ConnectionPoolManager.getInstance().removeConnectionPool(alias);
                            if (this.log.isDebugEnabled()) {
                                this.log.info("'" + alias + "' pool has been closed down by " + finalizerName + " in " + (System.currentTimeMillis() - startFinalize) + " milliseconds.");
                                if (!connectionClosedManually) {
                                    this.log.debug("No connections required manual removal.");
                                }
                            }
                            super.finalize();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_22 = null;
                        ConnectionPoolManager.getInstance().removeConnectionPool(alias);
                        if (this.log.isDebugEnabled()) {
                            this.log.info("'" + alias + "' pool has been closed down by " + finalizerName + " in " + (System.currentTimeMillis() - startFinalize) + " milliseconds.");
                            if (!connectionClosedManually) {
                                this.log.debug("No connections required manual removal.");
                            }
                        }
                        super.finalize();
                        throw throwable;
                    }
                }
                super.finalize();
                return;
            }
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Ignoring duplicate attempt to shutdown '" + alias + "' pool by " + finalizerName);
            return;
        }
        catch (Throwable t) {
            this.log.error(finalizerName + " couldn't shutdown pool", t);
            return;
        }
        finally {
            this.releasePrimaryWriteLock();
        }
    }

    public int getAvailableConnectionCount() {
        return this.connectionCountByState[1];
    }

    public int getActiveConnectionCount() {
        return this.connectionCountByState[2];
    }

    public int getOfflineConnectionCount() {
        return this.connectionCountByState[3];
    }

    protected String displayStatistics() {
        if (!loggedLegend) {
            this.log.info("Proxool statistics legend: \"s - r  (a/t/o)\" > s=served, r=refused (only shown if non-zero), a=active, t=total, o=offline (being tested)");
            loggedLegend = true;
        }
        StringBuffer statistics = new StringBuffer();
        statistics.append(FormatHelper.formatBigNumber(this.getConnectionsServedCount()));
        if (this.getConnectionsRefusedCount() > 0L) {
            statistics.append(" -");
            statistics.append(FormatHelper.formatBigNumber(this.getConnectionsRefusedCount()));
        }
        statistics.append(" (");
        statistics.append(FormatHelper.formatSmallNumber(this.getActiveConnectionCount()));
        statistics.append("/");
        statistics.append(FormatHelper.formatSmallNumber(this.getAvailableConnectionCount() + this.getActiveConnectionCount()));
        statistics.append("/");
        statistics.append(FormatHelper.formatSmallNumber(this.getOfflineConnectionCount()));
        statistics.append(")");
        return statistics.toString();
    }

    protected void expireAllConnections(String reason, boolean merciful) {
        HashSet pcs = new HashSet();
        for (int i = this.proxyConnections.size() - 1; i >= 0; --i) {
            pcs.add(this.proxyConnections.get(i));
        }
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            ProxyConnectionIF pc = (ProxyConnectionIF)i.next();
            this.expireConnectionAsSoonAsPossible(pc, reason, merciful);
        }
    }

    protected void expireConnectionAsSoonAsPossible(ProxyConnectionIF proxyConnection, String reason, boolean merciful) {
        if (proxyConnection.setStatus(1, 3)) {
            if (proxyConnection.setStatus(3, 0)) {
                this.expireProxyConnection(proxyConnection, reason, false);
            }
        } else if (merciful) {
            proxyConnection.markForExpiry(reason);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " marked for expiry.");
            }
        } else {
            this.expireProxyConnection(proxyConnection, reason, true);
        }
    }

    protected void registerRemovedConnection(int status) {
        --this.connectionCount;
        PrototyperController.connectionRemoved(this.getDefinition().getAlias());
        int n = status;
        this.connectionCountByState[n] = this.connectionCountByState[n] - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeStatus(int oldStatus, int newStatus) {
        int n = oldStatus;
        this.connectionCountByState[n] = this.connectionCountByState[n] - 1;
        int n2 = newStatus;
        this.connectionCountByState[n2] = this.connectionCountByState[n2] + 1;
        if (this.shutdownThread != null && this.connectionCountByState[2] == 0) {
            Thread thread = this.shutdownThread;
            synchronized (thread) {
                this.shutdownThread.notify();
            }
        }
    }

    public long getConnectionsServedCount() {
        return this.connectionsServedCount;
    }

    public long getConnectionsRefusedCount() {
        return this.connectionsRefusedCount;
    }

    protected ConnectionPoolDefinition getDefinition() {
        return this.definition;
    }

    protected synchronized void setDefinition(ConnectionPoolDefinition definition) throws ProxoolException {
        this.definition = definition;
        try {
            Class.forName(definition.getDriver());
        }
        catch (ClassNotFoundException e) {
            this.log.error("Couldn't load class " + definition.getDriver(), e);
            throw new ProxoolException("Couldn't load class " + definition.getDriver());
        }
        catch (NullPointerException e) {
            this.log.error("Definition did not contain driver", e);
            throw new ProxoolException("Definition did not contain driver");
        }
    }

    public void setStateListener(StateListenerIF stateListener) {
        this.addStateListener(stateListener);
    }

    public void addStateListener(StateListenerIF stateListener) {
        this.compositeStateListener.addListener(stateListener);
    }

    public boolean removeStateListener(StateListenerIF stateListener) {
        return this.compositeStateListener.removeListener(stateListener);
    }

    public void setConnectionListener(ConnectionListenerIF connectionListener) {
        this.addConnectionListener(connectionListener);
    }

    public void addConnectionListener(ConnectionListenerIF connectionListener) {
        this.compositeConnectionListener.addListener(connectionListener);
    }

    public boolean removeConnectionListener(ConnectionListenerIF connectionListener) {
        return this.compositeConnectionListener.removeListener(connectionListener);
    }

    protected void onBirth(Connection connection) throws SQLException {
        this.compositeConnectionListener.onBirth(connection);
    }

    protected void onDeath(Connection connection) throws SQLException {
        this.compositeConnectionListener.onDeath(connection);
    }

    protected void onExecute(String command, long elapsedTime, Exception exception) throws SQLException {
        if (exception == null) {
            this.compositeConnectionListener.onExecute(command, elapsedTime);
        } else {
            this.compositeConnectionListener.onFail(command, exception);
        }
    }

    protected boolean isConnectionListenedTo() {
        return !this.compositeConnectionListener.isEmpty();
    }

    public String toString() {
        return this.getDefinition().toString();
    }

    public int getUpState() {
        return this.upState;
    }

    public void setUpState(int upState) {
        if (this.upState != upState) {
            this.compositeStateListener.upStateChanged(upState);
            this.upState = upState;
        }
    }

    protected Collection getConnectionInfos() {
        TreeSet<ConnectionInfo> cis = null;
        cis = new TreeSet<ConnectionInfo>();
        Iterator i = this.proxyConnections.iterator();
        while (i.hasNext()) {
            ConnectionInfoIF connectionInfo = (ConnectionInfoIF)i.next();
            ConnectionInfo ci = new ConnectionInfo();
            ci.setAge(connectionInfo.getAge());
            ci.setBirthDate(connectionInfo.getBirthDate());
            ci.setId(connectionInfo.getId());
            ci.setMark(connectionInfo.getMark());
            ci.setRequester(connectionInfo.getRequester());
            ci.setStatus(connectionInfo.getStatus());
            ci.setTimeLastStartActive(connectionInfo.getTimeLastStartActive());
            ci.setTimeLastStopActive(connectionInfo.getTimeLastStopActive());
            ci.setDelegateUrl(connectionInfo.getDelegateUrl());
            ci.setProxyHashcode(connectionInfo.getProxyHashcode());
            ci.setDelegateHashcode(connectionInfo.getDelegateHashcode());
            cis.add(ci);
        }
        return cis;
    }

    public boolean expireConnection(long id, boolean forceExpiry) {
        boolean success = false;
        ProxyConnection proxyConnection = null;
        for (int connectionsTried = 0; connectionsTried < this.proxyConnections.size(); ++connectionsTried) {
            try {
                proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.nextAvailableConnection = 0;
                proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
            }
            if (proxyConnection.getId() == id) {
                proxyConnection.setStatus(1, 3);
                proxyConnection.setStatus(3, 0);
                this.removeProxyConnection(proxyConnection, "it was manually killed", forceExpiry, true);
                success = true;
                break;
            }
            ++this.nextAvailableConnection;
        }
        if (!success && this.log.isDebugEnabled()) {
            this.log.debug(this.displayStatistics() + " - couldn't find " + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " and I've just been asked to expire it");
        }
        return success;
    }

    public Log getLog() {
        return this.log;
    }

    protected void initialiseConnectionResetter(Connection connection) {
        this.connectionResetter.initialise(connection);
    }

    protected boolean resetConnection(Connection connection, String id) {
        return this.connectionResetter.reset(connection, id);
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    protected Admin getAdmin() {
        return this.admin;
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void lock() {
        this.locked = true;
    }

    protected void unlock() {
        this.locked = false;
    }

    protected void acquirePrimaryReadLock() throws InterruptedException {
        this.primaryReadWriteLock.readLock().acquire();
    }

    protected void releasePrimaryReadLock() {
        this.primaryReadWriteLock.readLock().release();
    }

    protected void acquirePrimaryWriteLock() throws InterruptedException {
        boolean success = false;
        this.primaryReadWriteLock.writeLock().acquire();
        success = true;
    }

    protected void releasePrimaryWriteLock() {
        this.primaryReadWriteLock.writeLock().release();
    }

    protected boolean isConnectionPoolUp() {
        return this.connectionPoolUp;
    }

    protected long getTimeOfLastRefusal() {
        return this.timeOfLastRefusal;
    }

    protected void acquireConnectionStatusWriteLock() {
        try {
            this.connectionStatusReadWriteLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            this.log.error("Couldn't acquire connectionStatus write lock", e);
        }
    }

    protected void releaseConnectionStatusWriteLock() {
        this.connectionStatusReadWriteLock.writeLock().release();
    }

    protected void acquireConnectionStatusReadLock() {
        try {
            this.connectionStatusReadWriteLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            this.log.error("Couldn't acquire connectionStatus read lock", e);
        }
    }

    protected void releaseConnectionStatusReadLock() {
        this.connectionStatusReadWriteLock.readLock().release();
    }

    protected Prototyper getPrototyper() {
        return this.prototyper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

