/*
 * Decompiled with CFR 0.152.
 */
package com.github.orderbyhelper;

import com.github.orderbyhelper.sqlsource.OrderByDynamicSqlSource;
import com.github.orderbyhelper.sqlsource.OrderByProviderSqlSource;
import com.github.orderbyhelper.sqlsource.OrderByRawSqlSource;
import com.github.orderbyhelper.sqlsource.OrderBySqlSource;
import com.github.orderbyhelper.sqlsource.OrderByStaticSqlSource;
import java.util.Properties;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class OrderByHelper
implements Interceptor {
    private static final ThreadLocal<String> ORDER_BY = new ThreadLocal();

    public static String getOrderBy() {
        String orderBy = ORDER_BY.get();
        if (orderBy == null || orderBy.length() == 0) {
            return null;
        }
        return orderBy;
    }

    public static void orderBy(String orderBy) {
        ORDER_BY.set(orderBy);
    }

    public static void clear() {
        ORDER_BY.remove();
    }

    public static boolean hasOrderBy(MappedStatement ms) {
        return ms.getSqlSource() instanceof OrderBySqlSource;
    }

    public static void processIntercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (!OrderByHelper.hasOrderBy(ms)) {
            MetaObject msObject = SystemMetaObject.forObject((Object)ms);
            SqlSource sqlSource = ms.getSqlSource();
            if (sqlSource instanceof StaticSqlSource) {
                msObject.setValue("sqlSource", (Object)new OrderByStaticSqlSource((StaticSqlSource)sqlSource));
            } else if (sqlSource instanceof RawSqlSource) {
                msObject.setValue("sqlSource", (Object)new OrderByRawSqlSource((RawSqlSource)sqlSource));
            } else if (sqlSource instanceof ProviderSqlSource) {
                msObject.setValue("sqlSource", (Object)new OrderByProviderSqlSource((ProviderSqlSource)sqlSource));
            } else if (sqlSource instanceof DynamicSqlSource) {
                msObject.setValue("sqlSource", (Object)new OrderByDynamicSqlSource((DynamicSqlSource)sqlSource));
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u5904\u7406\u8be5\u7c7b\u578b[" + sqlSource.getClass() + "]\u7684SqlSource");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        try {
            if (OrderByHelper.getOrderBy() != null) {
                OrderByHelper.processIntercept(invocation);
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            OrderByHelper.clear();
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

