/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.aggregator.AggregatorInstance;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.impl.AggregateOnlyResult;
import net.sf.ehcache.search.impl.BaseResult;
import net.sf.ehcache.search.impl.OrderComparator;
import net.sf.ehcache.search.impl.ResultImpl;
import net.sf.ehcache.search.impl.ResultsImpl;
import net.sf.ehcache.store.FrontEndCacheTier;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.NotifyingMemoryStore;
import net.sf.ehcache.store.NullStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.transaction.SoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryOnlyStore
extends FrontEndCacheTier<NullStore, MemoryStore> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Map<String, AttributeExtractor> attributeExtractors = new ConcurrentHashMap<String, AttributeExtractor>();
    private final Map<String, Attribute> searchAttributes = new ConcurrentHashMap<String, Attribute>();

    private MemoryOnlyStore(CacheConfiguration cacheConfiguration, NullStore cache, MemoryStore authority) {
        super(cache, authority, cacheConfiguration.getCopyStrategy(), cacheConfiguration.isCopyOnWrite(), cacheConfiguration.isCopyOnRead());
    }

    public static Store create(Ehcache cache, Pool onHeapPool) {
        NullStore nullStore = NullStore.create();
        NotifyingMemoryStore memoryStore = NotifyingMemoryStore.create(cache, onHeapPool);
        return new MemoryOnlyStore(cache.getCacheConfiguration(), nullStore, memoryStore);
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.attributeExtractors.putAll(extractors);
        for (String name : extractors.keySet()) {
            this.searchAttributes.put(name, new Attribute(name));
        }
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        Criteria c = query.getCriteria();
        List<AggregatorInstance<?>> aggregators = query.getAggregatorInstances();
        boolean includeResults = query.requestsKeys() || query.requestsValues() || !query.requestedAttributes().isEmpty();
        ArrayList<Result> results = new ArrayList<Result>();
        boolean hasOrder = !query.getOrdering().isEmpty();
        boolean anyMatches = false;
        for (Element element : ((MemoryStore)this.authority).elementSet()) {
            if (!hasOrder && query.maxResults() >= 0 && results.size() == query.maxResults()) break;
            if (element.getObjectValue() instanceof SoftLock || !c.execute(element, this.attributeExtractors)) continue;
            anyMatches = true;
            if (includeResults) {
                Object[] sortAttributes;
                Map<String, Object> attributes;
                if (query.requestedAttributes().isEmpty()) {
                    attributes = Collections.emptyMap();
                } else {
                    attributes = new HashMap();
                    for (Attribute<?> attribute : query.requestedAttributes()) {
                        String name = attribute.getAttributeName();
                        attributes.put(name, this.attributeExtractors.get(name).attributeFor(element, name));
                    }
                }
                List<StoreQuery.Ordering> orderings = query.getOrdering();
                if (orderings.isEmpty()) {
                    sortAttributes = EMPTY_OBJECT_ARRAY;
                } else {
                    sortAttributes = new Object[orderings.size()];
                    for (int i = 0; i < sortAttributes.length; ++i) {
                        String name = orderings.get(i).getAttribute().getAttributeName();
                        sortAttributes[i] = this.attributeExtractors.get(name).attributeFor(element, name);
                    }
                }
                results.add(new ResultImpl(element.getObjectKey(), element.getObjectValue(), query, attributes, sortAttributes));
            }
            for (AggregatorInstance<?> aggregator : aggregators) {
                Attribute<?> attribute;
                attribute = aggregator.getAttribute();
                if (attribute == null) {
                    aggregator.accept(null);
                    continue;
                }
                Object val = this.attributeExtractors.get(attribute.getAttributeName()).attributeFor(element, attribute.getAttributeName());
                aggregator.accept(val);
            }
        }
        if (hasOrder) {
            Collections.sort(results, new OrderComparator(query.getOrdering()));
            int max = query.maxResults();
            if (max >= 0 && results.size() > max) {
                results.subList(max, results.size()).clear();
                results.trimToSize();
            }
        }
        ArrayList<Object> aggregateResults = aggregators.isEmpty() ? Collections.emptyList() : new ArrayList<Object>();
        for (AggregatorInstance<?> aggregator : aggregators) {
            aggregateResults.add(aggregator.aggregateResult());
        }
        if (anyMatches && !includeResults && !aggregateResults.isEmpty()) {
            results.add(new AggregateOnlyResult(query));
        }
        if (!aggregateResults.isEmpty()) {
            for (Result result : results) {
                ((BaseResult)result).setAggregateResults(aggregateResults);
            }
        }
        return new ResultsImpl(results, query.requestsKeys(), query.requestsValues(), !query.requestedAttributes().isEmpty(), anyMatches && !aggregateResults.isEmpty());
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        return this.searchAttributes.get(attributeName);
    }

    @Override
    public Object getMBean() {
        return null;
    }
}

