/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.List;
import java.util.Map;
import org.snaker.engine.Completion;
import org.snaker.engine.IOrderService;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.CCOrder;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.DateHelper;
import org.snaker.engine.helper.JsonHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.ProcessModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderService
extends AccessService
implements IOrderService {
    @Override
    public Order createOrder(Process process, String operator, Map<String, Object> args) {
        return this.createOrder(process, operator, args, null, null);
    }

    @Override
    public Order createOrder(Process process, String operator, Map<String, Object> args, String parentId, String parentNodeName) {
        Order order = new Order();
        order.setId(StringHelper.getPrimaryKey());
        order.setParentId(parentId);
        order.setParentNodeName(parentNodeName);
        order.setCreateTime(DateHelper.getTime());
        order.setLastUpdateTime(order.getCreateTime());
        order.setCreator(operator);
        order.setLastUpdator(order.getCreator());
        order.setProcessId(process.getId());
        ProcessModel model = process.getModel();
        if (model != null && args != null) {
            String orderNo;
            if (StringHelper.isNotEmpty(model.getExpireTime())) {
                String expireTime = DateHelper.parseTime(args.get(model.getExpireTime()));
                order.setExpireTime(expireTime);
            }
            if (StringHelper.isNotEmpty(orderNo = (String)args.get("snaker.orderNo"))) {
                order.setOrderNo(orderNo);
            } else {
                order.setOrderNo(model.getGenerator().generate(model));
            }
        }
        order.setVariable(JsonHelper.toJson(args));
        this.saveOrder(order);
        return order;
    }

    @Override
    public void addVariable(String orderId, Map<String, Object> args) {
        Order order = this.access().getOrder(orderId);
        Map<String, Object> data = order.getVariableMap();
        data.putAll(args);
        order.setVariable(JsonHelper.toJson(data));
        this.access().updateOrderVariable(order);
    }

    @Override
    public void createCCOrder(String orderId, String creator, String ... actorIds) {
        for (String actorId : actorIds) {
            CCOrder ccorder = new CCOrder();
            ccorder.setOrderId(orderId);
            ccorder.setActorId(actorId);
            ccorder.setCreator(creator);
            ccorder.setStatus(STATE_ACTIVE);
            ccorder.setCreateTime(DateHelper.getTime());
            this.access().saveCCOrder(ccorder);
        }
    }

    @Override
    public void saveOrder(Order order) {
        HistoryOrder history = new HistoryOrder(order);
        history.setOrderState(STATE_ACTIVE);
        this.access().saveOrder(order);
        this.access().saveHistory(history);
    }

    @Override
    public void updateOrder(Order order) {
        this.access().updateOrder(order);
    }

    @Override
    public void updateCCStatus(String orderId, String ... actorIds) {
        List<CCOrder> ccorders = this.access().getCCOrder(orderId, actorIds);
        AssertHelper.notNull(ccorders);
        for (CCOrder ccorder : ccorders) {
            ccorder.setStatus(STATE_FINISH);
            ccorder.setFinishTime(DateHelper.getTime());
            this.access().updateCCOrder(ccorder);
        }
    }

    @Override
    public void deleteCCOrder(String orderId, String actorId) {
        List<CCOrder> ccorders = this.access().getCCOrder(orderId, actorId);
        AssertHelper.notNull(ccorders);
        for (CCOrder ccorder : ccorders) {
            this.access().deleteCCOrder(ccorder);
        }
    }

    @Override
    public void complete(String orderId) {
        Order order = this.access().getOrder(orderId);
        HistoryOrder history = this.access().getHistOrder(orderId);
        history.setOrderState(STATE_FINISH);
        history.setEndTime(DateHelper.getTime());
        this.access().updateHistory(history);
        this.access().deleteOrder(order);
        Completion completion = this.getCompletion();
        if (completion != null) {
            completion.complete(history);
        }
    }

    @Override
    public void terminate(String orderId) {
        this.terminate(orderId, null);
    }

    @Override
    public void terminate(String orderId, String operator) {
        SnakerEngine engine = ServiceContext.getEngine();
        List<Task> tasks = engine.query().getActiveTasks(new QueryFilter().setOrderId(orderId));
        for (Task task : tasks) {
            engine.task().complete(task.getId(), operator);
        }
        Order order = this.access().getOrder(orderId);
        HistoryOrder history = new HistoryOrder(order);
        history.setOrderState(STATE_TERMINATION);
        history.setEndTime(DateHelper.getTime());
        this.access().updateHistory(history);
        this.access().deleteOrder(order);
        Completion completion = this.getCompletion();
        if (completion != null) {
            completion.complete(history);
        }
    }

    @Override
    public Order resume(String orderId) {
        HistoryOrder historyOrder = this.access().getHistOrder(orderId);
        Order order = historyOrder.undo();
        this.access().saveOrder(order);
        historyOrder.setOrderState(STATE_ACTIVE);
        this.access().updateHistory(historyOrder);
        SnakerEngine engine = ServiceContext.getEngine();
        List<HistoryTask> histTasks = this.access().getHistoryTasks(null, new QueryFilter().setOrderId(orderId));
        if (histTasks != null && !histTasks.isEmpty()) {
            HistoryTask histTask = histTasks.get(0);
            engine.task().resume(histTask.getId(), histTask.getOperator());
        }
        return order;
    }

    @Override
    public void cascadeRemove(String id) {
        HistoryOrder historyOrder = this.access().getHistOrder(id);
        AssertHelper.notNull(historyOrder);
        List<Task> activeTasks = this.access().getActiveTasks(null, new QueryFilter().setOrderId(id));
        List<HistoryTask> historyTasks = this.access().getHistoryTasks(null, new QueryFilter().setOrderId(id));
        for (Task task : activeTasks) {
            this.access().deleteTask(task);
        }
        for (HistoryTask historyTask : historyTasks) {
            this.access().deleteHistoryTask(historyTask);
        }
        List<CCOrder> ccOrders = this.access().getCCOrder(id, new String[0]);
        for (CCOrder ccOrder : ccOrders) {
            this.access().deleteCCOrder(ccOrder);
        }
        Order order = this.access().getOrder(id);
        this.access().deleteHistoryOrder(historyOrder);
        if (order != null) {
            this.access().deleteOrder(order);
        }
    }
}

