/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.snaker.engine.SnakerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectHelper {
    public static Object getFieldValue(Object obj, String fieldName) {
        Object result = null;
        Field field = ReflectHelper.getField(obj, fieldName);
        if (field != null) {
            field.setAccessible(true);
            try {
                result = field.get(obj);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Field getField(Object obj, String fieldName) {
        Field field = null;
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) {
        Field field = ReflectHelper.getField(obj, fieldName);
        if (field != null) {
            try {
                field.setAccessible(true);
                field.set(obj, fieldValue);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        if (method == null) {
            throw new SnakerException("\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new SnakerException("\u4e0d\u80fd\u8c03\u7528 '" + method.getName() + "' with " + Arrays.toString(args) + " on " + target + ": " + targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new SnakerException("\u4e0d\u80fd\u8c03\u7528 '" + method.getName() + "' with " + Arrays.toString(args) + " on " + target + ": " + e.getMessage(), e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName) {
        Method[] candidates = clazz.getDeclaredMethods();
        for (int i = 0; i < candidates.length; ++i) {
            Method candidate = candidates[i];
            if (!candidate.getName().equals(methodName)) continue;
            return candidate;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectHelper.findMethod(clazz.getSuperclass(), methodName);
        }
        return null;
    }
}

