/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLSubPartitionByList;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.NotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAnalyzePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCheckPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCoalescePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableConvertCharSet;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDiscardPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableImportPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableOptimizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReOrganizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRebuildPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRepairPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetComment;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTouch;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTruncatePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewRenameStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.ast.statement.SQLColumnUniqueKey;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLoopStatement;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.visitor.PrintableVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitorUtils;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLASTOutputVisitor
extends SQLASTVisitorAdapter
implements PrintableVisitor {
    protected final Appendable appender;
    private String indent = "\t";
    private int indentCount = 0;
    private boolean prettyFormat = true;
    protected boolean ucase = true;
    protected int selectListNumberOfLine = 5;
    protected boolean groupItemSingleLine = false;
    private List<Object> parameters;
    protected String dbType;

    public SQLASTOutputVisitor(Appendable appender) {
        this.appender = appender;
    }

    public int getParametersSize() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public List<Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public Appendable getAppender() {
        return this.appender;
    }

    public boolean isPrettyFormat() {
        return this.prettyFormat;
    }

    public void setPrettyFormat(boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    public void decrementIndent() {
        --this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    @Override
    public void print(char value) {
        try {
            this.appender.append(value);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    public void print(int value) {
        this.print0(Integer.toString(value));
    }

    public void print(Date date) {
        SimpleDateFormat dateFormat = date instanceof Timestamp ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new SimpleDateFormat("yyyy-MM-dd");
        this.print0("'" + dateFormat.format(date) + "'");
    }

    public void print(long value) {
        this.print0(Long.toString(value));
    }

    @Override
    public void print(String text) {
        this.print0(text);
    }

    protected void print0(String text) {
        try {
            this.appender.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    protected void printAlias(String alias) {
        if (alias != null && alias.length() > 0) {
            this.print(' ');
            this.print0(alias);
        }
    }

    protected void printAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % this.selectListNumberOfLine == 0) {
                    this.println();
                }
                this.print0(", ");
            }
            selectList.get(i).accept(this);
        }
        this.decrementIndent();
    }

    protected void printlnAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    public void printIndent() {
        for (int i = 0; i < this.indentCount; ++i) {
            this.print0(this.indent);
        }
    }

    public void println() {
        if (!this.isPrettyFormat()) {
            this.print(' ');
            return;
        }
        this.print0("\n");
        this.printIndent();
    }

    public void println(String text) {
        this.print(text);
        this.println();
    }

    protected void println0(String text) {
        this.print0(text);
        this.println();
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        x.getTestExpr().accept(this);
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT BETWEEN " : " not between ");
        } else {
            this.print0(this.ucase ? " BETWEEN " : " between ");
        }
        x.getBeginExpr().accept(this);
        this.print0(this.ucase ? " AND " : " and ");
        x.getEndExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        boolean relational;
        SQLObject parent = x.getParent();
        boolean isRoot = parent instanceof SQLSelectQueryBlock;
        boolean bl = relational = x.getOperator() == SQLBinaryOperator.BooleanAnd || x.getOperator() == SQLBinaryOperator.BooleanOr;
        if (isRoot && relational) {
            this.incrementIndent();
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLExpr left = x.getLeft();
        while (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            groupList.add(binaryLeft.getRight());
            left = binaryLeft.getLeft();
        }
        groupList.add(left);
        for (int i = groupList.size() - 1; i >= 0; --i) {
            SQLExpr item = (SQLExpr)groupList.get(i);
            if (relational && this.isPrettyFormat() && item.hasBeforeComment()) {
                this.printlnComments(item.getBeforeCommentsDirect());
            }
            if (this.isPrettyFormat() && item.hasBeforeComment()) {
                this.printlnComments(item.getBeforeCommentsDirect());
            }
            this.visitBinaryLeft(item, x.getOperator());
            if (this.isPrettyFormat() && item.hasAfterComment()) {
                this.print(' ');
                this.printComment(item.getAfterCommentsDirect(), "\n");
            }
            if (i != groupList.size() - 1 && this.isPrettyFormat() && item.getParent().hasAfterComment()) {
                this.print(' ');
                this.printComment(item.getParent().getAfterCommentsDirect(), "\n");
            }
            if (relational) {
                this.println();
            } else {
                this.print0(" ");
            }
            this.print0(this.ucase ? x.getOperator().name : x.getOperator().name_lcase);
            this.print0(" ");
        }
        this.visitorBinaryRight(x);
        if (isRoot && relational) {
            this.decrementIndent();
        }
        return false;
    }

    private void visitorBinaryRight(SQLBinaryOpExpr x) {
        if (this.isPrettyFormat() && x.getRight().hasBeforeComment()) {
            this.printlnComments(x.getRight().getBeforeCommentsDirect());
        }
        if (x.getRight() instanceof SQLBinaryOpExpr) {
            boolean rightRational;
            SQLBinaryOpExpr right = (SQLBinaryOpExpr)x.getRight();
            boolean bl = rightRational = right.getOperator() == SQLBinaryOperator.BooleanAnd || right.getOperator() == SQLBinaryOperator.BooleanOr;
            if (right.getOperator().priority >= x.getOperator().priority) {
                if (rightRational) {
                    this.incrementIndent();
                }
                this.print('(');
                right.accept(this);
                this.print(')');
                if (rightRational) {
                    this.decrementIndent();
                }
            } else {
                right.accept(this);
            }
        } else {
            x.getRight().accept(this);
        }
        if (x.getRight().hasAfterComment() && this.isPrettyFormat()) {
            this.print(' ');
            this.printlnComments(x.getRight().getAfterCommentsDirect());
        }
    }

    private void visitBinaryLeft(SQLExpr left, SQLBinaryOperator op) {
        if (left instanceof SQLBinaryOpExpr) {
            boolean leftRational;
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            boolean bl = leftRational = binaryLeft.getOperator() == SQLBinaryOperator.BooleanAnd || binaryLeft.getOperator() == SQLBinaryOperator.BooleanOr;
            if (binaryLeft.getOperator().priority > op.priority) {
                if (leftRational) {
                    this.incrementIndent();
                }
                this.print('(');
                left.accept(this);
                this.print(')');
                if (leftRational) {
                    this.decrementIndent();
                }
            } else {
                left.accept(this);
            }
        } else {
            left.accept(this);
        }
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.print0(this.ucase ? "CASE " : "case ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
            this.print0(" ");
        }
        this.printAndAccept(x.getItems(), " ");
        if (x.getElseExpr() != null) {
            this.print0(this.ucase ? " ELSE " : " else ");
            x.getElseExpr().accept(this);
        }
        this.print0(this.ucase ? " END" : " end");
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr.Item x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        x.getConditionExpr().accept(this);
        this.print0(this.ucase ? " THEN " : " then ");
        x.getValueExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        this.print0(this.ucase ? "CAST(" : "cast(");
        x.getExpr().accept(this);
        this.print0(this.ucase ? " AS " : " as ");
        x.getDataType().accept(this);
        this.print0(")");
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (x.getText() == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            this.print('\'');
            this.print0(x.getText().replaceAll("'", "''"));
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.print0(x.getName());
        if (x.getArguments().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getArguments(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharacterDataType x) {
        this.visit((SQLDataType)x);
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        if (x.isNot()) {
            this.print0(this.ucase ? "NOT EXISTS (" : "not exists (");
        } else {
            this.print0(this.ucase ? "EXISTS (" : "exists (");
        }
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.println();
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        this.print0(x.getName());
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        int i;
        int size;
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT IN (" : " not in (");
        } else {
            this.print0(this.ucase ? " IN (" : " in (");
        }
        List<SQLExpr> list = x.getTargetList();
        boolean printLn = false;
        if (list.size() > 5) {
            printLn = true;
            size = list.size();
            for (i = 0; i < size; ++i) {
                if (list.get(i) instanceof SQLCharExpr) continue;
                printLn = false;
                break;
            }
        }
        if (printLn) {
            this.incrementIndent();
            this.println();
            size = list.size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                list.get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
        } else {
            this.printAndAccept(x.getTargetList(), ", ");
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.getOwner() != null) {
            x.getOwner().accept(this);
            this.print('.');
        }
        this.printFunctionName(x.getMethodName());
        this.print('(');
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    protected void printFunctionName(String name) {
        this.print0(name);
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.print0(this.ucase ? x.getMethodName() : x.getMethodName().toLowerCase());
        this.print('(');
        if (x.getOption() != null) {
            this.print0(x.getOption().toString());
            this.print(' ');
        }
        this.printAndAccept(x.getArguments(), ", ");
        this.visitAggreateRest(x);
        this.print(')');
        if (x.getWithinGroup() != null) {
            this.print0(this.ucase ? " WITHIN GROUP (" : " within group (");
            x.getWithinGroup().accept(this);
            this.print(')');
        }
        if (x.getKeep() != null) {
            this.print(' ');
            x.getKeep().accept(this);
        }
        if (x.getOver() != null) {
            this.print(' ');
            x.getOver().accept(this);
        }
        return false;
    }

    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.print('*');
        return true;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (x.getText() == null || x.getText().length() == 0) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            this.print0(this.ucase ? "N'" : "n'");
            this.print0(x.getText().replace("'", "''"));
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        this.print0(this.ucase ? "NOT " : "not ");
        SQLExpr expr = x.getExpr();
        boolean needQuote = false;
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)expr;
            needQuote = binaryOpExpr.getOperator().isLogical();
        }
        if (needQuote) {
            this.print('(');
        }
        expr.accept(this);
        if (needQuote) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.print0(this.ucase ? "NULL" : "null");
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        x.getOwner().accept(this);
        this.print('.');
        this.print0(x.getName());
        return false;
    }

    @Override
    public boolean visit(SQLQueryExpr x) {
        SQLObject parent = x.getParent();
        if (parent instanceof SQLSelect) {
            parent = parent.getParent();
        }
        if (parent instanceof SQLStatement) {
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.decrementIndent();
        } else if (parent instanceof SQLInsertStatement.ValuesClause) {
            this.println();
            this.print('(');
            x.getSubQuery().accept(this);
            this.print(')');
            this.println();
        } else {
            this.print('(');
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.println();
            this.decrementIndent();
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print0(this.ucase ? "GROUP BY " : "group by ");
            this.incrementIndent();
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    if (this.groupItemSingleLine) {
                        this.println(", ");
                    } else {
                        this.print(", ");
                    }
                }
                x.getItems().get(i).accept(this);
            }
            this.decrementIndent();
        }
        if (x.getHaving() != null) {
            this.println();
            this.print0(this.ucase ? "HAVING " : "having ");
            x.getHaving().accept(this);
        }
        if (x.isWithRollUp()) {
            this.print0(this.ucase ? " WITH ROLLUP" : " with rollup");
        }
        if (x.isWithCube()) {
            this.print0(this.ucase ? " WITH CUBE" : " with cube");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        x.getQuery().setParent(x);
        if (x.getWithSubQuery() != null) {
            x.getWithSubQuery().accept(this);
            this.println();
        }
        x.getQuery().accept(this);
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getHintsSize() > 0) {
            this.printAndAccept(x.getHints(), "");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printComment(x.getBeforeCommentsDirect(), "\n");
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        if (x.isConnectByRoot()) {
            this.print0(this.ucase ? "CONNECT_BY_ROOT " : "connect_by_root ");
        }
        x.getExpr().accept(this);
        String alias = x.getAlias();
        if (alias != null && alias.length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            if (alias.indexOf(32) == -1 || alias.charAt(0) == '\"' || alias.charAt(0) == '\'') {
                this.print0(alias);
            } else {
                this.print('\"');
                this.print0(alias);
                this.print('\"');
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        if (x.getItems().size() > 0) {
            if (x.isSibings()) {
                this.print0(this.ucase ? "ORDER SIBLINGS BY " : "order siblings by ");
            } else {
                this.print0(this.ucase ? "ORDER BY " : "order by ");
            }
            this.printAndAccept(x.getItems(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(' ');
            SQLOrderingSpecification type = x.getType();
            this.print0(this.ucase ? type.name : type.name_lcase);
        }
        if (x.getCollate() != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(x.getCollate());
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printComment(x.getAfterCommentsDirect(), "\n");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectStatement stmt) {
        SQLSelect select = stmt.getSelect();
        select.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        int index = x.getIndex();
        if (this.parameters == null || index >= this.parameters.size()) {
            this.print0(x.getName());
            return false;
        }
        Object param = this.parameters.get(index);
        this.printParameter(param);
        return false;
    }

    public void printParameter(Object param) {
        if (param == null) {
            this.print0(this.ucase ? "NULL" : "null");
            return;
        }
        if (param instanceof Number || param instanceof Boolean) {
            this.print0(param.toString());
            return;
        }
        if (param instanceof String) {
            SQLCharExpr charExpr = new SQLCharExpr((String)param);
            this.visit(charExpr);
            return;
        }
        if (param instanceof Date) {
            this.print((Date)param);
            return;
        }
        if (param instanceof InputStream) {
            this.print0("'<InputStream>");
            return;
        }
        if (param instanceof Reader) {
            this.print0("'<Reader>");
            return;
        }
        if (param instanceof Blob) {
            this.print0("'<Blob>");
            return;
        }
        if (param instanceof NClob) {
            this.print0("'<NClob>");
            return;
        }
        if (param instanceof Clob) {
            this.print0("'<Clob>");
            return;
        }
        this.print0("'" + param.getClass().getName() + "'");
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        if (x.isTemporary()) {
            this.print0(this.ucase ? "DROP TEMPORARY TABLE " : "drop temporary table ");
        } else {
            this.print0(this.ucase ? "DROP TABLE " : "drop table ");
        }
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        if (x.isPurge()) {
            this.print0(this.ucase ? " PURGE" : " purge");
        }
        return false;
    }

    protected void printCascade() {
        this.print0(this.ucase ? " CASCADE" : " cascade");
    }

    @Override
    public boolean visit(SQLDropViewStatement x) {
        this.print0(this.ucase ? "DROP VIEW " : "drop view ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        return false;
    }

    public boolean visit(SQLTableElement x) {
        if (x instanceof SQLColumnDefinition) {
            return this.visit((SQLColumnDefinition)x);
        }
        throw new RuntimeException("TODO");
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            boolean newLine;
            boolean bl = newLine = item instanceof SQLForeignKeyConstraint || item instanceof SQLPrimaryKey || item instanceof SQLColumnCheck || item instanceof SQLColumnCheck || item.getName() != null;
            if (newLine) {
                this.incrementIndent();
                this.println();
            } else {
                this.print(' ');
            }
            item.accept(this);
            if (!newLine) continue;
            this.decrementIndent();
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print0(this.ucase ? " ENABLE" : " enable");
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition.Identity x) {
        this.print0(this.ucase ? "IDENTITY (" : "identity (");
        this.print(x.getSeed());
        this.print0(", ");
        this.print(x.getIncrement());
        this.print(')');
        return false;
    }

    protected void visitColumnDefault(SQLColumnDefinition x) {
        this.print0(this.ucase ? " DEFAULT " : " default ");
        x.getDefaultExpr().accept(this);
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        this.print0(this.ucase ? "DELETE FROM " : "delete from ");
        x.getTableName().accept(this);
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            this.incrementIndent();
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        this.print0(this.ucase ? "CURRENT OF " : "current of ");
        x.getCursorName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        this.print0(this.ucase ? "INSERT INTO " : "insert into ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print('(');
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(')');
            this.decrementIndent();
        }
        if (x.getValues() != null) {
            this.println();
            this.print0(this.ucase ? "VALUES" : "values");
            this.println();
            x.getValues().accept(this);
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().setParent(x);
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUpdateSetItem x) {
        x.getColumn().accept(this);
        this.print0(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.print0(this.ucase ? "UPDATE " : "update ");
        x.getTableSource().accept(this);
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.incrementIndent();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.print0(this.ucase ? "CREATE TABLE " : "create table ");
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "LOCAL TEMPORARY " : "local temporary ");
        }
        x.getName().accept(this);
        int size = x.getTableElementList().size();
        if (size > 0) {
            this.print0(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(',');
                    this.println();
                }
                x.getTableElementList().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if (x.getInherits() != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            x.getInherits().accept(this);
            this.print(')');
        }
        return false;
    }

    public boolean visit(SQLUniqueConstraint x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE (" : "unique (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(NotNullConstraint x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "NOT NULL" : "not null");
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        x.getLeft().accept(this);
        this.println();
        this.print0(this.ucase ? x.getOperator().name : x.getOperator().name_lcase);
        this.println();
        boolean needParen = false;
        if (x.getOrderBy() != null) {
            needParen = true;
        }
        if (needParen) {
            this.print('(');
            x.getRight().accept(this);
            this.print(')');
        } else {
            x.getRight().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        this.print0(x.getOperator().name);
        SQLExpr expr = x.getExpr();
        switch (x.getOperator()) {
            case BINARY: 
            case Prior: 
            case ConnectByRoot: {
                this.print(' ');
                expr.accept(this);
                return false;
            }
        }
        if (expr instanceof SQLBinaryOpExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else if (expr instanceof SQLUnaryExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLHexExpr x) {
        this.print0("0x");
        this.print0(x.getHex());
        String charset = (String)x.getAttribute("USING");
        if (charset != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(charset);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        this.print0(this.ucase ? "SET " : "set ");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAssignItem x) {
        x.getTarget().accept(this);
        this.print0(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        if (x.isBrace()) {
            this.print('{');
        }
        if (x.getOutParameter() != null) {
            x.getOutParameter().accept(this);
            this.print0(" = ");
        }
        this.print0(this.ucase ? "CALL " : "call ");
        x.getProcedureName().accept(this);
        this.print('(');
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        if (x.isBrace()) {
            this.print('}');
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        this.incrementIndent();
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(',');
        } else {
            this.println();
            this.printJoinType(x.getJoinType());
        }
        this.print(' ');
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.incrementIndent();
            this.print0(this.ucase ? " ON " : " on ");
            x.getCondition().accept(this);
            this.decrementIndent();
        }
        if (x.getUsing().size() > 0) {
            this.print0(this.ucase ? " USING (" : " using (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(')');
        }
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        this.decrementIndent();
        return false;
    }

    protected void printJoinType(SQLJoinTableSource.JoinType joinType) {
        this.print0(this.ucase ? joinType.name : joinType.name_lcase);
    }

    @Override
    public boolean visit(SQLInsertStatement.ValuesClause x) {
        this.print('(');
        this.incrementIndent();
        int size = x.getValues().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % 5 == 0) {
                    this.println();
                }
                this.print0(", ");
            }
            SQLExpr expr = x.getValues().get(i);
            expr.setParent(x);
            expr.accept(this);
        }
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLSomeExpr x) {
        this.print0(this.ucase ? "SOME (" : "some (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAnyExpr x) {
        this.print0(this.ucase ? "ANY (" : "any (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAllExpr x) {
        this.print0(this.ucase ? "ALL (" : "all (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT IN (" : " not in (");
        } else {
            this.print0(this.ucase ? " IN (" : " in (");
        }
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLListExpr x) {
        this.print('(');
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print('(');
        this.incrementIndent();
        x.getSelect().accept(this);
        this.println();
        this.decrementIndent();
        this.print(')');
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.print0(this.ucase ? "TRUNCATE TABLE " : "truncate table ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLDefaultExpr x) {
        this.print0(this.ucase ? "DEFAULT" : "default");
        return false;
    }

    @Override
    public void endVisit(SQLCommentStatement x) {
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        this.print0(this.ucase ? "COMMENT ON " : "comment on ");
        if (x.getType() != null) {
            this.print0(x.getType().name());
            this.print(' ');
        }
        x.getOn().accept(this);
        this.print0(this.ucase ? " IS " : " is ");
        x.getComment().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUseStatement x) {
        this.print0(this.ucase ? "USE " : "use ");
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD (" : "add (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropColumnItem x) {
        this.print0(this.ucase ? "DROP COLUMN " : "drop column ");
        this.printAndAccept(x.getColumns(), ", ");
        if (x.isCascade()) {
            this.print0(this.ucase ? " CASCADE" : " cascade");
        }
        return false;
    }

    @Override
    public void endVisit(SQLAlterTableAddColumn x) {
    }

    @Override
    public boolean visit(SQLDropIndexStatement x) {
        this.print0(this.ucase ? "DROP INDEX " : "drop index ");
        x.getIndexName().accept(this);
        SQLExprTableSource table = x.getTableName();
        if (table != null) {
            this.print0(this.ucase ? " ON " : " on ");
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSavePointStatement x) {
        this.print0(this.ucase ? "SAVEPOINT " : "savepoint ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLReleaseSavePointStatement x) {
        this.print0(this.ucase ? "RELEASE SAVEPOINT " : "release savepoint ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK" : "rollback");
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCommentHint x) {
        this.print0("/*");
        this.print0(x.getText());
        this.print0("*/");
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        this.print0(this.ucase ? "CREATE DATABASE " : "create database ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.getCharacterSet() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(x.getCharacterSet());
        }
        if (x.getCollate() != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(x.getCollate());
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        this.print0(this.ucase ? "VIEW " : "view ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.println();
            this.print('(');
            this.incrementIndent();
            this.println();
            for (int i = 0; i < x.getColumns().size(); ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                x.getColumns().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement.Column x) {
        x.getExpr().accept(this);
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropIndex x) {
        this.print0(this.ucase ? "DROP INDEX " : "drop index ");
        x.getIndexName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLOver x) {
        this.print0(this.ucase ? "OVER (" : "over (");
        if (x.getPartitionBy().size() > 0) {
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            this.print(' ');
        }
        if (x.getOrderBy() != null) {
            x.getOrderBy().accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLKeep x) {
        if (x.getDenseRank() == SQLKeep.DenseRank.FIRST) {
            this.print0(this.ucase ? "KEEP (DENSE_RANK FIRST " : "keep (dense_rank first ");
        } else {
            this.print0(this.ucase ? "KEEP (DENSE_RANK LAST " : "keep (dense_rank last ");
        }
        x.getOrderBy().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLColumnPrimaryKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY" : "primary key");
        return false;
    }

    @Override
    public boolean visit(SQLColumnUniqueKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE" : "unique");
        return false;
    }

    @Override
    public boolean visit(SQLColumnCheck x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "CHECK (" : "check (");
        x.getExpr().accept(this);
        this.print(')');
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print0(this.ucase ? " ENABLE" : " enable");
            } else {
                this.print0(this.ucase ? " DISABLE" : " disable");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        this.print0(this.ucase ? "WITH" : "with");
        if (x.getRecursive() == Boolean.TRUE) {
            this.print0(this.ucase ? " RECURSIVE" : " recursive");
        }
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getEntries(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        this.print('(');
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAlterColumn x) {
        this.print0(this.ucase ? "ALTER COLUMN " : "alter column ");
        x.getColumn().accept(this);
        if (x.isSetNotNull()) {
            this.print0(this.ucase ? " SET NOT NULL" : " set not null");
        }
        if (x.isDropNotNull()) {
            this.print0(this.ucase ? " DROP NOT NULL" : " drop not null");
        }
        if (x.getSetDefault() != null) {
            this.print0(this.ucase ? " SET DEFAULT " : " set default ");
            x.getSetDefault().accept(this);
        }
        if (x.isDropDefault()) {
            this.print0(this.ucase ? " DROP DEFAULT" : " drop default");
        }
        return false;
    }

    @Override
    public boolean visit(SQLCheck x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "CHECK (" : "check (");
        this.incrementIndent();
        x.getExpr().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropForeignKey x) {
        this.print0(this.ucase ? "DROP FOREIGN KEY " : "drop foreign key ");
        x.getIndexName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPrimaryKey x) {
        this.print0(this.ucase ? "DROP PRIMARY KEY" : "drop primary key");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropKey x) {
        this.print0(this.ucase ? "DROP KEY " : "drop key ");
        x.getKeyName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableKeys x) {
        this.print0(this.ucase ? "ENABLE KEYS" : "enable keys");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableKeys x) {
        this.print0(this.ucase ? "DISABLE KEYS" : "disable keys");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableConstraint x) {
        this.print0(this.ucase ? "DISABLE CONSTRAINT " : "disable constraint ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableConstraint x) {
        this.print0(this.ucase ? "ENABLE CONSTRAINT " : "enable constraint ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropConstraint x) {
        this.print0(this.ucase ? "DROP CONSTRAINT " : "drop constraint ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        x.getName().accept(this);
        this.incrementIndent();
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLAlterTableItem item = x.getItems().get(i);
            if (i != 0) {
                this.print(',');
            }
            this.println();
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLExprHint x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.getType() != null) {
            this.print0(x.getType());
            this.print(' ');
        }
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getName().accept(this);
        this.print0(this.ucase ? " ON " : " on ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        if (x.getUsing() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getUsing());
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnique x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE (" : "unique (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLPrimaryKeyImpl x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY (" : "primary key (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenameColumn x) {
        this.print0(this.ucase ? "RENAME COLUMN " : "rename column ");
        x.getColumn().accept(this);
        this.print0(this.ucase ? " TO " : " to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLColumnReference x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "REFERENCES " : "references ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLForeignKeyImpl x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "FOREIGN KEY (" : "foreign key (");
        this.printAndAccept(x.getReferencingColumns(), ", ");
        this.print(')');
        this.print0(this.ucase ? " REFERENCES " : " references ");
        x.getReferencedTableName().accept(this);
        if (x.getReferencedColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getReferencedColumns(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropSequenceStatement x) {
        this.print0(this.ucase ? "DROP SEQUENCE " : "drop sequence ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLDropSequenceStatement x) {
    }

    @Override
    public boolean visit(SQLDropTriggerStatement x) {
        this.print0(this.ucase ? "DROP TRIGGER " : "drop trigger ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLDropUserStatement x) {
    }

    @Override
    public boolean visit(SQLDropUserStatement x) {
        this.print0(this.ucase ? "DROP USER " : "drop user ");
        this.printAndAccept(x.getUsers(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLExplainStatement x) {
        this.print0(this.ucase ? "EXPLAIN" : "explain");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        this.println();
        x.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLGrantStatement x) {
        this.print0(this.ucase ? "GRANT " : "grant ");
        this.printAndAccept(x.getPrivileges(), ", ");
        this.printGrantOn(x);
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getTo().accept(this);
        }
        boolean with = false;
        if (x.getMaxQueriesPerHour() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_QUERIES_PER_HOUR " : " max_queries_per_hour ");
            x.getMaxQueriesPerHour().accept(this);
        }
        if (x.getMaxUpdatesPerHour() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_UPDATES_PER_HOUR " : " max_updates_per_hour ");
            x.getMaxUpdatesPerHour().accept(this);
        }
        if (x.getMaxConnectionsPerHour() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_CONNECTIONS_PER_HOUR " : " max_connections_per_hour ");
            x.getMaxConnectionsPerHour().accept(this);
        }
        if (x.getMaxUserConnections() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_USER_CONNECTIONS " : " max_user_connections ");
            x.getMaxUserConnections().accept(this);
        }
        if (x.isAdminOption()) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " ADMIN OPTION" : " admin option");
        }
        if (x.getIdentifiedBy() != null) {
            this.print0(this.ucase ? " IDENTIFIED BY " : " identified by ");
            x.getIdentifiedBy().accept(this);
        }
        return false;
    }

    protected void printGrantOn(SQLGrantStatement x) {
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            SQLObjectType objectType = x.getObjectType();
            if (objectType != null) {
                this.print0(this.ucase ? objectType.name : objectType.name_lcase);
                this.print(' ');
            }
            x.getOn().accept(this);
        }
    }

    @Override
    public boolean visit(SQLRevokeStatement x) {
        this.print0(this.ucase ? "ROVOKE " : "rovoke ");
        this.printAndAccept(x.getPrivileges(), ", ");
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            if (x.getObjectType() != null) {
                this.print0(x.getObjectType().name());
                this.print(' ');
            }
            x.getOn().accept(this);
        }
        if (x.getFrom() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropDatabaseStatement x) {
        this.print0(this.ucase ? "DROP DATABASE " : "drop databasE ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropFunctionStatement x) {
        this.print0(this.ucase ? "DROP FUNCTION " : "drop function ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropTableSpaceStatement x) {
        this.print0(this.ucase ? "DROP TABLESPACE " : "drop tablespace ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropProcedureStatement x) {
        this.print0(this.ucase ? "DROP PROCEDURE " : "drop procedure ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddIndex x) {
        this.print0(this.ucase ? "ADD " : "add ");
        if (x.getType() != null) {
            this.print0(x.getType());
            this.print(' ');
        }
        if (x.isUnique()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? "KEY " : "key ");
        } else {
            this.print0(this.ucase ? "INDEX " : "index ");
        }
        if (x.getName() != null) {
            x.getName().accept(this);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        if (x.getUsing() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getUsing());
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddConstraint x) {
        if (x.isWithNoCheck()) {
            this.print0(this.ucase ? "WITH NOCHECK " : "with nocheck ");
        }
        this.print0(this.ucase ? "ADD " : "add ");
        x.getConstraint().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTriggerStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLEACE " : "or repleace ");
        }
        this.print0(this.ucase ? "TRIGGER " : "trigger ");
        x.getName().accept(this);
        this.incrementIndent();
        this.println();
        if (SQLCreateTriggerStatement.TriggerType.INSTEAD_OF.equals((Object)x.getTriggerType())) {
            this.print0(this.ucase ? "INSTEAD OF" : "instead of");
        } else {
            String triggerTypeName = x.getTriggerType().name();
            this.print0(this.ucase ? triggerTypeName : triggerTypeName.toLowerCase());
        }
        for (SQLCreateTriggerStatement.TriggerEvent event : x.getTriggerEvents()) {
            this.print(' ');
            this.print0(event.name());
        }
        this.println();
        this.print0(this.ucase ? "ON " : "on ");
        x.getOn().accept(this);
        if (x.isForEachRow()) {
            this.println();
            this.print0(this.ucase ? "FOR EACH ROW" : "for each row");
        }
        this.decrementIndent();
        this.println();
        x.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBooleanExpr x) {
        this.print0(x.getValue() ? "true" : "false");
        return false;
    }

    @Override
    public void endVisit(SQLBooleanExpr x) {
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        this.print('(');
        this.incrementIndent();
        this.println();
        x.getUnion().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLTimestampExpr x) {
        this.print0(this.ucase ? "TIMESTAMP " : "timestamp ");
        if (x.isWithTimeZone()) {
            this.print0(this.ucase ? " WITH TIME ZONE " : " with time zone ");
        }
        this.print('\'');
        this.print0(x.getLiteral());
        this.print('\'');
        if (x.getTimeZone() != null) {
            this.print0(this.ucase ? " AT TIME ZONE '" : " at time zone '");
            this.print0(x.getTimeZone());
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryExpr x) {
        this.print0("b'");
        this.print0(x.getValue());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRename x) {
        this.print0(this.ucase ? "RENAME TO " : "rename to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLShowTablesStatement x) {
        this.print0(this.ucase ? "SHOW TABLES" : "show tables");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        return false;
    }

    protected void printComment(List<String> comments, String seperator) {
        if (comments != null) {
            for (int i = 0; i < comments.size(); ++i) {
                if (i != 0) {
                    this.print0(seperator);
                }
                String comment = comments.get(i);
                this.print0(comment);
            }
        }
    }

    protected void printlnComments(List<String> comments) {
        if (comments != null) {
            for (int i = 0; i < comments.size(); ++i) {
                String comment = comments.get(i);
                this.print0(comment);
                this.println();
            }
        }
    }

    @Override
    public boolean visit(SQLAlterViewRenameStatement x) {
        this.print0(this.ucase ? "ALTER VIEW " : "alter view ");
        x.getName().accept(this);
        this.print0(this.ucase ? " RENAME TO " : " rename to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddPartition x) {
        this.print0(this.ucase ? "ADD " : "add ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        if (x.getPartitionCount() != null) {
            this.print0(this.ucase ? "PARTITION PARTITIONS " : "partition partitions ");
            x.getPartitionCount().accept(this);
        }
        if (x.getPartitions().size() > 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableReOrganizePartition x) {
        this.print0(this.ucase ? "REORGANIZE " : "reorganize ");
        this.printAndAccept(x.getNames(), ", ");
        this.print0(this.ucase ? " INTO (" : " into (");
        this.printAndAccept(x.getPartitions(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPartition x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getPartitions().size() == 1 && x.getPartitions().get(0) instanceof SQLName) {
            x.getPartitions().get(0).accept(this);
        } else {
            this.print('(');
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        if (x.isPurge()) {
            this.print0(this.ucase ? " PURGE" : " purge");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenamePartition x) {
        this.print0(this.ucase ? "PARTITION (" : "partition (");
        this.printAndAccept(x.getPartition(), ", ");
        this.print0(this.ucase ? ") RENAME TO PARTITION(" : ") rename to partition(");
        this.printAndAccept(x.getTo(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetComment x) {
        this.print0(this.ucase ? "SET COMMENT " : "set comment ");
        x.getComment().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetLifecycle x) {
        this.print0(this.ucase ? "SET LIFECYCLE " : "set lifecycle ");
        x.getLifecycle().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableLifecycle x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "ENABLE LIFECYCLE" : "enable lifecycle");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableLifecycle x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "DISABLE LIFECYCLE" : "disable lifecycle");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableTouch x) {
        this.print0(this.ucase ? "TOUCH" : "touch");
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLArrayExpr x) {
        x.getExpr().accept(this);
        this.print('[');
        this.printAndAccept(x.getValues(), ", ");
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(SQLOpenStatement x) {
        this.print0(this.ucase ? "OPEN " : "open ");
        this.print0(x.getCursorName());
        return false;
    }

    @Override
    public boolean visit(SQLFetchStatement x) {
        this.print0(this.ucase ? "FETCH " : "fetch ");
        x.getCursorName().accept(this);
        this.print0(this.ucase ? " INTO " : " into ");
        this.printAndAccept(x.getInto(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLCloseStatement x) {
        this.print0(this.ucase ? "CLOSE " : "close ");
        this.print0(x.getCursorName());
        return false;
    }

    @Override
    public boolean visit(SQLGroupingSetExpr x) {
        this.print0(this.ucase ? "GROUPING SETS" : "grouping sets");
        this.print0(" (");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement x) {
        this.print0(this.ucase ? "IF " : "if ");
        x.getCondition().accept(this);
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        for (SQLIfStatement.ElseIf elseIf : x.getElseIfList()) {
            this.println();
            elseIf.accept(this);
        }
        if (x.getElseItem() != null) {
            this.println();
            x.getElseItem().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.Else x) {
        this.print0(this.ucase ? "ELSE" : "else");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.ElseIf x) {
        this.print0(this.ucase ? "ELSE IF" : "else if");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " THEN" : " then");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLLoopStatement x) {
        this.print0(this.ucase ? "LOOP" : "loop");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END LOOP" : "end loop");
        return false;
    }

    @Override
    public boolean visit(SQLParameter x) {
        if (x.getDataType().getName().equalsIgnoreCase("CURSOR")) {
            this.print0(this.ucase ? "CURSOR " : "cursor ");
            x.getName().accept(this);
            this.print0(this.ucase ? " IS" : " is");
            this.incrementIndent();
            this.println();
            SQLSelect select = ((SQLQueryExpr)x.getDefaultValue()).getSubQuery();
            select.accept(this);
            this.decrementIndent();
        } else {
            if (x.getParamType() == SQLParameter.ParameterType.IN) {
                this.print0(this.ucase ? "IN " : "in ");
            } else if (x.getParamType() == SQLParameter.ParameterType.OUT) {
                this.print0(this.ucase ? "OUT " : "out ");
            } else if (x.getParamType() == SQLParameter.ParameterType.INOUT) {
                this.print0(this.ucase ? "INOUT " : "inout ");
            }
            x.getName().accept(this);
            this.print(' ');
            x.getDataType().accept(this);
            if (x.getDefaultValue() != null) {
                this.print0(" := ");
                x.getDefaultValue().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLDeclareItem x) {
        x.getName().accept(this);
        if (x.getType() == SQLDeclareItem.Type.TABLE) {
            this.print0(this.ucase ? " TABLE" : " table");
            int size = x.getTableElementList().size();
            if (size > 0) {
                this.print0(" (");
                this.incrementIndent();
                this.println();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print(',');
                        this.println();
                    }
                    x.getTableElementList().get(i).accept(this);
                }
                this.decrementIndent();
                this.println();
                this.print(')');
            }
        } else if (x.getType() == SQLDeclareItem.Type.CURSOR) {
            this.print0(this.ucase ? " CURSOR" : " cursor");
        } else {
            if (x.getDataType() != null) {
                this.print(' ');
                x.getDataType().accept(this);
            }
            if (x.getValue() != null) {
                if ("mysql".equals(this.getDbType())) {
                    this.print0(this.ucase ? " DEFAULT " : " default ");
                } else {
                    this.print0(" = ");
                }
                x.getValue().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionValue x) {
        SQLIdentifierExpr ident;
        if (x.getOperator() == SQLPartitionValue.Operator.LessThan && !"oracle".equals(this.getDbType()) && x.getItems().size() == 1 && x.getItems().get(0) instanceof SQLIdentifierExpr && "MAXVALUE".equalsIgnoreCase((ident = (SQLIdentifierExpr)x.getItems().get(0)).getName())) {
            this.print0(this.ucase ? "VALUES LESS THAN MAXVALUE" : "values less than maxvalue");
            return false;
        }
        if (x.getOperator() == SQLPartitionValue.Operator.LessThan) {
            this.print0(this.ucase ? "VALUES LESS THAN (" : "values less than (");
        } else if (x.getOperator() == SQLPartitionValue.Operator.In) {
            this.print0(this.ucase ? "VALUES IN (" : "values in (");
        } else {
            this.print(this.ucase ? "VALUES (" : "values (");
        }
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public boolean isUppCase() {
        return this.ucase;
    }

    public void setUppCase(boolean val) {
        this.ucase = val;
    }

    @Override
    public boolean visit(SQLPartition x) {
        this.print0(this.ucase ? "PARTITION " : "partition ");
        x.getName().accept(this);
        if (x.getValues() != null) {
            this.print(' ');
            x.getValues().accept(this);
        }
        if (x.getDataDirectory() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "DATA DIRECTORY " : "data directory ");
            x.getDataDirectory().accept(this);
            this.decrementIndent();
        }
        if (x.getIndexDirectory() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "INDEX DIRECTORY " : "index directory ");
            x.getIndexDirectory().accept(this);
            this.decrementIndent();
        }
        if (x.getTableSpace() != null) {
            this.print0(this.ucase ? " TABLESPACE " : " tablespace ");
            x.getTableSpace().accept(this);
        }
        if (x.getEngine() != null) {
            this.print0(this.ucase ? " STORAGE ENGINE " : " storage engine ");
            x.getEngine().accept(this);
        }
        if (x.getMaxRows() != null) {
            this.print0(this.ucase ? " MAX_ROWS " : " max_rows ");
            x.getMaxRows().accept(this);
        }
        if (x.getMinRows() != null) {
            this.print0(this.ucase ? " MIN_ROWS " : " min_rows ");
            x.getMinRows().accept(this);
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        if (x.getSubPartitionsCount() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "SUBPARTITIONS " : "subpartitions ");
            x.getSubPartitionsCount().accept(this);
            this.decrementIndent();
        }
        if (x.getSubPartitions().size() > 0) {
            this.println();
            this.print('(');
            this.incrementIndent();
            for (int i = 0; i < x.getSubPartitions().size(); ++i) {
                if (i != 0) {
                    this.print(',');
                }
                this.println();
                x.getSubPartitions().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByRange x) {
        this.print0(this.ucase ? "PARTITION BY RANGE" : "partition by range");
        if (x.getExpr() != null) {
            this.print0(" (");
            x.getExpr().accept(this);
            this.print(')');
        } else {
            if ("mysql".equals(this.getDbType())) {
                this.print0(this.ucase ? " COLUMNS (" : " columns (");
            } else {
                this.print0(" (");
            }
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        if (x.getInterval() != null) {
            this.print0(this.ucase ? " INTERVAL " : " interval ");
            x.getInterval().accept(this);
        }
        this.printPartitionsCountAndSubPartitions(x);
        this.println();
        this.print('(');
        this.incrementIndent();
        int size = x.getPartitions().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(',');
            }
            this.println();
            x.getPartitions().get(i).accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByList x) {
        this.print0(this.ucase ? "PARTITION BY LIST " : "partition by list ");
        if (x.getExpr() != null) {
            this.print('(');
            x.getExpr().accept(this);
            this.print0(")");
        } else {
            this.print0(this.ucase ? "COLUMNS (" : "columns (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print0(")");
        }
        this.printPartitionsCountAndSubPartitions(x);
        List<SQLPartition> partitions = x.getPartitions();
        int partitionsSize = partitions.size();
        if (partitionsSize > 0) {
            this.println();
            this.incrementIndent();
            this.print('(');
            for (int i = 0; i < partitionsSize; ++i) {
                this.println();
                partitions.get(i).accept(this);
                if (i == partitionsSize - 1) continue;
                this.print0(", ");
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByHash x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "PARTITION BY LINEAR HASH " : "partition by linear hash ");
        } else {
            this.print0(this.ucase ? "PARTITION BY HASH " : "partition by hash ");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? "KEY" : "key");
        }
        this.print('(');
        x.getExpr().accept(this);
        this.print(')');
        this.printPartitionsCountAndSubPartitions(x);
        return false;
    }

    protected void printPartitionsCountAndSubPartitions(SQLPartitionBy x) {
        if (x.getPartitionsCount() != null) {
            if (Boolean.TRUE.equals(x.getAttribute("ads.partition"))) {
                this.print0(this.ucase ? " PARTITION NUM " : " partition num ");
            } else {
                this.print0(this.ucase ? " PARTITIONS " : " partitions ");
            }
            x.getPartitionsCount().accept(this);
        }
        if (x.getSubPartitionBy() != null) {
            this.println();
            x.getSubPartitionBy().accept(this);
        }
        if (x.getStoreIn().size() > 0) {
            this.println();
            this.print0(this.ucase ? "STORE IN (" : "store in (");
            this.printAndAccept(x.getStoreIn(), ", ");
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLSubPartitionByHash x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "SUBPARTITION BY LINEAR HASH " : "subpartition by linear hash ");
        } else {
            this.print0(this.ucase ? "SUBPARTITION BY HASH " : "subpartition by hash ");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? "KEY" : "key");
        }
        this.print('(');
        x.getExpr().accept(this);
        this.print(')');
        if (x.getSubPartitionsCount() != null) {
            this.print0(this.ucase ? " SUBPARTITIONS " : " subpartitions ");
            x.getSubPartitionsCount().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubPartitionByList x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "SUBPARTITION BY LINEAR HASH " : "subpartition by linear hash ");
        } else {
            this.print0(this.ucase ? "SUBPARTITION BY HASH " : "subpartition by hash ");
        }
        this.print('(');
        x.getColumn().accept(this);
        this.print(')');
        if (x.getSubPartitionsCount() != null) {
            this.print0(this.ucase ? " SUBPARTITIONS " : " subpartitions ");
            x.getSubPartitionsCount().accept(this);
        }
        if (x.getSubPartitionTemplate().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "SUBPARTITION TEMPLATE (" : "subpartition template (");
            this.incrementIndent();
            this.println();
            this.printlnAndAccept(x.getSubPartitionTemplate(), ",");
            this.decrementIndent();
            this.println();
            this.print(')');
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubPartition x) {
        this.print0(this.ucase ? "SUBPARTITION " : "subpartition ");
        x.getName().accept(this);
        if (x.getValues() != null) {
            this.print(' ');
            x.getValues().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterDatabaseStatement x) {
        this.print0(this.ucase ? "ALTER DATABASE " : "alter database ");
        x.getName().accept(this);
        if (x.isUpgradeDataDirectoryName()) {
            this.print0(this.ucase ? " UPGRADE DATA DIRECTORY NAME" : " upgrade data directory name");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableConvertCharSet x) {
        this.print0(this.ucase ? "CONVERT TO CHARACTER SET " : "convert to character set ");
        x.getCharset().accept(this);
        if (x.getCollate() != null) {
            this.print0(this.ucase ? "COLLATE " : "collate ");
            x.getCollate().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableCoalescePartition x) {
        this.print0(this.ucase ? "COALESCE PARTITION " : "coalesce partition ");
        x.getCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableTruncatePartition x) {
        this.print0(this.ucase ? "TRUNCATE PARTITION " : "truncate partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDiscardPartition x) {
        this.print0(this.ucase ? "DISCARD PARTITION " : "discard partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableImportPartition x) {
        this.print0(this.ucase ? "IMPORT PARTITION " : "import partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAnalyzePartition x) {
        this.print0(this.ucase ? "ANALYZE PARTITION " : "analyze partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    protected void printPartitions(List<SQLName> partitions) {
        if (partitions.size() == 1 && "ALL".equalsIgnoreCase(partitions.get(0).getSimpleName())) {
            this.print0(this.ucase ? "ALL" : "all");
        } else {
            this.printAndAccept(partitions, ", ");
        }
    }

    @Override
    public boolean visit(SQLAlterTableCheckPartition x) {
        this.print0(this.ucase ? "CHECK PARTITION " : "check partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableOptimizePartition x) {
        this.print0(this.ucase ? "OPTIMIZE PARTITION " : "optimize partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRebuildPartition x) {
        this.print0(this.ucase ? "REBUILD PARTITION " : "rebuild partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRepairPartition x) {
        this.print0(this.ucase ? "REPAIR PARTITION " : "repair partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }
}

