/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayParser;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.AlipayUploadRequest;
import com.alipay.api.FileItem;
import com.alipay.api.SignItem;
import com.alipay.api.internal.parser.json.ObjectJsonParser;
import com.alipay.api.internal.parser.xml.ObjectXmlParser;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.AlipayUtils;
import com.alipay.api.internal.util.RequestParametersHolder;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.WebUtils;
import java.io.IOException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAlipayClient
implements AlipayClient {
    private String serverUrl;
    private String appId;
    private String privateKey;
    private String prodCode;
    private String format = "json";
    private String sign_type = "RSA";
    private String alipayPublicKey;
    private String charset;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.alipayPublicKey = null;
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format) {
        this(serverUrl, appId, privateKey);
        this.format = format;
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset) {
        this(serverUrl, appId, privateKey);
        this.format = format;
        this.charset = charset;
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPulicKey) {
        this(serverUrl, appId, privateKey);
        this.format = format;
        this.charset = charset;
        this.alipayPublicKey = alipayPulicKey;
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request) throws AlipayApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken) throws AlipayApiException {
        AlipayParser<T> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, accessToken);
    }

    private <T extends AlipayResponse> T _execute(AlipayRequest<T> request, AlipayParser<T> parser, String authToken) throws AlipayApiException {
        AlipayResponse tRsp;
        Map<String, Object> rt;
        block8: {
            rt = this.doPost(request, authToken);
            if (rt == null) {
                return null;
            }
            tRsp = null;
            try {
                boolean rsaCheckContent;
                tRsp = (AlipayResponse)parser.parse((String)rt.get("rsp"));
                tRsp.setBody((String)rt.get("rsp"));
                if (StringUtils.isEmpty(this.alipayPublicKey)) break block8;
                SignItem signItem = parser.getSignItem(request, tRsp);
                if (signItem == null) {
                    throw new AlipayApiException("sign check fail: Body is Empty!");
                }
                if (!tRsp.isSuccess() && (tRsp.isSuccess() || StringUtils.isEmpty(signItem.getSign())) || (rsaCheckContent = AlipaySignature.rsaCheckContent(signItem.getSignSourceDate(), signItem.getSign(), this.alipayPublicKey, this.charset))) break block8;
                if (!StringUtils.isEmpty(signItem.getSignSourceDate()) && signItem.getSignSourceDate().contains("\\/")) {
                    String srouceData = signItem.getSignSourceDate().replace("\\/", "/");
                    boolean jsonCheck = AlipaySignature.rsaCheckContent(srouceData, signItem.getSign(), this.alipayPublicKey, this.charset);
                    if (!jsonCheck) {
                        throw new AlipayApiException("sign check fail: check Sign and Data Fail\uff01JSON also\uff01");
                    }
                    break block8;
                }
                throw new AlipayApiException("sign check fail: check Sign and Data Fail!");
            }
            catch (RuntimeException e) {
                AlipayLogger.logBizError((String)rt.get("rsp"));
                throw e;
            }
            catch (AlipayApiException e) {
                AlipayLogger.logBizError((String)rt.get("rsp"));
                throw new AlipayApiException(e);
            }
        }
        tRsp.setParams((AlipayHashMap)rt.get("textParams"));
        if (!tRsp.isSuccess()) {
            AlipayLogger.logErrorScene(rt, tRsp, "");
        }
        return (T)tRsp;
    }

    public <T extends AlipayResponse> Map<String, Object> doPost(AlipayRequest<T> request, String accessToken) throws AlipayApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap appParams = new AlipayHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = "UTF-8";
        }
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", request.getApiVersion());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.sign_type);
        protocalMustParams.put("terminal_type", request.getTerminalType());
        protocalMustParams.put("terminal_info", request.getTerminalInfo());
        protocalMustParams.put("notify_url", request.getNotifyUrl());
        protocalMustParams.put("charset", this.charset);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        AlipayHashMap protocalOptParams = new AlipayHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("auth_token", accessToken);
        protocalOptParams.put("alipay_sdk", "alipay-sdk-java-dynamicVersionNo");
        protocalOptParams.put("prod_code", request.getProdCode());
        requestHolder.setProtocalOptParams(protocalOptParams);
        if ("RSA".equals(this.sign_type)) {
            String signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", AlipaySignature.rsaSign(signContent, this.privateKey, this.charset));
        } else {
            protocalMustParams.put("sign", "");
        }
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), this.charset);
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), this.charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        String rsp = null;
        try {
            if (request instanceof AlipayUploadRequest) {
                AlipayUploadRequest uRequest = (AlipayUploadRequest)request;
                Map<String, FileItem> fileParams = AlipayUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(urlSb.toString(), appParams, fileParams, this.charset, this.connectTimeout, this.readTimeout);
            } else {
                rsp = WebUtils.doPost(urlSb.toString(), (Map<String, String>)appParams, this.charset, this.connectTimeout, this.readTimeout);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        result.put("rsp", rsp);
        result.put("textParams", appParams);
        result.put("protocalMustParams", protocalMustParams);
        result.put("protocalOptParams", protocalOptParams);
        result.put("url", urlSb.toString());
        return result;
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

