$(function(){

	function getURLParameter(name) {// 获取URL请求参数
		return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null;
	}

	var artId = getURLParameter('id'); // 文章编号

	fetch = function(){

		if(artId==''){
			$.toast("读取数据失败");
			return;
		}

		var _path=buildHTTP("/article/fetch.shtml?artId="+artId);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='00'){
					$.toast("读取数据失败");
				}else{
					$('#artTitle').html(data.content.title);
					$('#read').html(data.content.readnum);
					$('#author').html(data.content.author);
					$('#agree').html(data.content.agree);
					$('#reviewNum').html(data.content.review);
					$('#spendTime').html(data.content.spendTime);
					$('#artContent').html(data.content.content);
				}			
			}
		});
	}

	fetch();


	$("#submitBtn").click(function(){
		var user = fetchUSER();
		if(user.hostId==0){
			$.toast("您还未登录，不允许评论");
			return;
		}
		var content = $.trim($("#content").val());
		if(content==''){
			$.toast("请填写评论内容");
			return;
		}
		$.confirm("确认提交评论？", function(){
			var params={
					articleId:artId,
					spendId:user.hostId,
					anon:'0',
					spendName:user.nick,
					head:user.head,
					content:content,
			};
			var _path = buildHTTP("/article/review/spend.shtml");
			$.ajax({
				url: _path, 
				type: "post", 
				dataType: "json",
				data:$.toJSON(params),   
				contentType:"application/json",
				success: function(data) { 
					if(data.code=='00'){
						$.toast("评论请求失败");
					}else{
						$.toast("评论成功");
						$("#content").val('');
						var reviewNum = parseInt($("#reviewNum").html())+1;
						$("#reviewNum").html(reviewNum)

						//$(".list-container").html("");
						//fetchReview(1);
						var vhtml = template("spendHtml",params);
						$(".list-container").prepend(vhtml);
						
					}			
				}
			});
		});
	});

	$("#agreeBtn").click(function(){ // 点赞
		var _path=buildHTTP("/article/agree.shtml?artId="+artId);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					$.toast("点赞成功");
					var agree = parseInt($("#agree").html())+1;
					$("#agree").html(agree)
				}else{
					$.toast("点赞失败");
				}			
			}
		});
	});

	// 查看评论部分
	var page=1,sum=0;  // 初始化页面参数
	var loading = false; // 加载flag
	var maxItems = 0;// 最多可加载的条目
	var itemsPerLoad = 10;// 每次加载添加多少条目
	var lastIndex = 10; // 上次加载序号

	fetchReview = function(_page){
		this.page=_page;
		var _path=buildHTTP("/article/review/fetch.shtml");

		var params={
				hostId:artId,
				page: _page,
				status:'1'
		};
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				maxItems = data.rowCount;
				if(data.rowCount <=lastIndex){
					$('.infinite-scroll-preloader').remove();
				}
				if(data.records.length==0){
					var vhtml = template('notReviewHtml');
					$(".list-container").html(vhtml);
				}else{
					var vhtml = template('reviewHtml', data);
					$('.list-container').append(vhtml);
				}			
			}
		});
	}; 

	fetchReview(page);

	$(document).on('infinite', '.infinite-scroll',function(e) {
		// 如果正在加载，则退出
		if (loading) return;
		// 设置flag
		loading = true;
		setTimeout(function() {
			loading = false;
			if (lastIndex >= maxItems) {
				$.detachInfiniteScroll($('.infinite-scroll'));
				$('.infinite-scroll-preloader').remove();
				return;
			}

			page++;
			lastIndex = page * itemsPerLoad;
			fetchReview(page);

		}, 1000);
	});

	$.init();

});