$(function(){

	$("#city-picker").cityPicker({
		toolbarTemplate: '<header class="bar bar-nav">\
			<button class="button button-link pull-right close-picker">确认</button>\
			<h1 class="title">城市区域</h1>\
			</header>'
	});

	var user = fetchUSER();  // 提取用户信息

	fetchAddr = function(){
		if(user.hostId==""||user.hostId==0){
			gotoLogin();
			return;
		}
		var _path=buildHTTP("/custom/addr/"+user.hostId+".shtml");
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var _addr = data.content;
					if(_addr!=null){
						$("#uname").val(_addr.name);
						$("#phone").val(_addr.phone);
						$("#addr").val(_addr.addr);
						if(_addr.province!=null && _addr.province!=''){
							$("#city-picker").val(_addr.province+"	"+_addr.city+"	"+_addr.strict);
						}
					}
				}else{
					$.toast("获取地址信息失败");
				}
			}
		});
	};


	showcart = function(){
		var prodlist = getShoppingCartProductList();
		var len = prodlist.length;
		if(len==0){
			$("#cart-content").html("<div class='card-content-inner'><br>还未购买过任何商品</div>");
			$("#_sum").html("0");
			$("#_num").html("0");
			$("#settle_card").hide();
			$("#cart_footer").hide();
			return;
		}else{
			$("#settle_card").show();
			$("#cart_footer").show();
			fetchAddr(); // 已经有商品 则填充收货地址
		}
		var sum = 0; // 总价
		var num = 0; // 商品数

		$.each(prodlist,function(i,prod){
			sum += Number(prod.price) * Number(prod.count);
			num += Number(prod.count);
		});

		var data={
				sum:sum,
				num:num,
				content:prodlist
		};
		$("#_sum").html(sum);
		$("#_num").html(num);

		var vhtml = template('cartHtml', data);
		$("#cart-content").html(vhtml);

	};

	showcart();

	$("#settleBtn").click(function(){ // 结算确认
		var prodlist = getShoppingCartProductList();
		if(prodlist.length ==0){
			$.toast('购物车无商品');
			return;
		}
		var sum = $("#_sum").text(); // 总价
		var num = $("#_num").text(); // 商品数

		var name = $("#uname").val();
		var phone = $("#phone").val();
		var addr = $("#addr").val();

		var picker = $.trim($("#city-picker").val());
		var keys =picker.split(/\s+/);
		var province=keys[0],city=keys[1],strict='';
		if(keys.length==3){
			strict = keys[2];
		}

		var params={
				hostId:user.hostId,
				sum:sum,
				num:num,
				name:name,
				phone:phone,
				province:province,
				city:city,
				strict:strict,
				addr:addr,
				content:prodlist
		};

		var _path=buildHTTP("/shopcart/firstOrd.shtml");
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					clearShoppingCart();// 清空购物车
					showcart();
					
					var ordnum = data.recordId;// 订单号
					window.location.href = buildHTTP('/protal/pay.html?ordnum='+ordnum+"&sum="+sum);
				}else{
					$.toast("生成订单失败");
				}
			}
		});

	});

	clearCart =function(){ // 清空购物车
		$.confirm("确认清空购物车吗？", function(){
			clearShoppingCart();
			showcart();
		});
	};

	delForCart = function(){ // 删除
		var flag = $("input[type='checkbox']").is(':checked');
		if(!flag){
			$.toast("至少选中一个商品");
			return;
		}
		$.confirm("确认删除选中商品吗？", function(){
			$("input[type=checkbox]").each(function(){
				if(this.checked){
					removeShoppingCartProduct($(this).val());
				}
			}); 
			showcart();
		});
	};

	$.init();
});