$(function(){

	var _id = getURLParameter('id');
	var user = fetchUSER();

	fetchEvent = function(){
		var _path=buildHTTP("/event/fetch.shtml?eventId="+_id);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='00'){
					$.toast("读取数据失败");
				}else{
					var vhtml = template("eventHtml",data.content); 
					$("#pageTitle").html(data.content.name); // 页面标题
					$("#event_detail").html(vhtml);
					$("#eventConent").html(data.content.content);
					if(data.content.signable == '0'){
						$("#sign_card").hide();
					}else{
						$("#uname").val(user.nick);
						$("#phone").val(user.uname);
						$("#eventName").val(data.content.name);
						$("#sign_card").show();
					}
				}		
			}
		});
	};

	fetchEvent(); 

	var pageNow = 1,sumpage=0;

	fetchSign = function(_page){ // 查询报名用户
		this.pageNow = _page;
		var params = {
				eventId:_id,
				page:_page
		};
		$.ajax({
			url: buildHTTP("/eventsign/find.shtml"), 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				var vhtml = template("playerHtml",data);
				$("#players").html(vhtml);
				if(data.pageCount<=1){
					$("#prexBtn").addClass("disabled");
					$("#nextBtn").addClass("disabled");
				}
			}
		});
	};

	fetchSign(pageNow); // 报名人

	prexpage = function(){
		if(pageNow>=2){
			pageNow--;
			fetchSign(pageNow);
		}else{
			$("#prexBtn").addClass("disabled");
		}

	};

	nextpage = function(){
		if(pageNow<sumpage){
			pageNow++;
			fetchSign(pageNow);
		}else{
			$("#nextBtn").addClass("disabled");
		}
	};

	$("#submitBtn").click(function(){
		var uname = $("#uname").val();
		var phone = $("#phone").val();
		var event = $("#eventName").val();
		if(uname==''||phone==''){
			$.toast('请完善姓名和联系方式');
			return;
		}

		$.confirm("确认报名参与本活动？", function(){
			var params = {
					hostId:user.hostId,
					uname:uname,
					phone:phone,
					head:user.head,
					eventId:_id,
					event:event
			};
			var _path=buildHTTP("/eventsign/join.shtml");
			$.ajax({
				url: _path, 
				type: "post", 
				dataType: "json",
				data:$.toJSON(params),   
				contentType:"application/json",
				success: function(data) { 
					if(data.code=='01'){
						$.toast("报名成功");
					}else{
						$.toast(data.msg);
					}
				}
			});
		});
	});

	$.init();
});