$(function(){

	var page=1;
	var loading = false; // 加载flag
	var maxItems = 0;// 最多可加载的条目
	var itemsPerLoad = 10;// 每次加载添加多少条目
	var lastIndex = 10;

	var city = localStorage.city;

	articlelist = function(_page){
		this.page=_page;
		var _path=buildHTTP("/article/search.shtml");
		var params={
				city:city,
				page: _page,
				status:'1'

		};
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				maxItems = data.rowCount;
				if(data.rowCount <=lastIndex){
					$('.infinite-scroll-preloader').remove();
				}
				if(data.records.length==0){
					//$(".list-container").html("空空如也");
					var vhtml =  template('noarticleHtml');
					$('.list-container').append(vhtml);
				}else{
					var vhtml = template('articleTemplate', data);
					$('.list-container').append(vhtml);
				}			
			}
		});
	}; 

	articlelist(page);

	$(document).on('infinite', '.infinite-scroll',function(e) {
		// 如果正在加载，则退出
		if (loading) return;

		// 设置flag
		loading = true;
		setTimeout(function() {
			loading = false;

			if (lastIndex >= maxItems) {
				$.detachInfiniteScroll($('.infinite-scroll'));
				$('.infinite-scroll-preloader').remove();
				return;
			}

			page++;
			articlelist(page);

			lastIndex = page * itemsPerLoad;

		}, 1000);
	});

	today = function(){// 今日头条
		var _path=buildHTTP("/article/today.shtml");
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				var vhtml = template('todayHtml', data.content);
				$('#today').html(vhtml);
			}
		});
	};

	today();

	$.init();
});