$(function(){


	function getURLParameter(name) {// 获取URL请求参数
		return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null;
	}

	var prodId = getURLParameter('id'); // 产品编号
	var norpic = ""; // 默认图片

	fetchProduct = function(){
		var _path=buildHTTP("/prod/detail.shtml?prodId="+prodId);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var prod = data.content;
					$("#_info").html(prod.info);

					analyseSwaper(prod);

				}else{
					$.toast(data.msg);
				}

			}
		});
	};

	function analyseSwaper(prod){
		var vhtml = template('swaperHtml', prod);
		$("#_swiper").html(vhtml);
		var mySwiper = new Swiper('.swiper-container', {
			speed: 400,
			spaceBetween: 100,
			mode:'horizontal',
			loop: true 
		});   

		var pHtml =  template('prodHtml', prod);
		$("#_prodInfo").html(pHtml);

		// 图文详情
		var imgHtml = template('picHtml', prod);
		$("#tab1").html(imgHtml);

		// 购物车初始化选择
		$("#_pic").attr('src',prod.pic);
		norpic = prod.pic;

		$("#_pname").html(prod.name);
		$("#_price").html(prod.price);

		// 样式
		var sHtml = template('styleHtml', prod);
		$("#styles").html(sHtml);

		// size 
		var sHtml = template('sizeHtml', prod);
		$("#sizes").html(sHtml);

	};

	fetchProduct();

	checkSel = function(){ // 判断是否有选中商品
		if($("#_bstyle").text()==''){
			$.toast("请选择产品样式分类");
			return;
		}
	};

	$("#selBtn").click(function(){
		$.closeModal("#item-list");
		var style = $.trim($("#_bstyle").text());
		if(style!=''){
			$("#_bnum").html($("#buyAmount").val()+"件");
		}
	});

	$("#buySelBtn").click(function(){ // 商品选择，初始化购物车
		$.popup("#item-list");
		$("#_bstyle").html("默认分类");
		/*var prodInfo = getShoppingCartProduct(prodId);

		if(prodInfo!=null){
			$("#buyAmount").val(prodInfo.count);
		}*/
	});

	$("#subBtn").click(function(){
		var buyAmount = Number($("#buyAmount").val());
		if(buyAmount<=1){
			return;
		}
		$("#buyAmount").val(buyAmount-1);
	});

	$("#addBtn").click(function(){
		var buyAmount = Number($("#buyAmount").val());
		$("#buyAmount").val(buyAmount+1);
	});

	pointStyle = function(e){ 
		$(e).siblings().attr("class", "sel-span");
		$(e).addClass("selected");

		$("#_bstyle").html($(e).html());

		var pic = $(e).attr("alt");

		if(pic!='' && pic!=null){
			$("#_pic").attr('src',pic);
		}else{
			$("#_pic").attr('src',norpic);
		}
	};

	pointSize = function(e){
		$(e).siblings().attr("class", "sel-span");
		$(e).addClass("selected");
		$("#_bsize").html($(e).html());
	};


	$("#add2cart").click(function(){  // 加入购物车
		checkSel();
		var type=$("#_bstyle").text()+";"+$("#_bsize").text();
		var pic = $("#_pic")[0].src; 
		var price = $("#_price").text();
		var name  = $("#_pname").text();
		var flag = addShoppingCartProduct(prodId,$("#buyAmount").val(),type,price,name,pic);
		if(flag){
			$.toast('已加入购物车');
		}
	});

	fetchAddr = function(hostId){
		var _addr = null;
		var _path=buildHTTP("/custom/addr/"+hostId+".shtml");
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			async:false,
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					_addr = data.content;
				}else{
					$.toast("获取地址信息失败");
				}
			}
		});
		return _addr;
	}

	/**
	 * 执行立即购买商品逻辑
	 */
	$("#buyBtn").click(function(){ 
		// 判断是否选中商品
		if($("#_bstyle").text()==''){
			$.toast("请选择产品样式分类");
			return;
		}
		// 判断用户是否登陆
		var user = fetchUSER(); 
		if(user.hostId==""||user.hostId==0){
			gotoLogin();
			return;
		}

		// 判断是否存在收货地址
		var _addr = fetchAddr(user.hostId);
		console.log(_addr);
		if(_addr==null ||_addr==''){
			$.confirm("无收货地址信息？现在填写", function(){
				location.href = HTTP_PREFIX+"/protal/address.html";
			});
			return;
		}

		var style=$("#_bstyle").text()+";"+$("#_bsize").text();
		var pic = $("#_pic")[0].src; 
		var price = $("#_price").text();
		var name  = $("#_pname").text();
		var amount =$("#buyAmount").val();

		var params={
				hostId:user.hostId,
				prodId:prodId,
				price:price,
				pname:name,
				style:style,
				pic:pic,
				amount:amount,
		};

		var _path=buildHTTP("/fastord/create.shtml");
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var ordnum = data.recordId;
					/*暂时不支持在线支付
					$.confirm("生成订单成功，立即支付？", function(){
						location.href = HTTP_PREFIX+'/protal/pay.html?ordnum='+ordnum;
					});*/
					
					$.confirm("订单已生成，现在查看订单？", function(){
						location.href = HTTP_PREFIX+'/protal/fastord.html';
					});
					
				}else{
					$.toast("生成订单失败");
				}
			}
		});
	});

	$.init();
});