/* 购物车实体
 */
function Product() {
	var paramid; //商品编号
	var name; // 名称
	var price; // 单价
	var type; //风格分类
	var size; // 尺码
	var count; //数量
	var pic; //商品图片
}

/*
添加商品
 */
function addShoppingCartProduct(paramid,count,type,price,name,pic) {
	if (paramid == "" || paramid == null) {
		$.toast("商品编号不能为空！");
		return false;
	}

	var productList = getShoppingCartProductList();
	var found = false;
	var i = 0;
	while (i < productList.length) {
		var productInfo = productList[i];
		if (productInfo.paramid == paramid) {
			//productInfo.name = name;
			productInfo.count = Number(count);
			//productInfo.type = type;
			//productInfo.pic = pic;
			//productInfo.price=price;
			found = true;
			break;
		}
		i++;
	}
	if (!found) {
		product = new Object();
		product.paramid = paramid;
		product.name = name;
		product.pic = pic;
		product.count = count;
		product.type = type;
		product.price = price;
		productList.push(product);
	}
	localStorage.shoppingCartProductList = JSON.stringify(productList);
	return true;
}

/*
取得商品
 */
function getShoppingCartProduct(paramid) {
	var productList = getShoppingCartProductList();
	var i = 0;
	while (i < productList.length) {
		var productInfo = productList[i];
		if (productInfo.paramid == paramid) {
			return productInfo;
		}
		i++;
	}
	return null;
}
/*
取得商品列表
 */
function getShoppingCartProductList() {
	if (localStorage.shoppingCartProductList == undefined || localStorage.shoppingCartProductList == "undefined" || localStorage.shoppingCartProductList == "") {
		var newProductList = new Array();
		localStorage.shoppingCartProductList = JSON.stringify(newProductList);
	}
	var productList = JSON.parse(localStorage.shoppingCartProductList);
	return productList;
}

/*
清空购物车
 */
function clearShoppingCart() {
	var productList = new Array();
	localStorage.shoppingCartProductList = JSON.stringify(productList);
}
/*
删除商品
 */
function removeShoppingCartProduct(paramid) {
	var productList = getShoppingCartProductList();
	var i = 0;
	while (i < productList.length) {
		var productInfo = productList[i];
		if (productInfo.paramid == paramid) {
			productList.splice(i, 1);
			break;
		}
		i++;
	}
	localStorage.shoppingCartProductList = JSON.stringify(productList);
}
/*
	修改商品数量
 */
function updateShoppingCartProduct(paramid, count) {
	var productList = getShoppingCartProductList();
	var i = 0;
	while (i < productList.length) {
		var productInfo = productList[i];
		if (productInfo.paramid == paramid) {
			productInfo.count = count;
			break;
		}
		i++;
	}
	localStorage.shoppingCartProductList = JSON.stringify(productList);
}

