$(function(){

	$("#city-picker").cityPicker({
		toolbarTemplate: '<header class="bar bar-nav">\
			<button class="button button-link pull-right close-picker">确认</button>\
			<h1 class="title">城市区域</h1>\
			</header>'
	});

	var user = fetchUSER();
	
	fetchMember = function(){
		if(user.uname==""||user.hostId==""||user.hostId==0){
			gotoLogin();
			return;
		}
		
		$("#uname").html(user.uname);
		var _path = buildHTTP("/member/findOne.shtml?hostId="+user.hostId);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var mem = data.content;
					$("#nick").val(mem.nick);
					$("#email").val(mem.email);
					$("#call").val(mem.nick);
					$("#tel").val(mem.phone);
					$("#sex").val(mem.sex);
					$("#birth").val(mem.birth);
					if(mem.province!=null && mem.province!=''){
						$("#city-picker").val(mem.province+" "+mem.city+" "+mem.strict);
					}
					$("#grade").html(mem.grade);
					if(mem.utype=='2'){
						$("#isMerch").attr("checked","true");
					}
					if(mem.logo!=null && mem.logo!=''){
						$("#headLogo").attr("src",HTTP_PREFIX+"/upload"+mem.logo);
					}
				}
			}
		});
	}; 


	fetchMember();

	$("#saveBtn").click(function() {
		var user = fetchUSER();
		var picker = $.trim($("#city-picker").val());
		var keys =picker.split(/\s+/);
		var province=keys[0],city=keys[1],strict='';

		if(keys.length==3){
			strict = keys[2];
		}

		var params = {
				hostId:user.hostId,
				email:$("#email").val(),
				nick:$("#nick").val(),
				birth:$("#birth").val(),
				sex:$("#sex").val(),
				province:province,
				city:city,
				strict:strict
		};

		var _path=buildHTTP("/member/save.shtml");
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					localStorage.city = city; // 修改城市
					$.toast("保存成功");
				}else{
					$.toast("保存失败");
				}
			}
		});
	});

	$("#logoutBtn").click(function(){
		logout();
	});

	var hasSign='0'; // 未签到

	todayHasSign = function(){
		var _path=buildHTTP("/member/hasSign.shtml?hostId="+user.hostId);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					hasSign = data.recordId;
					if(hasSign=='1'){
						//$.toast("签到成功");
						$("#signTip").html("今日已签到");
					}else{
						$("#signTip").html("今日未签到");
					}

				}
			}
		});
	};

	todayHasSign();

	$("#signBtn").click(function(){// 签到
		if(hasSign=='1'){
			$.toast("今日已签到");
			return;
		}
		var _path=buildHTTP("/member/sign.shtml?hostId="+user.hostId);
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					if(data.recordId=='1'){
						$("#grade").html(data.content);
						$("#signTip").html("今日已签到");
					}
					$.toast("今日已签到成功");
				}else{
					$.toast("签到失败");
				}
			}
		});
	});
	$("#updatePwdBtn").click(function(){
		var pwd = $.trim($("#pwd").val());
		var npwd= $.trim($("#npwd").val());
		var repwd=$.trim($("#repwd").val());
		var phone = user.uname;

		if(pwd==''||npwd==''||repwd==''){
			$.toast("密码不能为空！");
			return;
		}
		if(npwd!=repwd){
			$.toast("两次密码不一致，请检查");
			return;
		}
		var secpwd = $.md5(npwd);
		var params={
				phone:phone,
				pwd:$.md5(pwd),
				npwd:secpwd,
		};
		var _path=buildHTTP("/member/updatepwd.shtml");
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					localStorage.pwd=secpwd;
					$.confirm("修改密码成功,确认返回", function(){
						$.router.back("user.html")
					});

				}else{
					$.toast(data.msg);
				}
			}
		});
	});

	$("#lwdBtn").click(function(){ // 反馈留言
		var call = $("#call").val();
		var tel = $("#tel").val();
		var lvword =$("#lvword").val();
		if(call==''||tel==''||lvword==''){
			$.toast("称呼、电话、留言信息不能为空");
			return;
		}
		if(lvword.len()<30){
			$.toast("留言信息至少30字");
			return;
		}
		if(lvword.len()>220){
			$.toast("留言内容过长，请简要说明");
			return;
		}
		var params={
				hostId:user.hostId,
				uname:call,
				tel:tel,
				lvword:lvword
		};
		
		$.confirm("确认提交留言", function(){
			var _path=buildHTTP("/leaveword/save.shtml");
			$.ajax({
				url: _path, 
				type: "post", 
				dataType: "json",
				data:$.toJSON(params),   
				contentType:"application/json",
				success: function(data) { 
					if(data.code=='01'){
						$.toast("留言提交成功，感谢您的反馈！");
					}else{
						$.toast(data.msg);
					}
				}
			});
		});
	});

	$.init();
});