$(function(){

	var myreg = /(1[3-9]\d{9}$)/;

	var _reg = /\w+[@]{1}\w+[.]\w+/; // 邮件

	var flowCode = '';
	
	var user = fetchUSER(); // 获取用户信息
	
	initUname = function(){
		$("#phone").val(user.uname);
	};
	
	initUname();
	
	sendPhoneCode = function(){ // 短信验证码
		var phone = $.trim($("#phone").val());
		if(phone==''){
			$.toast('请填写当前使用手机号');
			return;
		}
		if(!myreg.test(phone)){
			$.toast('请填写正确手机号');
			return;
		}

		$.ajax({
			url:HTTP_PREFIX+"/flow/resetpwd.shtml?phone="+phone,
			type:"get",
			dataType: "json",
			async:true,
			contentType:"application/json",
			success:function(data){
				if(data.code=='01'){
					flowCode = data.content;
					$.toast("验证码已发送");
				}else{
					$.toast(data.msg);
				}
			}
		});
	};
	
	sendEmail = function(){
		var phone = $.trim($("#phone").val());
		if(phone==''){
			$.toast('请填写正确用户名');
			return;
		}
		if(!_reg.test(phone)){
			$.toast('邮箱格式不正确');
			return;
		}
		$.ajax({
			url:HTTP_PREFIX+"/flow/sendPwdEmail.shtml?em="+phone,
			type:"get",
			dataType: "json",
			async:true,
			contentType:"application/json",
			success:function(data){
				if(data.code=='01'){
					flowCode = data.content;
					$.toast("验证码已发送");
				}else{
					$.toast(data.msg);
				}
			}
		});
	};
	

	$("#spendBtn").click(function(){
		sendEmail();
	});


	$("#submitBtn").click(function(){
		var phone = $.trim($("#phone").val());
		var pwd = $.trim($("#pwd").val());
		var code = $.trim($("#code").val());

		if(phone==''||pwd==''){
			$.toast('用户名或密码不能为空！');
			return;
		}
		if(code==''){
			$.toast('请填写6位验证码');
			return;
		}

		var secpwd=$.md5(pwd);
		var params={  
				uname : phone,
				phone : phone,    
				pwd : secpwd,
				code: code,
				flowCode:flowCode
		};
		$.ajax({
			url:HTTP_PREFIX+'/member/resetpwd.shtml',
			type:"post",
			data:$.toJSON(params),   
			dataType: "json",
			async:true,
			contentType:"application/json",
			success:function(data){
				if(data.code=='01'){
					localStorage.pwd = ""; // 删除密码 
					$.confirm("密码修改成功，现在登陆？", function(){
						window.location.href = 'login.html';
					});
				}else{
					$.toast(data.msg);
				}
			}
		});

	});

	$.init();
});