$(function(){

	var myreg = /(1[3-9]\d{9}$)/;

	var _reg = /\w+[@]{1}\w+[.]\w+/; // 邮件

	var flowCode = '';

	sendEmail = function(em){
		var phone = $.trim($("#phone").val());
		if(phone==''){
			$.toast('请填写正确用户名');
			return;
		}
		if(!_reg.test(phone)){
			$.toast('邮箱格式不正确');
			return;
		}
		$.ajax({
			url:HTTP_PREFIX+"/member/spendEmail.shtml?em="+phone,
			type:"get",
			dataType: "json",
			async:true,
			contentType:"application/json",
			success:function(data){
				if(data.code=='01'){
					flowCode = data.content;
					$.toast("验证码已发送");
				}else{
					$.toast(data.msg);
				}
			}
		});

	};
	
	spendCode = function(){
		var phone = $.trim($("#phone").val());
		if(phone==''){
			$.toast('请填写当前使用手机号');
			return;
		}
		if(!myreg.test(phone)){
			$.toast('请填写正确手机号');
			return;
		}
		$.ajax({
			url:HTTP_PREFIX+"/member/regist/"+phone+".shtml",
			type:"get",
			dataType: "json",
			async:true,
			contentType:"application/json",
			success:function(data){
				if(data.code=='01'){
					flowCode = data.content;
					$.toast("验证码已发送");
				}else{
					$.toast(data.msg);
				}
			}
		});
	};
	
	$("#spendBtn").click(function(){ // 发送邮件注册码
		sendEmail(); 
	});

	
	$("#registBtn").click(function(){
		var phone = $.trim($("#phone").val());
		var pwd = $.trim($("#pwd").val());
		var repwd =$.trim($("#repwd").val());
		var code = $.trim($("#code").val());

		if(phone==''||pwd==''||repwd==''){
			$.toast('用户名或密码不能为空！');
			return;
		}
		if(code==''){
			$.toast('请填写验证码');
			return;
		}
		if(pwd!=repwd){
			$.toast('两次密码不一致请检查');
			return;
		}
		if(flowCode==''){
			$.toast('验证码已经失效，再次发送');
			return;
		}

		var secpwd=$.md5(pwd);
		var params={    
				phone : phone,    
				pwd : secpwd,
				code:code,
				flowCode:flowCode
		};
		
		$.ajax({
			url:HTTP_PREFIX+'/member/regist.shtml',
			type:"post",
			data:$.toJSON(params),   
			dataType: "json",
			async:true,
			contentType:"application/json",
			success:function(data){
				if(data.code=='01'){
					var mem=data.content;
					localStorage.hostId = mem.hostId; 
					localStorage.utype = mem.utype; 
					localStorage.uname = mem.uname; 
					localStorage.pwd = secpwd; 
					$.confirm("您已注册成功，现在登陆？", function(){
						window.location.href = 'login.html';
					});

				}else{
					$.toast(data.msg);
				}
			}
		});

	});

	$.init();
});