$(function(){

	var ue = UE.getEditor('editor');

	fetchNation = function(target,parent,type){
		$.ajax({
			url: HttpRest+"nation/child.shtml?parent="+parent, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				var vhtml = "<option value=''>请选择</option>";
				if(type=='1'){ // 省份
					$.each(data,function(i,addr){
						vhtml += "<option value='"+addr.id+"'>"+addr.province+"</option>";
					});
				}else if(type=='2'){
					$.each(data,function(i,addr){
						if(addr.city==''){
							vhtml += "<option>"+addr.district+"</option>";
						}else{
							vhtml += "<option>"+addr.city+"</option>";
						}
					});
				}
				$(target).html(vhtml);
			}
		});
	}

	fetchNation("#province",'1','1'); // 查询省份

	$("#province").change(function(){
		var parnet = $(this).val();
		fetchNation("#city",parnet,'2');
	});

	$("#submitBtn").click(function(){

		var articleId = $("#articleId").val();
		var boardId = $("#boardId").val();

		var boardId=$("#boardId").val();
		var title = $("#title").val();
		var origin = $("#origin").val();

		var reprint = $("#reprint").val();
		var author = $("#author").val();
		var status =$("#status").val();
		var fauth  =$("#fauth").val();
		var top = $("#top").val();
		var fpath = $("#fpath").val();

		var pic = $.trim($("#pic").val());

		var digest = $("#digest").val();
		var content= UE.getEditor('editor').getContent();

		var prop = $("#prop").val();
		var eventId =$("#eventId").val();
		var today = $("#today").val();

		var city = $("#city").val();
		if(articleId==''||articleId=='0'){
			if(city.indexOf("市")!=-1){
				city = city.substring(0,city.length-1);
			}
		}else{
			city = ""; // 新闻文章不允许更改
		}

		var open = $("#open").val();
		var params = {
				articleId:articleId,
				boardId:boardId,
				boardId:boardId,
				city:city,
				title:title,
				reprint:reprint,
				author:author,
				fauth:fauth,
				status:status,
				top:top,
				fpath:fpath,
				pic:pic,
				digest:digest,
				content:content,
				prop:prop,
				eventId:eventId,
				today:today,
				open:open
		};

		var _httpURL = "";
		if(articleId==''||articleId==0){
			_httpURL = HttpRest+"article/create.shtml";
		}else{
			_httpURL = HttpRest+"article/save.shtml";
		}
		$.ajax({
			url: _httpURL, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					layer.confirm('保存成功！是否关闭窗口?', function(index) {
						parent.grid.loadData();
						parent.layer.close(parent.pageii);
						return false;
					});
				}else{
					layer.msg('保存失败！',{icon: 5});
				}
			}
		});
	});


	fetchBoard = function(_target,_supId){// 提取下级板块分类
		var _httpURL = HttpRest+"board/child/"+_supId+".shtml";
		$.ajax({
			url: _httpURL, 
			type: "get", 
			contentType:"application/json",
			success: function(data) { 
				if (data != null) {
					var h = "";
					for ( var i = 0; i < data.length; i++) {
						h+="<option value='" + data[i].boardId + "'>"+ data[i].name + "</option>";
					}
					$(_target).html(h);
				} else {
					layer.msg("获取板块信息错误，请联系管理员！",{icon: 5});
				}
			}
		});
	}

	fetchBoard("#mainBoard",0); // 初始化类别
	fetchBoard("#boardId",1);
	
	$("#mainBoard").change(function(){
		var boardId = $(this).val();
		fetchBoard("#boardId",boardId);
	});

	onloadurl();

});