var pageii = null;
var grid = null;
$(function() {
	grid = lyGrid({
		id : 'paging',
		l_column : [ {
			colkey : "articleId",
			width : "50px",
			hide : true
		}, {
			colkey : "title",
			name : "标题",
			align:"left",
			width : "350px",
		}, {
			colkey : "origin",
			name : "来源",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.origin=='1'){
					return "原创";
				}else{
					return "转载";
				}
			}
		}/*, {
			colkey : "top",
			name : "是否置顶",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.top=='1'){
					return "<span color='red'>是</span>";
				}else{
					return "否";
				}
			}
		}*/, {
			colkey : "today",
			name : "是否头条",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.today=='1'){
					return "<span color='red'>是</span>";
				}else{
					return "否";
				}
			}
		}, {
			colkey : "readnum",
			name : "阅读量",
		}
		, {
			colkey : "agree",
			name : "点赞量",
		}, {
			colkey : "recmm",
			name : "是否推荐",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.recmm=='1'){
					return "<span color='red'>是</span>";
				}else{
					return "否";
				}
			}
		}, {
			colkey : "spendTime",
			name : "发布时间",
			/*renderData : function( rowindex ,data, rowdata, colkeyn) {
				return new Date(rowdata.spendTime).format("yyyy-MM-dd hh:mm:ss");
			}*/
		}, {
			colkey : "author",
			name : "作者",
			align:"left"
		}, {
			colkey : "status",
			name : "状态",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.status=='1'){
					return "已发布";
				}else if(rowdata.status=='0'){
					return "草稿";
				}else if(rowdata.status=='2'){
					return "关闭";
				}
			}
		}],
		jsonUrl : rootPath + '/article/find.shtml',
		checkbox : true,
		serNumber : false,
		checkValue:'articleId'
	});


	$("#search").click("click", function() {// 绑定查询按扭
		var searchParams = $("#searchForm").serializeJson();// 初始化传参数
		grid.setOptions({
			data : searchParams
		});
	});
	$("#addBtn").click("click", function() {
		spendArticle();
	});
	$("#editBtn").click("click", function() {
		editArticle();
	});
	$("#delBtn").click("click", function() {
		deleteArticle();
	});
	$("#reviewBtn").click("click", function() {
		fetchReview();
	});

	$("#todayBtn").click(function(){
		setToday();
	});

});

function editArticle() {
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("只能选中一个");
		return;
	}
	pageii = layer.open({
		title : "文章编辑",
		type : 2,
		area : [ "1024px", "80%" ],
		content : rootPath + '/article/editUI.shtml?id=' + cbox
	});
}
function spendArticle() {
	pageii = layer.open({
		title : "添加文章",
		type : 2,
		area : [ "1024px", "80%" ],
		content : rootPath + '/article/addUI.shtml'
	});
}

function deleteArticle() {
	var cbox = grid.getSelectedCheckbox();
	if (cbox == "") {
		layer.msg("请选择删除项！！");
		return;
	}
	layer.confirm('确认删除当前文章？', function(index) {
		var _URL = rootPath + '/article/delete.shtml';
		var resp = CommnUtil.ajax(_URL, {
			ids : cbox.join(",")
		}, "json");
		layer.msg(resp.code,{icon: 5});
		if (resp.code == "01") {
			layer.msg(resp.msg,{icon: 1});
			grid.loadData();
		} else {
			layer.msg('删除失败',{icon: 5});
		}
	});
}

function fetchReview(){
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("请选择文章");
		return;
	}
	pageii = layer.open({
		title : "评论列表",
		type : 2,
		area : [ "1024px", "80%" ],
		content : rootPath + '/article/reviewUI.shtml?id=' + cbox
	});
}

function setToday(){
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("请选择文章");
		return;
	}
	layer.confirm('设置当前文章为头条？', function(index) {
		var _URL = rootPath + '/article/setToday.shtml';
		var resp = CommnUtil.ajax(_URL, {
			ids : cbox.join(",")
		}, "json");
		layer.msg(resp.code,{icon: 5});
		if (resp.code == "01") {
			layer.msg("设置成功",{icon: 1});
			grid.loadData();
		} else {
			layer.msg('设置失败',{icon: 5});
		}
	});
};