var pageii = null;
var grid = null;
$(function() {
	grid = lyGrid({
		id : 'paging',
		l_column : [ {
			colkey : "merchId",
			width : "100px",
			hide : true
		}, {
			colkey : "name",
			name : "名称"
		}
		, {
			colkey : "link",
			name : "联系人",
		}, {
			colkey : "phone",
			name : "联系电话",
		}
		, {
			colkey : "degree",
			name : "合作级别",
		}, {
			colkey : "status",
			name : "状态",
			width:"60px",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.status=='1'){
					return "正常";
				}else{
					return "<span style='color:red;'>锁定</span>";
				}
			}
		}
		, {
			colkey : "payType",
			name : "结算方式",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.payType=='1'){
					return "支付宝";
				}else if (rowdata.payType=='2'){
					return "微信";
				}else{
					return "银联";
				}
			}
		}
		, {
			colkey : "payAcct",
			name : "结算帐号",
		}],
		jsonUrl : rootPath + '/ebus/merchant/find.shtml',
		checkbox : true,
		serNumber : false,
		checkValue:'merchId'
	});

	$("#search").click("click", function() {// 绑定查询按扭
		var searchParams = $("#searchForm").serializeJson();// 初始化传参数
		grid.setOptions({
			data : searchParams
		});
	});

	$("#addBtn").click("click", function() {
		add();
	});

	$("#showBtn").click("click", function() {
		showMerch();
	});

	$("#editBtn").click("click", function() {
		edit();
	});

	$("#delBtn").click("click", function() {
		del();
	});
	
	$("#prodBtn").click(function(){
		addProd();
	});
	
});
function add(){
	pageii = layer.open({
		title : "添加商户",
		type : 2,
		area : [ "750px", "60%" ],
		content : rootPath + '/ebus/merchant/addUI.shtml'
	});
};
function edit() {
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("只能选中一个");
		return;
	}
	pageii = layer.open({
		title : "商户编辑",
		type : 2,
		area : [ "650px", "60%" ],
		content : rootPath + '/ebus/merchant/editUI.shtml?id=' + cbox
	});
}

function showMerch() { // 商家运营状况、结款账单等
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("选择一个商户");
		return;
	}
	pageii = layer.open({
		title : "商户信息",
		type : 2,
		area : [ "650px", "60%" ],
		content : rootPath + '/ebus/merchant/show.shtml?id=' + cbox
	});
}
function del() {
	var cbox = grid.getSelectedCheckbox();
	if (cbox == "") {
		layer.msg("请选择锁定商户项！！");
		return;
	}
	layer.confirm('确认锁定吗？', function(index) {
		var _URL = rootPath + '/ebus/merchant/lock.shtml';
		var resp = CommnUtil.ajax(_URL, {
			ids : cbox.join(",")
		}, "json");
		layer.msg(resp.code,{icon: 5});
		if (resp.code == "01") {
			layer.msg(resp.msg,{icon: 1});
			grid.loadData();
		} else {
			layer.msg('删除失败',{icon: 5});
		}
	});
}

function addProd(){
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("选择一个商户");
		return;
	}
	pageii = layer.open({
		title : "产品上架",
		type : 2,
		area : [ "960px", "80%" ],
		content : rootPath + '/prod/addUI.shtml?merchId='+cbox
	});
};


