var pageii = null;
var grid = null;
$(function() {
	grid = lyGrid({
		id : 'paging',
		l_column : [ {
			colkey : "prodId",
			width : "100px",
			hide : true
		}, {
			colkey : "sku",
			name : "SKU编码"
		}, {
			colkey : "name",
			name : "名称",
			align: "left",
		}, {
			colkey : "price",
			name : "售价",
		}, {
			colkey : "orig",
			name : "市场价",
		}, {
			colkey : "status",
			name : "上架状态",
			width:"60px",
			renderData : function( rowindex ,data, rowdata, colkeyn) {
				if(rowdata.status=='1'){
					return "正常";
				}else if(rowdata.status=='-1'){
					return "已下架";
				}else{
					return "维护中";
				}
			}
		}],
		jsonUrl : rootPath + '/prod/search.shtml',
		checkbox : true,
		serNumber : false,
		checkValue:'prodId'
	});

	$("#search").click("click", function() {// 绑定查询按扭
		var searchParams = $("#searchForm").serializeJson();// 初始化传参数
		grid.setOptions({
			data : searchParams
		});
	});
	
	$("#addBtn").click("click", function() {
		add();
	});
	
	$("#styleBtn").click("click", function() {
		showDetail();
	});
	
	$("#editBtn").click("click", function() {
		edit();
	});
	
	$("#delBtn").click("click", function() {
		del();
	});
	
	$("#storeBtn").click(function(){
		showStore();
	});
	
	$("#sizeBtn").click(function(){
		var cbox = grid.getSelectedCheckbox();
		if (cbox.length > 1 || cbox == "") {
			layer.msg("选中一个产品");
			return;
		}
		pageii = layer.open({
			title : "产品尺码",
			type : 2,
			area : [ "650px", "50%" ],
			content : rootPath + '/prod/sizeEdit.shtml?id=' + cbox
		});
	});
	
	$("#imgBtn").click(function(){
		var cbox = grid.getSelectedCheckbox();
		if (cbox.length > 1 || cbox == "") {
			layer.msg("选中且只选中一个商品");
			return;
		}
		pageii = layer.open({
			title : "产品图片",
			type : 2,
			area : [ "650px", "70%" ],
			content : rootPath + '/prod/pictureEdit.shtml?id=' + cbox
		});
	});
});

function add(){
	pageii = layer.open({
		title : "添加商品",
		type : 2,
		area : [ "960px", "80%" ],
		content : rootPath + '/prod/addUI.shtml?merchId=0'
	});
};

function edit() {
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("只能选中一个");
		return;
	}
	pageii = layer.open({
		title : "商品编辑",
		type : 2,
		area : [ "960px", "80%" ],
		content : rootPath + '/prod/editUI.shtml?id=' + cbox
	});
}
function del() {
	var cbox = grid.getSelectedCheckbox();
	if (cbox == "") {
		layer.msg("请选择下架商品吗！！");
		return;
	}
	layer.confirm('请选择下架当前商品吗？', function(index) {
		var _URL = rootPath + '/prod/down.shtml';
		var resp = CommnUtil.ajax(_URL, {
			ids : cbox.join(",")
		}, "json");
		layer.msg(resp.code,{icon: 5});
		if (resp.code == "01") {
			layer.msg(resp.msg,{icon: 1});
			grid.loadData();
		} else {
			layer.msg('删除失败',{icon: 5});
		}
	});
}

// 查询款型及尺码分类
function showDetail(){
	var cbox = grid.getSelectedCheckbox();
	if (cbox.length > 1 || cbox == "") {
		layer.msg("选中一个产品");
		return;
	}
	pageii = layer.open({
		title : "风格款型",
		type : 2,
		area : [ "650px", "65%" ],
		content : rootPath + '/prod/style.shtml?id=' + cbox
	});
}
