$(function(){

	
	fetchSize = function(){
		var prodId = $("#prodId").val();
		var _path=HttpRest+"prod/size/fetch.shtml?prodId="+prodId;
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var vhtml = template('sizeHtml', data);
					$("#sizeTb").html(vhtml);
				}		
			}
		});
	};

	fetchSize();

	selectSize = function(xthis){
		if($(xthis).hasClass('selected')){
			$(xthis).removeClass("selected");
		}else{
			$(xthis).addClass('selected');
		}
	};

	$("#sizeBtn").click(function(){ // 保存尺码
		var sizeName = $("#sizeName").val();
		if(sizeName==''){
			layer.msg('请填写尺码',{icon: 5});
			return;
		}
		var prodId = $("#prodId").val();
		var params={prodId:prodId,zname:sizeName};

		var _path=HttpRest+"prod/size/save.shtml";
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					layer.msg('保存成功',{icon: 1});
					$("#sizeName").val("");
					fetchSize();
				}
			}
		});
	});
	
	deleteSize = function(sizeId,zname){
		var _path=HttpRest+"prod/size/delete.shtml?sizeId="+sizeId;
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					$("#size_"+sizeId).remove();
					layer.msg('删除成功',{icon: 1});
				}		
			}
		});
	};
});
