$(function(){

	fetchStyle = function(){
		var prodId = $("#prodId").val();
		var _path=HttpRest+"prod/style/fetch.shtml?prodId="+prodId;
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var vhtml = template('styleHtml', data);
					$("#styleTb").html(vhtml);
				}		
			}
		});
	};

	fetchStyle();

	styleEdit = function(styleId,name,pic){
		$("#styleId").val(styleId);
		$("#styleName").val(name);
		$("#stylePic").val(pic);
	};

	deleteStyle = function(styleId,name){

		var _path=HttpRest+"prod/style/delete.shtml?styleId="+styleId;
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					$("#"+styleId).remove();
					layer.msg('删除成功',{icon: 1});
				}		
			}
		});
	};

	$("#styleBtn").click(function(){
		var prodId = $("#prodId").val();
		var styleId = $("#styleId").val();
		var name=$("#styleName").val();
		var pic =$("#stylePic").val();
		var params={prodId:prodId,styleId:styleId,name:name,pic:pic};

		var _path=HttpRest+"prod/style/save.shtml";
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					layer.msg('保存成功',{icon: 1});

					$("#styleId").val("");
					$("#styleName").val("");
					$("#stylePic").val("");

					fetchStyle();
				}
			}
		});
	});


/**
	fetchSize = function(){
		var prodId = $("#prodId").val();
		var _path=HttpRest+"prod/size/fetch.shtml?prodId="+prodId;
		$.ajax({
			url: _path, 
			type: "get", 
			dataType: "json",
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					var vhtml = template('sizeHtml', data);
					$("#sizeTb").html(vhtml);
				}		
			}
		});
	};

	fetchSize();

	selectSize = function(xthis){
		if($(xthis).hasClass('selected')){
			$(xthis).removeClass("selected");
		}else{
			$(xthis).addClass('selected');
		}
	};

	$("#sizeBtn").click(function(){ // 保存尺码
		var sizeName = $("#sizeName").val();
		if(sizeName==''){
			layer.msg('请填写尺码',{icon: 5});
			return;
		}
		var prodId = $("#prodId").val();
		var params={prodId:prodId,zname:sizeName};

		var _path=HttpRest+"prod/size/save.shtml";
		$.ajax({
			url: _path, 
			type: "post", 
			dataType: "json",
			data:$.toJSON(params),   
			contentType:"application/json",
			success: function(data) { 
				if(data.code=='01'){
					layer.msg('保存成功',{icon: 1});
					$("#sizeName").val("");
					$("#sizeTb").append("<span class='prod_size' onclick='selectSize(this)' alt='"+data.recordId+"'>"+sizeName+"</span>");
				}
			}
		});
	});
	
	$("#delSizeBtn").click(function(){
		
		$("#sizeTb span[class='selected']").each(function(){
            alert($(this).html());
        })
	});
	**/
});
