$(function(){

	isLogin();// 判断用户是否登录

	var uemail='',uphone='',supman='0';
	/*--------------------------------------- 基本信息-----------------------------------*/ 
	fetchInfo = function(){
		$.ajax({
			url:buildRequest('/system/admin/'+ localStorage.uname +'/info'),
			type:"get",
			success:function(data){
				if(data.code=='01'){
					var admin=data.content;
					$("#uname").html(admin.uname);
					$("#name").html(admin.name);
					$("#phone").html(admin.phone);
					$("#user-email").val(admin.email);
					$("#user-phone").val(admin.phone);
					$("#supman").val(admin.supman);
					supman = admin.supman;
					uemail = admin.email;
					uphone = admin.phone;

					if(admin.status=='1'){
						$("#status").html("正常");
					}else{
						$("#status").html("锁定");
					}
					if(supman=='0'){ // 删除添加表单
						$("#collapse-panel-2").html("<br><p>&nbsp;&nbsp;您无权添加管理员！</p>");
					}

					userlist(); // 判断是否查询管理员
				}else{
					alertify.error(data.msg);
				}
			}
		});
	};

	fetchInfo();

	/*--------------------------------------- 修改信息-----------------------------------*/
	accountExist = function(uname){
		var flag=false;
		$.ajax({
			url:buildRequest('/system/admin/'+ uname +'/info'),
			type:"get",
			success:function(data){
				if(data.code=='01'){
					flag=true;
				}
			}
		});
		return flag;
	};

	$("#updateBtn").click(function(){
		var email=$("#user-email").val();
		var phone=$("#user-phone").val();
		if(email==uemail && phone==uphone){
			alertify.error("邮箱或手机号未发生有效改变");
			return false;
		}
		reset();
		alertify.confirm("确认修改当前邮箱或手机号码？",function(e){
			if(e){
				var params={uname:localStorage.uname,email:email,phone:phone}; // 参数
				$.ajax({
					url:buildRequest('/system/admin'),
					type:"post",
					data:$.toJSON(params),    
					success:function(data){
						if(data.code=='01'){
							$("#phone").html(phone);
							alertify.success("修改邮箱或手机号成功！");
						}else{
							alertify.error(data.msg);
						}
					}
				});
			}
		});
	});


	$("#addBtn").click(function(){

		var loginName=$.trim($("#loginName").val());
		var realname =$.trim($("#realname").val());
		var email = $.trim($("#email").val());
		var linkphone = $.trim($("#linkphone").val());
		var loginPwd =  $.trim($("#loginPwd").val());

		if(loginName==''||realname==''||email==''||linkphone==''||loginPwd==''){
			alertify.error("管理员信息缺失，请检查");
			return;
		}
		var c = /^[1]\d{10}$/;
		if (!c.test(linkphone)) {
			alertify.error("请输入正确的手机号");
			return;
		}

		// 判断用户等是是否存在
		var flag=accountExist(loginName);
		if(flag){
			alertify.error("当前用户名已经存在！");
			return;
		}

		var params={
				uname:loginName,
				email:email,
				phone:linkphone,
				pwd:$.md5(loginPwd),
				name:realname,
				_method:'put'
		};

		$.ajax({
			url:buildRequest("/system/admin"),
			type:"put",
			data:$.toJSON(params),    
			success:function(data){
				if(data.code=='01'){
					alertify.success("添加管理员【"+loginName+"】成功！");
				}else{
					alertify.error(data.msg);
				}
			}
		});

	});

	$("#updatePwdBtn").click(function(){ // 修改密码
		var oldpwd=$.trim($("#oldpwd").val());
		var newpwd=$.trim($("#newpwd").val());
		var repwd=$.trim($("#repwd").val());

		if(oldpwd==''||newpwd==''||repwd==''){
			alertify.error("请填写密码！");
			return;
		}

		var secpwd=$.md5(oldpwd);
		if(secpwd!=localStorage.pwd){
			alertify.error("原密码不正确，忘记密码请找管理员");
			return;
		}
		if(newpwd!=repwd){
			alertify.error("两次密码不一致，请检查");
			return;
		}

		if(newpwd.length<6){
			alertify.error("至少6位密码");
			return;
		}
		reset();
		alertify.confirm("修改后需要再次登陆才能继续操作，确认修改密码？",function(e){
			if(e){
				newpwd=$.md5(newpwd);
				var params={
						uname:localStorage.uname,
						pwd:secpwd,
						newpwd:newpwd
				};
				$.ajax({
					url:buildRequest("/system/admin/pwd"),
					type:"post",
					data:$.toJSON(params),    
					success:function(data){
						if(data.code=='01'){
							localStorage.pwd='';
							window.location.href = 'system/login.jsp';
						}else{
							alertify.error(data.msg);
						}
					}
				});
			}
		});

	});


	/*---------------------------------------------------------------------------------------*/

	userlist = function(){
		if(supman =='0'){
			$("#group-user-list").html("<p class='ind2 am-kai'>您无权操作</p>");
			return;
		}
	};

	var sum_page = 0,_page=1; // 总页数 当前页

	buildPaging = function(){
		/*$('#page').jqPaginator({
		    totalPages: sum_page,
		    visiblePages: 5,
		    currentPage: _page,
		    onPageChange: function (num, type) {
		    	if(_page>1){
		    		search(num);
		    	}
		    }
		});*/
		$('#page').pagination({
			pages: sum_page,
			itemsOnPage: 5,
			cssStyle: 'light-theme'
		});
	};

	search =  function(_page){
		var kw = $.trim($("#kw").val());
		var params ={
				kw:kw,
				page:_page
		};
		$.ajax({
			url:buildRequest("/system/admin/find"),
			type:"post",
			data:$.toJSON(params),    
			success:function(data){
				if(data.code=='01'){
					if(_page<=1){ 
						sum_page = data.page;
						buildPaging();
					}
					var result = {results:data.content}
					var vhtml = template('adminUserHtml', result);
					$("#tb").html(vhtml);

				}else{
					alertify.error("查询失败");
				}
			}
		});
	}

	$("#searchBtn").click(function(){
		search(_page);
	});

	updateStatus = function(uname,status){
		reset();
		var tipmsg="";
		if(status=='1'){
			tipmsg="确认激活【"+uname+"】账户吗？";
		}else{
			tipmsg="确认锁定【"+uname+"】账户吗？";
		}

		alertify.confirm(tipmsg,function(e){
			if(e){
				var params={uname:uname,status:status};
				$.ajax({
					url:buildRequest('/system/admin'),
					type:"post",
					data:$.toJSON(params),    
					success:function(data){
						if(data.code=='01'){
							$("#phone").html(phone);
							alertify.success("操作成功");
							search(_page);
						}else{
							alertify.error(data.msg);
						}
					}
				});
			}
		});
	};


});