/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.handlers.command;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class DeleteFileCommand
extends XMLCommand
implements IPostCommand {
    private String fileName;

    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (errorNum == 0) {
            this.createDeleteFielsNode(rootElement);
        }
    }

    private void createDeleteFielsNode(Element rootElement) {
        Element element = this.creator.getDocument().createElement("DeletedFile");
        element.setAttribute("name", this.fileName);
        rootElement.appendChild(element);
    }

    protected int getDataForXml() {
        if (!AccessControlUtil.getInstance(this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 128)) {
            return 103;
        }
        File file = new File(this.configuration.getTypes().get(this.type).getPath() + this.currentFolder, this.fileName);
        if (FileUtils.checkIfDirIsHidden(this.currentFolder, this.configuration)) {
            return 109;
        }
        if (!FileUtils.checkFileName(this.fileName) || FileUtils.checkIfFileIsHidden(this.fileName, this.configuration) || FileUtils.checkFileExtension(this.fileName, this.configuration.getTypes().get(this.type), this.configuration, false) == 1) {
            return 109;
        }
        try {
            if (!file.exists()) {
                return 117;
            }
            if (FileUtils.delete(file)) {
                File thumbFile = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder, this.fileName);
                FileUtils.delete(thumbFile);
                return 0;
            }
            return 104;
        }
        catch (SecurityException e) {
            if (this.configuration.isDebugMode()) {
                throw e;
            }
            return 104;
        }
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, new Object[0]);
        this.fileName = this.getParameter(request, "FileName");
    }
}

