/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.utils;

import com.ckfinder.connector.ServletContextFactory;
import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.utils.PathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final Map<String, String> UTF8_LOWER_ACCENTS = new HashMap<String, String>();
    private static final Map<String, String> UTF8_UPPER_ACCENTS = new HashMap<String, String>();
    private static final Map<String, String> encodingMap;

    public static Boolean checkIfFilesOrSubdirExistsInDir(File dir) {
        if (dir != null && dir.exists()) {
            for (String fileName : dir.list()) {
                File subFile = new File(dir.getAbsolutePath() + "/" + fileName);
                if (!subFile.exists() || !subFile.isDirectory()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> findChildrensList(File dir, boolean searchDirs) {
        ArrayList<String> files = new ArrayList<String>();
        for (String subFiles : dir.list()) {
            File file = new File(dir + "/" + subFiles);
            if ((!searchDirs || !file.isDirectory()) && (searchDirs || file.isDirectory())) continue;
            files.add(file.getName());
        }
        return files;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1 || fileName.lastIndexOf(".") == fileName.length() - 1) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1) {
            return null;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static void printFileContentToResponse(File file, OutputStream out) throws IOException {
        FileInputStream in = null;
        if (file.length() == 0L) {
            return;
        }
        try {
            in = new FileInputStream(file);
            byte[] buf = null;
            buf = file.length() < 1024L ? new byte[(int)file.length()] : new byte[1024];
            int numRead = 0;
            while ((numRead = in.read(buf)) != -1) {
                out.write(buf, 0, numRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean copyFromSourceToDestFile(File sourceFile, File destFile, boolean move, IConfiguration conf) throws IOException {
        int len;
        FileUtils.createPath(destFile, conf, true);
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
        if (move) {
            sourceFile.delete();
        }
        return true;
    }

    public static String getFullPath(String file) throws Exception {
        if (FileUtils.checkFileParentExists(PathUtils.escape(file))) {
            return file;
        }
        return ServletContextFactory.getServletContext().getRealPath(file);
    }

    private static boolean checkFileParentExists(String file) {
        String fileName = PathUtils.removeSlashFromEnd(file);
        File dir = new File(fileName.substring(0, fileName.lastIndexOf("/")));
        return dir.exists() && dir.isDirectory();
    }

    public static String parseLastModifDate(File file) {
        Date date = new Date(file.lastModified());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        return dateFormat.format(date);
    }

    public static boolean checkIfDirIsHidden(String dirName, IConfiguration conf) {
        if (dirName == null || dirName.equals("")) {
            return false;
        }
        String dir = PathUtils.removeSlashFromEnd(PathUtils.escape(dirName));
        Scanner sc = new Scanner(dir).useDelimiter("/");
        while (sc.hasNext()) {
            boolean check = Pattern.compile(FileUtils.getHiddenFileOrFolderRegex(conf.getHiddenFolders())).matcher(sc.next()).matches();
            if (!check) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfFileIsHidden(String fileName, IConfiguration conf) {
        return Pattern.compile(FileUtils.getHiddenFileOrFolderRegex(conf.getHiddenFiles())).matcher(fileName).matches();
    }

    private static String getHiddenFileOrFolderRegex(List<String> hiddenList) {
        StringBuilder sb = new StringBuilder("(");
        for (String item : hiddenList) {
            if (sb.length() > 3) {
                sb.append("|");
            }
            item = item.replaceAll("\\.", "\\\\.");
            item = item.replaceAll("\\*", ".+");
            item = item.replaceAll("\\?", ".");
            sb.append("(");
            sb.append(item);
            sb.append(")");
        }
        sb.append(")+");
        return sb.toString();
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            for (String item : file.list()) {
                File subFile = new File(file.getAbsolutePath() + File.separator + item);
                if (FileUtils.delete(subFile)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean checkFileName(String fileName) {
        return fileName != null && !fileName.equals("") && fileName.charAt(fileName.length() - 1) != '.' && !fileName.contains("..") && !FileUtils.checkFolderNamePattern(fileName);
    }

    private static boolean checkFolderNamePattern(String fileName) {
        Pattern pattern = Pattern.compile("\\p{Cntrl}|[/\\:\\*\\?\"\\<\\>\\|]");
        Matcher matcher = pattern.matcher(fileName);
        return matcher.find();
    }

    public static int checkFileExtension(String fileName, ResourceType type, IConfiguration conf, boolean renameReq) {
        if (type == null || fileName == null) {
            return 1;
        }
        if (fileName.indexOf(46) == -1) {
            return 0;
        }
        if (conf.ckeckDoubleFileExtensions()) {
            StringTokenizer tokens = new StringTokenizer(fileName, ".");
            StringTokenizer tokens2 = new StringTokenizer(fileName, ".");
            String currToken = "";
            while (tokens2.hasMoreTokens()) {
                currToken = tokens2.nextToken();
            }
            if (!FileUtils.checkSingleExtension(currToken, type)) {
                return 1;
            }
            if (renameReq) {
                String cfileName = tokens.nextToken();
                while (tokens.hasMoreTokens()) {
                    currToken = tokens.nextToken();
                    if (tokens.hasMoreElements()) {
                        cfileName = cfileName.concat(FileUtils.checkSingleExtension(currToken, type) ? "." : "_");
                        cfileName = cfileName.concat(currToken);
                        continue;
                    }
                    cfileName.concat(".".concat(currToken));
                }
                return 2;
            }
            return 0;
        }
        return FileUtils.checkSingleExtension(FileUtils.getFileExtension(fileName), type) ? 0 : 1;
    }

    private static boolean checkSingleExtension(String fileExt, ResourceType type) {
        Scanner scanner = new Scanner(type.getDeniedExtensions()).useDelimiter(",");
        while (scanner.hasNext()) {
            if (!scanner.next().equalsIgnoreCase(fileExt)) continue;
            return false;
        }
        Scanner scanner1 = new Scanner(type.getAllowedExtensions()).useDelimiter(",");
        while (scanner1.hasNext()) {
            if (!scanner1.next().equalsIgnoreCase(fileExt)) continue;
            return true;
        }
        return false;
    }

    public static String convertFromUriEncoding(String fileName, IConfiguration configuration) {
        try {
            return new String(fileName.getBytes(configuration.getUriEncoding()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return fileName;
        }
    }

    public static String convertToASCII(String fileName) {
        String newFileName = fileName;
        FileUtils.fillLowerAccents();
        FileUtils.fillUpperAccents();
        for (String s : UTF8_LOWER_ACCENTS.keySet()) {
            newFileName = newFileName.replace(s, UTF8_LOWER_ACCENTS.get(s));
        }
        for (String s : UTF8_UPPER_ACCENTS.keySet()) {
            newFileName = newFileName.replace(s, UTF8_UPPER_ACCENTS.get(s));
        }
        return newFileName;
    }

    public static void createPath(File file, IConfiguration conf, boolean isFile) throws IOException {
        String path = file.getAbsolutePath();
        StringTokenizer st = new StringTokenizer(path, File.separator);
        String checkPath = path.indexOf(File.separator) == 0 ? File.separator : "";
        checkPath = checkPath + (String)st.nextElement();
        while (st.hasMoreElements()) {
            String string = (String)st.nextElement();
            checkPath = checkPath.concat(File.separator + string);
            if (!string.equals(file.getName()) || !isFile) {
                File dir = new File(checkPath);
                if (dir.exists()) continue;
                FileUtils.mkdir(dir, conf);
                continue;
            }
            file.createNewFile();
        }
    }

    public static boolean mkdir(File dir, IConfiguration configuration) {
        return dir.mkdir();
    }

    public static boolean checkFileSize(ResourceType type, long fileSize) {
        return type.getMaxSize() == null || type.getMaxSize() > fileSize;
    }

    public static boolean checkIfFileIsHtmlFile(String file, IConfiguration configuration) {
        return configuration.getHTMLExtensions().contains(FileUtils.getFileExtension(file).toLowerCase());
    }

    public static boolean detectHtml(FileItem item) throws IOException {
        byte[] buff = new byte[1024];
        InputStream is = null;
        try {
            String[] tags;
            is = item.getInputStream();
            is.read(buff, 0, 1024);
            String content = new String(buff);
            content = content.toLowerCase().trim();
            if (Pattern.compile("<!DOCTYPE\\W+X?HTML.+", 42).matcher(content).matches()) {
                boolean bl = true;
                return bl;
            }
            for (String tag : tags = new String[]{"<body", "<head", "<html", "<img", "<pre", "<script", "<table", "<title"}) {
                if (content.indexOf(tag) == -1) continue;
                boolean bl = true;
                return bl;
            }
            if (Pattern.compile("type\\s*=\\s*['\"]?\\s*(?:\\w*/)?(?:ecma|java)", 42).matcher(content).find()) {
                boolean bl = true;
                return bl;
            }
            if (Pattern.compile("(?:href|src|data)\\s*=\\s*['\"]?\\s*(?:ecma|java)script:", 42).matcher(content).find()) {
                boolean bl = true;
                return bl;
            }
            if (Pattern.compile("url\\s*\\(\\s*['\"]?\\s*(?:ecma|java)script:", 42).matcher(content).find()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return false;
    }

    public static String renameFileWithBadExt(String fileName) {
        if (fileName == null) {
            return null;
        }
        return FileUtils.getFileNameWithoutExtension(fileName).replace('.', '_').concat("." + FileUtils.getFileExtension(fileName));
    }

    public static String encodeURIComponent(String fileName) throws UnsupportedEncodingException {
        String fileNameHelper = URLEncoder.encode(fileName, "utf-8");
        for (Map.Entry<String, String> entry : encodingMap.entrySet()) {
            fileNameHelper = fileNameHelper.replaceAll(entry.getKey(), entry.getValue());
        }
        return fileNameHelper;
    }

    public static boolean checkFolderName(String folderName, IConfiguration configuration) {
        return (!configuration.isDisallowUnsafeCharacters() || !folderName.contains(".") && !folderName.contains(";")) && !FileUtils.checkFolderNamePattern(folderName);
    }

    public static boolean checkFileName(String fileName, IConfiguration configuration) {
        return (!configuration.isDisallowUnsafeCharacters() || !fileName.contains(";")) && FileUtils.checkFileName(fileName);
    }

    public static String backupWithBackSlash(String fileName, String toReplace) {
        return fileName.replaceAll(toReplace, "\\\\" + toReplace);
    }

    private static void fillUpperAccents() {
        if (UTF8_UPPER_ACCENTS.size() == 0) {
            UTF8_UPPER_ACCENTS.put("\u00c0", "A");
            UTF8_UPPER_ACCENTS.put("\u00d4", "O");
            UTF8_UPPER_ACCENTS.put("\u010e", "D");
            UTF8_UPPER_ACCENTS.put("\u1e1e", "F");
            UTF8_UPPER_ACCENTS.put("\u00cb", "E");
            UTF8_UPPER_ACCENTS.put("\u0160", "S");
            UTF8_UPPER_ACCENTS.put("\u01a0", "O");
            UTF8_UPPER_ACCENTS.put("\u0102", "A");
            UTF8_UPPER_ACCENTS.put("\u0158", "R");
            UTF8_UPPER_ACCENTS.put("\u021a", "T");
            UTF8_UPPER_ACCENTS.put("\u0147", "N");
            UTF8_UPPER_ACCENTS.put("\u0100", "A");
            UTF8_UPPER_ACCENTS.put("\u0136", "K");
            UTF8_UPPER_ACCENTS.put("\u015c", "S");
            UTF8_UPPER_ACCENTS.put("\u1ef2", "Y");
            UTF8_UPPER_ACCENTS.put("\u0145", "N");
            UTF8_UPPER_ACCENTS.put("\u0139", "L");
            UTF8_UPPER_ACCENTS.put("\u0126", "H");
            UTF8_UPPER_ACCENTS.put("\u1e56", "P");
            UTF8_UPPER_ACCENTS.put("\u00d3", "O");
            UTF8_UPPER_ACCENTS.put("\u00da", "U");
            UTF8_UPPER_ACCENTS.put("\u011a", "E");
            UTF8_UPPER_ACCENTS.put("\u00c9", "E");
            UTF8_UPPER_ACCENTS.put("\u00c7", "C");
            UTF8_UPPER_ACCENTS.put("\u1e80", "W");
            UTF8_UPPER_ACCENTS.put("\u010a", "C");
            UTF8_UPPER_ACCENTS.put("\u00d5", "O");
            UTF8_UPPER_ACCENTS.put("\u1e60", "S");
            UTF8_UPPER_ACCENTS.put("\u00d8", "O");
            UTF8_UPPER_ACCENTS.put("\u0122", "G");
            UTF8_UPPER_ACCENTS.put("\u0166", "T");
            UTF8_UPPER_ACCENTS.put("\u0218", "S");
            UTF8_UPPER_ACCENTS.put("\u0116", "E");
            UTF8_UPPER_ACCENTS.put("\u0108", "C");
            UTF8_UPPER_ACCENTS.put("\u015a", "S");
            UTF8_UPPER_ACCENTS.put("\u00ce", "I");
            UTF8_UPPER_ACCENTS.put("\u0170", "U");
            UTF8_UPPER_ACCENTS.put("\u0106", "C");
            UTF8_UPPER_ACCENTS.put("\u0118", "E");
            UTF8_UPPER_ACCENTS.put("\u0174", "W");
            UTF8_UPPER_ACCENTS.put("\u1e6a", "T");
            UTF8_UPPER_ACCENTS.put("\u016a", "U");
            UTF8_UPPER_ACCENTS.put("\u010c", "C");
            UTF8_UPPER_ACCENTS.put("\u00d6", "Oe");
            UTF8_UPPER_ACCENTS.put("\u00c8", "E");
            UTF8_UPPER_ACCENTS.put("\u0176", "Y");
            UTF8_UPPER_ACCENTS.put("\u0104", "A");
            UTF8_UPPER_ACCENTS.put("\u0141", "L");
            UTF8_UPPER_ACCENTS.put("\u0172", "U");
            UTF8_UPPER_ACCENTS.put("\u016e", "U");
            UTF8_UPPER_ACCENTS.put("\u015e", "S");
            UTF8_UPPER_ACCENTS.put("\u011e", "G");
            UTF8_UPPER_ACCENTS.put("\u013b", "L");
            UTF8_UPPER_ACCENTS.put("\u0191", "F");
            UTF8_UPPER_ACCENTS.put("\u017d", "Z");
            UTF8_UPPER_ACCENTS.put("\u1e82", "W");
            UTF8_UPPER_ACCENTS.put("\u1e02", "B");
            UTF8_UPPER_ACCENTS.put("\u00c5", "A");
            UTF8_UPPER_ACCENTS.put("\u00cc", "I");
            UTF8_UPPER_ACCENTS.put("\u00cf", "I");
            UTF8_UPPER_ACCENTS.put("\u1e0a", "D");
            UTF8_UPPER_ACCENTS.put("\u0164", "T");
            UTF8_UPPER_ACCENTS.put("\u0156", "R");
            UTF8_UPPER_ACCENTS.put("\u00c4", "Ae");
            UTF8_UPPER_ACCENTS.put("\u00cd", "I");
            UTF8_UPPER_ACCENTS.put("\u0154", "R");
            UTF8_UPPER_ACCENTS.put("\u00ca", "E");
            UTF8_UPPER_ACCENTS.put("\u00dc", "Ue");
            UTF8_UPPER_ACCENTS.put("\u00d2", "O");
            UTF8_UPPER_ACCENTS.put("\u0112", "E");
            UTF8_UPPER_ACCENTS.put("\u00d1", "N");
            UTF8_UPPER_ACCENTS.put("\u0143", "N");
            UTF8_UPPER_ACCENTS.put("\u0124", "H");
            UTF8_UPPER_ACCENTS.put("\u011c", "G");
            UTF8_UPPER_ACCENTS.put("\u0110", "D");
            UTF8_UPPER_ACCENTS.put("\u0134", "J");
            UTF8_UPPER_ACCENTS.put("\u0178", "Y");
            UTF8_UPPER_ACCENTS.put("\u0168", "U");
            UTF8_UPPER_ACCENTS.put("\u016c", "U");
            UTF8_UPPER_ACCENTS.put("\u01af", "U");
            UTF8_UPPER_ACCENTS.put("\u0162", "T");
            UTF8_UPPER_ACCENTS.put("\u00dd", "Y");
            UTF8_UPPER_ACCENTS.put("\u0150", "O");
            UTF8_UPPER_ACCENTS.put("\u0178", "Y");
            UTF8_UPPER_ACCENTS.put("\u0168", "U");
            UTF8_UPPER_ACCENTS.put("\u016c", "U");
            UTF8_UPPER_ACCENTS.put("\u01af", "U");
            UTF8_UPPER_ACCENTS.put("\u0162", "T");
            UTF8_UPPER_ACCENTS.put("\u00dd", "Y");
            UTF8_UPPER_ACCENTS.put("\u0150", "O");
            UTF8_UPPER_ACCENTS.put("\u00c2", "A");
            UTF8_UPPER_ACCENTS.put("\u013d", "L");
            UTF8_UPPER_ACCENTS.put("\u1e84", "W");
            UTF8_UPPER_ACCENTS.put("\u017b", "Z");
            UTF8_UPPER_ACCENTS.put("\u012a", "I");
            UTF8_UPPER_ACCENTS.put("\u00c3", "A");
            UTF8_UPPER_ACCENTS.put("\u0120", "G");
            UTF8_UPPER_ACCENTS.put("\u1e40", "M");
            UTF8_UPPER_ACCENTS.put("\u014c", "O");
            UTF8_UPPER_ACCENTS.put("\u0128", "I");
            UTF8_UPPER_ACCENTS.put("\u00d9", "U");
            UTF8_UPPER_ACCENTS.put("\u012e", "I");
            UTF8_UPPER_ACCENTS.put("\u0179", "Z");
            UTF8_UPPER_ACCENTS.put("\u00c1", "A");
            UTF8_UPPER_ACCENTS.put("\u00db", "U");
            UTF8_UPPER_ACCENTS.put("\u00de", "Th");
            UTF8_UPPER_ACCENTS.put("\u00d0", "Dh");
            UTF8_UPPER_ACCENTS.put("\u00c6", "Ae");
            UTF8_UPPER_ACCENTS.put("\u0114", "E");
        }
    }

    private static void fillLowerAccents() {
        if (UTF8_LOWER_ACCENTS.size() == 0) {
            UTF8_LOWER_ACCENTS.put("\u00e0", "a");
            UTF8_LOWER_ACCENTS.put("\u00f4", "o");
            UTF8_LOWER_ACCENTS.put("\u010f", "d");
            UTF8_LOWER_ACCENTS.put("\u1e1f", "f");
            UTF8_LOWER_ACCENTS.put("\u00eb", "e");
            UTF8_LOWER_ACCENTS.put("\u0161", "s");
            UTF8_LOWER_ACCENTS.put("\u01a1", "o");
            UTF8_LOWER_ACCENTS.put("\u00df", "ss");
            UTF8_LOWER_ACCENTS.put("\u0103", "a");
            UTF8_LOWER_ACCENTS.put("\u0159", "r");
            UTF8_LOWER_ACCENTS.put("\u021b", "t");
            UTF8_LOWER_ACCENTS.put("\u0148", "n");
            UTF8_LOWER_ACCENTS.put("\u0101", "a");
            UTF8_LOWER_ACCENTS.put("\u0137", "k");
            UTF8_LOWER_ACCENTS.put("\u015d", "s");
            UTF8_LOWER_ACCENTS.put("\u1ef3", "y");
            UTF8_LOWER_ACCENTS.put("\u0146", "n");
            UTF8_LOWER_ACCENTS.put("\u013a", "l");
            UTF8_LOWER_ACCENTS.put("\u0127", "h");
            UTF8_LOWER_ACCENTS.put("\u1e57", "p");
            UTF8_LOWER_ACCENTS.put("\u00f3", "o");
            UTF8_LOWER_ACCENTS.put("\u00fa", "u");
            UTF8_LOWER_ACCENTS.put("\u011b", "e");
            UTF8_LOWER_ACCENTS.put("\u00e9", "e");
            UTF8_LOWER_ACCENTS.put("\u00e7", "c");
            UTF8_LOWER_ACCENTS.put("\u1e81", "w");
            UTF8_LOWER_ACCENTS.put("\u010b", "c");
            UTF8_LOWER_ACCENTS.put("\u00f5", "o");
            UTF8_LOWER_ACCENTS.put("\u1e61", "s");
            UTF8_LOWER_ACCENTS.put("\u00f8", "o");
            UTF8_LOWER_ACCENTS.put("\u0123", "g");
            UTF8_LOWER_ACCENTS.put("\u0167", "t");
            UTF8_LOWER_ACCENTS.put("\u0219", "s");
            UTF8_LOWER_ACCENTS.put("\u0117", "e");
            UTF8_LOWER_ACCENTS.put("\u0109", "c");
            UTF8_LOWER_ACCENTS.put("\u015b", "s");
            UTF8_LOWER_ACCENTS.put("\u00ee", "i");
            UTF8_LOWER_ACCENTS.put("\u0171", "u");
            UTF8_LOWER_ACCENTS.put("\u0107", "c");
            UTF8_LOWER_ACCENTS.put("\u0119", "e");
            UTF8_LOWER_ACCENTS.put("\u0175", "w");
            UTF8_LOWER_ACCENTS.put("\u1e6b", "t");
            UTF8_LOWER_ACCENTS.put("\u016b", "u");
            UTF8_LOWER_ACCENTS.put("\u010d", "c");
            UTF8_LOWER_ACCENTS.put("\u00f6", "oe");
            UTF8_LOWER_ACCENTS.put("\u00e8", "e");
            UTF8_LOWER_ACCENTS.put("\u0177", "y");
            UTF8_LOWER_ACCENTS.put("\u0105", "a");
            UTF8_LOWER_ACCENTS.put("\u0142", "l");
            UTF8_LOWER_ACCENTS.put("\u0173", "u");
            UTF8_LOWER_ACCENTS.put("\u016f", "u");
            UTF8_LOWER_ACCENTS.put("\u015f", "s");
            UTF8_LOWER_ACCENTS.put("\u011f", "g");
            UTF8_LOWER_ACCENTS.put("\u013c", "l");
            UTF8_LOWER_ACCENTS.put("\u0192", "f");
            UTF8_LOWER_ACCENTS.put("\u017e", "z");
            UTF8_LOWER_ACCENTS.put("\u1e83", "w");
            UTF8_LOWER_ACCENTS.put("\u1e03", "b");
            UTF8_LOWER_ACCENTS.put("\u00e5", "a");
            UTF8_LOWER_ACCENTS.put("\u00ec", "i");
            UTF8_LOWER_ACCENTS.put("\u00ef", "i");
            UTF8_LOWER_ACCENTS.put("\u1e0b", "d");
            UTF8_LOWER_ACCENTS.put("\u0165", "t");
            UTF8_LOWER_ACCENTS.put("\u0157", "r");
            UTF8_LOWER_ACCENTS.put("\u00e4", "ae");
            UTF8_LOWER_ACCENTS.put("\u00ed", "i");
            UTF8_LOWER_ACCENTS.put("\u0155", "r");
            UTF8_LOWER_ACCENTS.put("\u00ea", "e");
            UTF8_LOWER_ACCENTS.put("\u00fc", "ue");
            UTF8_LOWER_ACCENTS.put("\u00f2", "o");
            UTF8_LOWER_ACCENTS.put("\u0113", "e");
            UTF8_LOWER_ACCENTS.put("\u00f1", "n");
            UTF8_LOWER_ACCENTS.put("\u0144", "n");
            UTF8_LOWER_ACCENTS.put("\u0125", "h");
            UTF8_LOWER_ACCENTS.put("\u011d", "g");
            UTF8_LOWER_ACCENTS.put("\u0111", "d");
            UTF8_LOWER_ACCENTS.put("\u0135", "j");
            UTF8_LOWER_ACCENTS.put("\u00ff", "y");
            UTF8_LOWER_ACCENTS.put("\u0169", "u");
            UTF8_LOWER_ACCENTS.put("\u016d", "u");
            UTF8_LOWER_ACCENTS.put("\u01b0", "u");
            UTF8_LOWER_ACCENTS.put("\u0163", "t");
            UTF8_LOWER_ACCENTS.put("\u00fd", "y");
            UTF8_LOWER_ACCENTS.put("\u0151", "o");
            UTF8_LOWER_ACCENTS.put("\u00e2", "a");
            UTF8_LOWER_ACCENTS.put("\u013e", "l");
            UTF8_LOWER_ACCENTS.put("\u1e85", "w");
            UTF8_LOWER_ACCENTS.put("\u017c", "z");
            UTF8_LOWER_ACCENTS.put("\u012b", "i");
            UTF8_LOWER_ACCENTS.put("\u00e3", "a");
            UTF8_LOWER_ACCENTS.put("\u0121", "g");
            UTF8_LOWER_ACCENTS.put("\u1e41", "m");
            UTF8_LOWER_ACCENTS.put("\u014d", "o");
            UTF8_LOWER_ACCENTS.put("\u0129", "i");
            UTF8_LOWER_ACCENTS.put("\u00f9", "u");
            UTF8_LOWER_ACCENTS.put("\u012f", "i");
            UTF8_LOWER_ACCENTS.put("\u017a", "z");
            UTF8_LOWER_ACCENTS.put("\u00e1", "a");
            UTF8_LOWER_ACCENTS.put("\u00fb", "u");
            UTF8_LOWER_ACCENTS.put("\u00fe", "th");
            UTF8_LOWER_ACCENTS.put("\u00f0", "dh");
            UTF8_LOWER_ACCENTS.put("\u00e6", "ae");
            UTF8_LOWER_ACCENTS.put("\u00b5", "u");
            UTF8_LOWER_ACCENTS.put("\u0115", "e");
        }
    }

    static {
        HashMap<String, String> mapHelper = new HashMap<String, String>();
        mapHelper.put("%21", "!");
        mapHelper.put("%27", "'");
        mapHelper.put("%28", "(");
        mapHelper.put("%29", ")");
        mapHelper.put("%7E", "~");
        mapHelper.put("[+]", "%20");
        encodingMap = Collections.unmodifiableMap(mapHelper);
    }
}

