package com.jeecms.auxiliary.manager;

import java.util.Set;

import com.jeecms.auxiliary.entity.VoteItem;
import com.jeecms.auxiliary.entity.VoteTopic;
import com.jeecms.auxiliary.exception.VoteException;
import com.jeecms.common.page.Pagination;
import com.jeecms.core.JeeCoreManager;

/**
 * ͶƱmanager
 * 
 * @author liufang
 * 
 */
public interface VoteTopicMng extends JeeCoreManager<VoteTopic> {
	/**
	 * ͶƱб
	 * 
	 * @param webId
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	public Pagination getPage(Long webId, int pageNo, int pageSize);

	/**
	 * ͶƱ
	 * 
	 * @param bean
	 *            
	 * @param items
	 *            ͶƱ
	 * @return
	 */
	public VoteTopic updateTopic(VoteTopic bean, Set<VoteItem> items);

	/**
	 * µͶƱ
	 * 
	 * @param webId
	 * @return
	 */
	public VoteTopic getCurrentTopic(Long webId);

	/**
	 * ͶƱ
	 * 
	 * @param topicId
	 *            ͶƱID
	 * @param voteItems
	 *            ͶƱѡID
	 * @param member
	 *            ͶƱԱ
	 * @param ip
	 *            ͶƱIP
	 * @param cookie
	 *            ͶƱcookie
	 * @return result of VotoTopic
	 * 
	 * @throws VoteException
	 */
	public VoteTopic vote(Long topicId, Long[] voteItems, Long memberId,
			String ip, String cookie) throws VoteException;
}