package com.jeecms.cms;

import org.springframework.beans.factory.annotation.Autowired;

import com.jeecms.cms.entity.CmsConfig;
import com.jeecms.cms.entity.CmsMember;
import com.jeecms.cms.manager.CmsConfigMng;
import com.jeecms.cms.manager.CmsMemberMng;
import com.jeecms.core.IndeBaseAction;

/**
 * JEECMSҳactionȡ
 * <p>
 * CmsConfigú͵ǰϵͳģ巽
 * </p>
 * 
 * @author liufang
 * 
 */
public abstract class CmsIndeAction extends IndeBaseAction {
	@Override
	protected String getSolution() {
		return getConfig().getSolution(getSysType());
	}

	@Override
	protected String getSysType() {
		return Constants.COMMON_SYS;
	}

	/**
	 * CMSö
	 * 
	 * @return
	 */
	public CmsConfig getConfig() {
		return cmsConfigMng.findById(getWebId());
	}

	/**
	 * CMSԱ
	 * 
	 * @return
	 */
	public CmsMember getCmsMember() {
		Long memberId = getMemberId();
		if (memberId == null) {
			return null;
		} else {
			CmsMember cmsMember = cmsMemberMng.findById(memberId);
			if (cmsMember != null && cmsMember.getMemberDisabled()) {
				throw new RuntimeException("ʺѾã");
			}
			return cmsMemberMng.findById(memberId);
		}
	}

	/**
	 * Ϣʾҳ棬޷ذťѾ¼ûȨ޵ʾ
	 * 
	 * @return
	 */
	protected String showMessage() {
		return handleResult(SHOW_MESSAGE, Constants.MEMBER_SYS);
	}

	/**
	 * ʾϢзذťԶת֤ʾ
	 * 
	 * @return
	 */
	protected String showError() {
		return handleResult(SHOW_ERROR, Constants.MEMBER_SYS);
	}

	/**
	 * ʾɹϢзذť2Զת޸ɹҪṩӵַ
	 * 
	 * @return
	 */
	protected String showSuccess() {
		return handleResult(SHOW_SUCCESS, Constants.MEMBER_SYS);
	}

	/**
	 * ض򵽵¼ҳ
	 * 
	 * @return
	 */
	protected String redirectLogin() {
		rootWebUrl = getWeb().getRootWeb().getWebUrl();
		return Constants.CMS_MEMBER_LOGIN;
	}

	@Autowired
	protected CmsConfigMng cmsConfigMng;

	@Autowired
	protected CmsMemberMng cmsMemberMng;
}
