package com.jeecms.cms;

import org.springframework.beans.factory.annotation.Autowired;

import com.jeecms.cms.entity.CmsAdmin;
import com.jeecms.cms.entity.CmsConfig;
import com.jeecms.cms.entity.CmsMember;
import com.jeecms.cms.manager.CmsAdminMng;
import com.jeecms.cms.manager.CmsConfigMng;
import com.jeecms.cms.manager.CmsMemberMng;
import com.jeecms.core.JeeCoreAction;
import com.jeecms.core.entity.Admin;
import com.jeecms.core.exception.AdminNotFoundException;

/**
 * jeecmsactionȡ
 * <p>
 * cmsԱ
 * </p>
 * 
 * @author liufang
 * 
 */
@SuppressWarnings("serial")
public abstract class CmsSysAction extends JeeCoreAction {
	/**
	 * JEECMSԱID
	 * <p>
	 * ׳쳣
	 * </p>
	 * 
	 * @return
	 */
	public Long getCmsAdminId() throws AdminNotFoundException {
		// ʿƣadminIdȷ
		Long adminId = (Long) contextPvd.getSessionAttr(Admin.ADMIN_KEY);
		if (adminId == null) {
			throw new AdminNotFoundException("JEECMSϵͳĹԱ");
		} else {
			return adminId;
		}
	}

	/**
	 * JEECMSԱ
	 * 
	 * @return
	 */
	public CmsAdmin getCmsAdmin() throws AdminNotFoundException {
		return cmsAdminMng.findById(getCmsAdminId());
	}

	/**
	 * JEECMSԱ
	 * 
	 * @return
	 */
	public CmsMember getCmsMember() {
		Long memberId = getMemberId();
		if (memberId == null) {
			return null;
		} else {
			return cmsMemberMng.findById(memberId);
		}
	}

	/**
	 * JEECMSԱID
	 * 
	 * @return
	 */
	public Long getCmsMemberId() {
		CmsMember cmsMember = getCmsMember();
		if (cmsMember == null) {
			return null;
		} else {
			return cmsMember.getId();
		}
	}

	/**
	 * JEECMSö
	 * 
	 * @return
	 */
	public CmsConfig getConfig() {
		return cmsConfigMng.findById(getWebId());
	}

	@Autowired
	protected CmsAdminMng cmsAdminMng;
	@Autowired
	protected CmsConfigMng cmsConfigMng;
	@Autowired
	protected CmsMemberMng cmsMemberMng;
}
