package com.jeecms.common.hibernate3;

import java.io.Serializable;
import java.util.List;

import com.jeecms.common.page.Pagination;

public interface BaseDao<T extends Serializable> {
	/**
	 * ͨIDҶ
	 * 
	 * @param id
	 *            ¼ID
	 * @param lock
	 *            Ƿ
	 * @return ʵ
	 */
	public T load(Serializable id, boolean lock);

	public T get(Serializable id);

	/**
	 * ͨIDҶ,
	 * 
	 * @param id
	 *            ¼ID
	 * @return ʵ
	 */
	public T load(Serializable id);

	/**
	 * ж
	 * 
	 * @return б
	 */
	public List<T> findAll();

	public List<T> findAll(OrderBy... orders);

	public Pagination findAll(int pageNo, int pageSize, OrderBy... orders);

	/**
	 * ͨʾҶб
	 * 
	 * @param eg
	 *            ʾ
	 * @param anyWhere
	 *            ǷģѯĬfalse
	 * @param conds
	 *            is nullֶΡֱΪOrderByString
	 * @param exclude
	 *            Ҫų
	 * @return б
	 */
	public List<T> findByEgList(T eg, boolean anyWhere, Condition[] conds,
			String... exclude);

	public List<T> findByEgList(T eg, boolean anyWhere, Condition[] conds,
			int firstResult, int maxResult, String... exclude);

	public Pagination findByEg(T exampleInstance, boolean anyWhere,
			Condition[] conds, int pageNo, int pageSize, String... exclude);

	/**
	 * ԲҶб.
	 */
	public List<T> findByProperty(String property, Object value);

	/**
	 * ԲΨһ.
	 */
	public T findUniqueByProperty(String property, Object value);

	/**
	 * ԲҶ
	 * 
	 * @param property
	 * @param value
	 * @return
	 */
	public int countByProperty(String property, Object value);

	/**
	 * Updater¶
	 * 
	 * @param updater
	 * @return ־û
	 */
	public Object updateByUpdater(Updater updater);

	public Object updateDefault(Object entity);

	/**
	 * 
	 * 
	 * @param entity
	 *            ʵ
	 * @return ʵ
	 */
	public T save(T entity);

	/**
	 * ¶
	 * 
	 * @param entity
	 *            ʵ
	 * @return ʵ
	 */
	public Object update(Object entity);

	/**
	 * ¶
	 * 
	 * @param entity
	 *            ʵ
	 * @return ʵ
	 */
	public Object saveOrUpdate(Object entity);

	/**
	 * ¶󿽱
	 * 
	 * @param entity
	 * @return Ѹµĳ־û
	 */
	public Object merge(Object entity);

	/**
	 * ɾ
	 * 
	 * @param entity
	 *            ʵ
	 */
	public void delete(Object entity);

	/**
	 * IDɾ¼
	 * 
	 * @param id
	 *            ¼ID
	 */
	public T deleteById(Serializable id);

	/**
	 * ˢ¶
	 * 
	 * @param entity
	 */
	public void refresh(Object entity);

	/**
	 * ʵClass
	 * 
	 * @return
	 */
	public Class<T> getPersistentClass();

	/**
	 * ʵĶ
	 * 
	 * @return
	 */
	public T createNewEntiey();
}
