package com.jeecms.common.util;

import org.apache.commons.lang.StringUtils;

/**
 * <PRE>
 * ṩַȫ-&gt;ǣ-&gt;ȫת
 * </PRE>
 */
public class BCConvert {

	/**
	 * ASCIIпɼַ!ʼƫλֵΪ33(Decimal)
	 */
	static final char DBC_CHAR_START = 33; // !

	/**
	 * ASCIIпɼַ~ƫλֵΪ126(Decimal)
	 */
	static final char DBC_CHAR_END = 126; // ~

	/**
	 * ȫǶӦASCIIĿɼַӣʼƫֵΪ65281
	 */
	static final char SBC_CHAR_START = 65281; // ȫǣ

	/**
	 * ȫǶӦASCIIĿɼַƫֵΪ65374
	 */
	static final char SBC_CHAR_END = 65374; // ȫǡ

	/**
	 * ASCIIгոĿɼַӦȫַƫ
	 */
	static final int CONVERT_STEP = 65248; // ȫǰת

	/**
	 * ȫǿոֵûASCIIƫƣ뵥
	 */
	static final char SBC_SPACE = 12288; // ȫǿո 12288

	/**
	 * ǿոֵASCIIΪ32(Decimal)
	 */
	static final char DBC_SPACE = ' '; // ǿո

	/**
	 * <PRE>
	 * ַ->ȫַת  
	 * ֻո!&tilde;ַ֮
	 * </PRE>
	 */
	private static String bj2qj(String src) {
		if (src == null) {
			return src;
		}
		StringBuilder buf = new StringBuilder(src.length());
		char[] ca = src.toCharArray();
		for (int i = 0; i < ca.length; i++) {
			if (ca[i] == DBC_SPACE) { // ǰǿոֱȫǿո
				buf.append(SBC_SPACE);
			} else if ((ca[i] >= DBC_CHAR_START) && (ca[i] <= DBC_CHAR_END)) { // ַ!~֮Ŀɼַ
				buf.append((char) (ca[i] + CONVERT_STEP));
			} else { // ԿոԼasciiɼַַ֮κδ
				buf.append(ca[i]);
			}
		}
		return buf.toString();
	}

	/**
	 * <PRE>
	 * ȫַ->ַת  
	 * ֻȫǵĿոȫǣȫǡַ֮
	 * </PRE>
	 */
	public static String qj2bj(String src) {
		if (src == null) {
			return src;
		}
		StringBuilder buf = new StringBuilder(src.length());
		char[] ca = src.toCharArray();
		for (int i = 0; i < src.length(); i++) {
			if (ca[i] >= SBC_CHAR_START && ca[i] <= SBC_CHAR_END) { // λȫǣȫǡ
				buf.append((char) (ca[i] - CONVERT_STEP));
			} else if (ca[i] == SBC_SPACE) { // ȫǿո
				buf.append(DBC_SPACE);
			} else { // ȫǿոȫǣȫǡַ
				buf.append(ca[i]);
			}
		}
		return buf.toString();
	}

	public static void main(String[] args) {
		System.out.println(StringUtils.trimToEmpty(" a,b ,c "));
		String s = "nihao롡塡";
		System.out.println(BCConvert.qj2bj(s));
	}
}