package com.jeecms.core.manager;

import java.util.List;

import javax.servlet.http.HttpSession;

import com.jeecms.common.page.Pagination;
import com.jeecms.core.JeeCoreManager;
import com.jeecms.core.entity.Admin;
import com.jeecms.core.entity.User;
import com.jeecms.core.exception.UserRegisterException;

/**
 * Աmanagerӿ
 * 
 * @author liufang
 * 
 */
public interface AdminMng extends JeeCoreManager<Admin> {
	/**
	 * ͨͳһûIDùԱ
	 * 
	 * @param webId
	 * @param userId
	 * @return
	 */
	public Admin getByUserId(Long webId, Long userId);

	/**
	 * ͨ¼ҹԱ
	 * 
	 * @param webId
	 * @param loginName
	 * @return
	 */
	public Admin getByLoginName(Long webId, String loginName);

	/**
	 * ĳվԱ
	 * 
	 * @param webId
	 * @return
	 */
	public Pagination getAll(Long webId, int page, int countPerPage);

	/**
	 * ͳһûIDùԱб
	 * 
	 * @param unitedId
	 * @return
	 */
	public List<Admin> getListByUserId(Long userId);

	/**
	 * õ¼״̬ĹԱ
	 * 
	 * @param webId
	 * @param adminId
	 * @param userId
	 * @return
	 */
	public Admin getLoginAdmin(Long webId, Long adminId, Long userId);

	/**
	 * õ¼״̬ĹԱ
	 * 
	 * @param webId
	 * @param adminId
	 * @param userId
	 * @return
	 */
	public Admin getLoginAdmin(String domain, Long adminId, Long userId,
			HttpSession session);

	/**
	 * עԱ
	 * 
	 * @param webId
	 * @param user
	 * @param admin
	 * @param isExist
	 * @return
	 * @throws UserRegisterException
	 */
	public Admin register(Long webId, User user, Admin admin, boolean isExist)
			throws UserRegisterException;
}