package com.jeecms.core.manager;

import java.util.List;

import com.jeecms.common.page.Pagination;
import com.jeecms.core.JeeCoreManager;
import com.jeecms.core.entity.Member;
import com.jeecms.core.entity.User;
import com.jeecms.core.exception.UserRegisterException;

public interface MemberMng extends JeeCoreManager<Member> {
	public Pagination getAll(Long webId, int page, int countPerPage);

	public List<Member> getAll(Long webId);

	/**
	 * ͨ¼ȡMember
	 * 
	 * @param webId
	 *            վID
	 * @param loginName
	 *            ¼
	 * @return
	 */
	public Member getByLoginName(Long webId, String loginName);

	/**
	 * ͨûIDȡMember
	 * 
	 * @param webId
	 *            վID
	 * @param userId
	 *            ûID
	 * @return
	 */
	public Member getByUserId(Long webId, Long userId);

	/**
	 * עû
	 * 
	 * @param webId
	 * @param user
	 * @param member
	 * @param isExist
	 * @return
	 * @throws UserRegisterException
	 */
	public Member register(Long webId, User user, Member member, boolean isExist)
			throws UserRegisterException;

	/**
	 * עû
	 * 
	 * @param webId
	 * @param user
	 * @param isExist
	 * @throws UserRegisteredException
	 *             ûע쳣
	 */
	public Member register(Long webId, User user, boolean isExist)
			throws UserRegisterException;

	/**
	 * õ¼ĻԱ
	 * <p>
	 * Ա¼ˣɴͨuserIdûԱ
	 * </p>
	 * 
	 * @param webId
	 * @param userId
	 * @return
	 */
	public Member getLoginMember(Long webId, Long userId, Long memberId);
}