package com.jeecms.core.manager;

import javax.naming.AuthenticationException;

import com.jeecms.core.JeeCoreManager;
import com.jeecms.core.entity.User;
import com.jeecms.core.exception.UserRegisterException;

public interface UserMng extends JeeCoreManager<User> {
	/**
	 * ͨ¼ûʹû档
	 * 
	 * @param loginName
	 * @return ûûڷnull
	 */
	public User getByLoginName(String loginName);

	/**
	 * ¼ǷѾע
	 * 
	 * @param loginName
	 * @return trueûбע᣻falseѾע
	 */
	public boolean checkLoginName(String loginName);

	/**
	 * ͨemailû
	 * 
	 * @param email
	 * @return
	 */
	public User getUserByEmail(String email);

	/**
	 * emailǷѾʹ
	 * 
	 * @param email
	 * @return trueûбʹãfalseѾʹ
	 */
	public boolean checkEmail(String email);

	/**
	 * ֤û֤ʧ׳쳣
	 * 
	 * @param loginName
	 * @param password
	 * @return
	 */
	public User authenticate(String loginName, String password);

	/**
	 * ¼¼ɹ󱣴session
	 * 
	 * @param loginName
	 * @param password
	 * @return
	 * @throws AuthenticationException
	 */
	public User login(String loginName, String password);

	/**
	 * 
	 * 
	 * @param oldPwd
	 *            ԭ
	 * @param newPwd
	 *            룬Ϊnull޸
	 * @param email
	 *            䣬Ϊnull޸
	 * @return Ƿ³ɹ
	 */
	public boolean updatePwdEmail(User user, String oldPwd, String newPwd,
			String email);

	/**
	 * 
	 * 
	 * @param id
	 * @param newPwd
	 */
	public void updatePassword(Long id, String newPwd);

	/**
	 * µ¼Ϣ
	 * 
	 * @param user
	 */
	public void updateLoginInfo(User user);

	/**
	 * עû
	 * 
	 * ѴûṩloginNameɻøû ûṩloginnameemailpassword
	 * 
	 * @param user
	 * @param isExist
	 *            ûǷ
	 * @return
	 * @throws UserRegisterException
	 */
	public User register(User user, boolean isExist)
			throws UserRegisterException;
}