package com.jeecms.core.manager.impl;

import java.util.List;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeecms.common.hibernate3.OrderBy;
import com.jeecms.common.page.Pagination;
import com.jeecms.core.JeeCoreManagerImpl;
import com.jeecms.core.dao.WebsiteDao;
import com.jeecms.core.entity.Website;
import com.jeecms.core.manager.WebsiteMng;

/**
 * վʵ֡
 * <p>
 * ϵͳʱվϢʹhibernate棬Ӧû汣domainidĹϵ
 * </p>
 * <ul>
 * <li>޸websiteǼǷ޸ջ档</li>
 * <li>վʱ뻺</li>
 * </ul>
 * 
 * @author liufang
 * 
 */
@Service
@Transactional
public class WebsiteMngImpl extends JeeCoreManagerImpl<Website> implements
		WebsiteMng {
	public List<Website> getAllWebsite() {
		return findAll();
	}

	public Pagination getAllWebsite(int page, int countPerPage) {
		return findAll(page, countPerPage, new OrderBy[] { OrderBy.desc("id") });
	}

	public List<Website> getListForUpdate(Long webId) {
		return getDao().getListForUpdate(webId);
	}

	public Website removeWebsite(Long id) {
		Website website = getDao().load(id);
		getDao().delete(website);
		websiteDomainCache.remove(website.getDomain());
		return website;
	}

	public Website getWebsite(Long id) {
		Website w = null;
		w = getDao().load(id);
		return w;
	}

	public Website getWebsite(String domainName) {
		Element e = websiteDomainCache.get(domainName);
		if (e != null) {
			Object websiteId = e.getObjectValue();
			return getWebsite((Long) websiteId);
		} else {
			log.warn("get website from cache, domain not exist:{}", domainName);
			return null;
		}
	}

	public Website save(Website website) {
		getDao().save(website);
		return website;
	}

	public Website getByAlias(String domainName) {
		Element e = websiteAliasCache.get(domainName);
		if (e != null) {
			Object webId = e.getObjectValue();
			return getWebsite((Long) webId);
		} else {
			log.warn("get website by alias from cache, domain not exist:{}",
					domainName);
			return null;
		}
	}

	public List<Website> getListByUserId(Long unitedId) {
		return getDao().getListByUserId(unitedId);
	}

	public void loadAllWebsiteToCache() {
		websiteDomainCache.removeAll();
		websiteAliasCache.removeAll();
		List<Website> ws = getDao().findAll();
		for (Website w : ws) {
			websiteDomainCache.put(new Element(w.getDomain(), w.getId()));
			String[] alias = w.getAlias();
			if (alias != null) {
				for (String a : alias) {
					websiteAliasCache.put(new Element(a, w.getId()));
				}
			}
		}
	}

	public Website updateWebsite(Website website) {
		Website before = getWebsite(website.getId());
		String beforeDomain = before.getDomain();
		String beforeAlias = before.getDomainAlias();
		String[] beforeAliasArr = before.getAlias();
		Website after = (Website) getDao().updateDefault(website);
		if (!StringUtils.equals(beforeDomain, after.getDomain())) {
			websiteDomainCache.remove(beforeDomain);
			websiteDomainCache
					.put(new Element(after.getDomain(), after.getId()));
		}
		if (!StringUtils.equals(beforeAlias, after.getDomainAlias())) {
			if (beforeAliasArr != null) {
				for (String a : beforeAliasArr) {
					websiteAliasCache.remove(a);
				}
			}
			String[] afterAliasArr = after.getAlias();
			if (afterAliasArr != null) {
				for (String a : afterAliasArr) {
					websiteAliasCache.put(new Element(a, after.getId()));
				}
			}
		}
		return after;
	}

	public boolean checkDomain(String domain) {
		return getDao().countByProperty("domain", domain) <= 0;
	}

	public boolean checkResPath(String resPath) {
		return getDao().countByProperty("resPath", resPath) <= 0;
	}

	private Ehcache websiteDomainCache;
	private Ehcache websiteAliasCache;

	@Autowired
	public void setWebsiteDomainCache(
			@Qualifier("websiteDomain") Ehcache websiteDomainCache) {
		this.websiteDomainCache = websiteDomainCache;
	}

	@Autowired
	public void setWebsiteAliasCache(
			@Qualifier("websiteAlias") Ehcache websiteAliasCache) {
		this.websiteAliasCache = websiteAliasCache;
	}

	@Autowired
	public void setWebsiteDao(WebsiteDao dao) {
		super.setDao(dao);
	}

	public WebsiteDao getDao() {
		return (WebsiteDao) super.getDao();
	}
}
