package com.jeecms.core.util;

import static com.jeecms.core.Constants.SPT;

import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jeecms.common.util.StrUtils;

/**
 * ϴࡣ
 * 
 * ϴ֮ǰϴ󱣴sessionУ֮༭ϴ󽫸ϴϴļ
 * 
 * ༭ĸ·rootPathģʱҪָ·ԱϴͼƬ
 * 
 * ϴ·
 * 
 * @author liufang
 * 
 */
public class UploadRule implements java.io.Serializable {
	private static final long serialVersionUID = 1L;
	private static final Logger log = LoggerFactory.getLogger(UploadRule.class);
	/**
	 * sessionеkey
	 */
	public static final String KEY = "_upload_rule";

	/**
	 * 
	 * 
	 * @param rootPath
	 *            ·ĸ·ϴʱҪټ·
	 * @param pathPrefix
	 *            ·ǰ׺
	 * @param isGenName
	 *            Ƿ񴴽ļ
	 * @param hasType
	 *            ǷļģʱҪҪ
	 * @param needClear
	 *            ǷҪδʹõϴļ
	 */
	public UploadRule(String rootPath, String pathPrefix, boolean isGenName,
			boolean hasType, boolean needClear) {
		this.rootPath = rootPath;
		this.pathPrefix = pathPrefix;
		this.isGenName = isGenName;
		this.hasType = hasType;
		this.needClear = needClear;
	}

	/**
	 * 
	 * 
	 * @param rootPath
	 *            ·ĸ·ϴʱҪټ·
	 * @param isGenName
	 *            Ƿ񴴽ļ
	 * @param hasType
	 *            ǷļģʱҪҪ
	 */

	public UploadRule(String rootPath, String pathPrefix, boolean isGenName,
			boolean hasType) {
		this(rootPath, pathPrefix, isGenName, hasType, true);
	}

	/**
	 * 
	 * 
	 * @param rootPath
	 *            ·ĸ·ϴʱҪټ·
	 * @param isGenName
	 *            Ƿ񴴽ļ
	 */

	public UploadRule(String rootPath, String pathPrefix, boolean isGenName) {
		this(rootPath, pathPrefix, isGenName, true, true);
	}

	/**
	 * 
	 * 
	 * @param rootPath
	 *            ·ĸ·ϴʱҪټ·
	 */

	public UploadRule(String rootPath, String pathPrefix) {
		this(rootPath, pathPrefix, true, true, true);
	}

	/**
	 * ļȫ
	 * 
	 * Ŀ¼ǰ׺/+/+/ļ.suffix
	 * 
	 * @return
	 */
	public String getPathName(String fileName, String suffix, String type) {
		StringBuilder sb = new StringBuilder(getPathPrefix()).append(type)
				.append(genFilePath());
		if (isGenName) {
			sb.append(genFileName());
		} else {
			sb.append(fileName);
		}
		sb.append('.').append(suffix);
		return sb.toString();
	}

	/**
	 * ǰ·/2008_2/5_20//_/_/
	 * 
	 * @return
	 */
	public static String genFilePath() {
		StringBuilder sb = new StringBuilder();
		Calendar cal = Calendar.getInstance();
		sb.append(SPT).append(cal.get(Calendar.YEAR)).append('_').append(
				cal.get((Calendar.MONTH)) / 3 + 1).append(SPT).append(
				cal.get(Calendar.MONTH) + 1).append('_').append(
				cal.get(Calendar.DAY_OF_MONTH)).append(SPT);
		return sb.toString();
	}

	/**
	 * ļ
	 * 
	 * 4λϵǰʱ
	 * 
	 * @return
	 */
	public static String genFileName() {
		String name = StrUtils.longToN36(System.currentTimeMillis());
		return RandomStringUtils.random(4, StrUtils.N36_CHARS) + name;
	}

	/**
	 * ÿͼƬĺ׺ûָʹĬϵĺ׺ϡ
	 * 
	 * @return
	 */
	public Set<String> getAcceptImg() {
		if (acceptImg == null) {
			acceptImg = new HashSet<String>();
			for (String s : DEF_IMG_ACCEPT) {
				acceptImg.add(s);
			}
		}
		return acceptImg;
	}

	public void addUploadFile(String origName, String fileName,
			String realPath, long size) {
		if (uploadFiles == null) {
			uploadFiles = new HashMap<String, UploadFile>();
		}
		uploadFiles.put(fileName, new UploadFile(origName, fileName, realPath,
				size));
	}

	public void removeUploadFile(String fileName) {
		if (uploadFiles != null) {
			uploadFiles.remove(fileName);
		}
	}

	public Map<String, UploadFile> getUploadFiles() {
		return uploadFiles;
	}

	public void clearUploadFile() {
		if (uploadFiles != null && needClear) {
			for (UploadFile uf : uploadFiles.values()) {
				File file = new File(uf.getRealPath());
				if (file.delete()) {
					log.debug("ɾδʹõļ{}", file.getName());
				} else {
					log.warn("ɾļʧܣ{}", file.getName());
				}
			}
			uploadFiles.clear();
		}
	}

	/**
	 * ѾϴͼƬ
	 */
	private Map<String, UploadFile> uploadFiles;

	/**
	 * ϴļ׺
	 */
	private Set<String> acceptImg;
	/**
	 * ༭ĸ·Ҳϴĸ·
	 */
	private String rootPath;

	private String pathPrefix;
	/**
	 * Ƿļ
	 */
	private boolean isGenName = true;
	/**
	 * Ƿļͣڱ༭ʱʹã
	 */
	private boolean hasType = true;
	/**
	 * ǷҪ
	 */
	private boolean needClear = true;
	/**
	 * Ƿļ
	 */
	private boolean allowFileBrowsing = true;
	/**
	 * Ƿϴļ
	 */
	private boolean allowUpload = true;
	/**
	 * ϴĴС0ϴ-1
	 */
	private int allowSize = -1;
	/**
	 * ϴС
	 */
	private int uploadSize = 0;
	/**
	 * ĬϵĿϴļ׺
	 */
	public static final String[] DEF_IMG_ACCEPT = { "jpg", "gif", "jpeg",
			"png", "bmp", };

	public static void main(String[] args) {
		UploadRule rule = new UploadRule("", "", true);
		System.out.println(rule.getPathName("", "jpg", "img"));
	}

	public boolean isGenName() {
		return isGenName;
	}

	public void setGenName(boolean isGenName) {
		this.isGenName = isGenName;
	}

	public void setAcceptImg(Set<String> acceptImg) {
		this.acceptImg = acceptImg;
	}

	public String getRootPath() {
		return rootPath;
	}

	public void setRootPath(String rootPath) {
		this.rootPath = rootPath;
	}

	public boolean isHasType() {
		return hasType;
	}

	public void setHasType(boolean hasType) {
		this.hasType = hasType;
	}

	public boolean isNeedClear() {
		return needClear;
	}

	public void setNeedClear(boolean needClear) {
		this.needClear = needClear;
	}

	public static class UploadFile implements java.io.Serializable {
		private static final long serialVersionUID = 1L;

		public UploadFile() {
		}

		public UploadFile(String origName, String fileName, String realPath,
				long size) {
			this.origName = origName;
			this.fileName = fileName;
			this.realPath = realPath;
			this.size = size;
		}

		public String getRelPath(String pathRoot) {
			String real = getRealPath();
			real = StringUtils.replace(real, pathRoot, "");
			real = StringUtils.replace(real, File.separator, "/");
			return real;
		}

		private String origName;
		private String fileName;
		private String realPath;
		private long size;

		public String getOrigName() {
			return origName;
		}

		public void setOrigName(String origName) {
			this.origName = origName;
		}

		public String getFileName() {
			return fileName;
		}

		public void setFileName(String fileName) {
			this.fileName = fileName;
		}

		public String getRealPath() {
			return realPath;
		}

		public void setRealPath(String realPath) {
			this.realPath = realPath;
		}

		public long getSize() {
			return size;
		}

		public void setSize(long size) {
			this.size = size;
		}
	}

	public String getPathPrefix() {
		return pathPrefix;
	}

	public void setPathPrefix(String pathPrefix) {
		this.pathPrefix = pathPrefix;
	}

	public boolean isAllowFileBrowsing() {
		return allowFileBrowsing;
	}

	public void setAllowFileBrowsing(boolean allowFileBrowsing) {
		this.allowFileBrowsing = allowFileBrowsing;
	}

	public int getUploadSize() {
		return uploadSize;
	}

	public void setUploadSize(int uploadSize) {
		this.uploadSize = uploadSize;
	}

	public boolean isAllowUpload() {
		return allowUpload;
	}

	public void setAllowUpload(boolean allowUpload) {
		this.allowUpload = allowUpload;
	}

	public int getAllowSize() {
		return allowSize;
	}

	public void setAllowSize(int allowSize) {
		this.allowSize = allowSize;
	}
}
