/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerPlus;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.util.CollectionUtils;

public abstract class SharedEntityManagerCreator {
    public static EntityManager createSharedEntityManager(EntityManagerFactory emf) {
        return SharedEntityManagerCreator.createSharedEntityManager(emf, null);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, Map properties) {
        Class[] emIfcs = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            Class<? extends EntityManager> emIfc = emfInfo.getEntityManagerInterface();
            if (emIfc == null) {
                emIfc = EntityManager.class;
            }
            emIfcs = (jpaDialect = emfInfo.getJpaDialect()) != null && jpaDialect.supportsEntityManagerPlusOperations() ? new Class[]{emIfc, EntityManagerPlus.class} : new Class[]{emIfc};
        } else {
            emIfcs = new Class[]{EntityManager.class};
        }
        return SharedEntityManagerCreator.createSharedEntityManager(emf, properties, emIfcs);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, Map properties, Class ... entityManagerInterfaces) {
        ClassLoader cl = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            cl = ((EntityManagerFactoryInfo)emf).getBeanClassLoader();
        }
        Class[] ifcs = new Class[entityManagerInterfaces.length + 1];
        System.arraycopy(entityManagerInterfaces, 0, ifcs, 0, entityManagerInterfaces.length);
        ifcs[entityManagerInterfaces.length] = EntityManagerProxy.class;
        return (EntityManager)Proxy.newProxyInstance(cl != null ? cl : SharedEntityManagerCreator.class.getClassLoader(), ifcs, (InvocationHandler)new SharedEntityManagerInvocationHandler(emf, properties));
    }

    private static class SharedEntityManagerInvocationHandler
    implements InvocationHandler {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final EntityManagerFactory targetFactory;
        private final Map properties;

        public SharedEntityManagerInvocationHandler(EntityManagerFactory target, Map properties) {
            this.targetFactory = target;
            this.properties = properties;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("toString")) {
                return "Shared EntityManager proxy for target factory [" + this.targetFactory + "]";
            }
            if (method.getName().equals("isOpen")) {
                return true;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            if (method.getName().equals("getTransaction")) {
                throw new IllegalStateException("Not allowed to create transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
            }
            if (method.getName().equals("joinTransaction")) {
                throw new IllegalStateException("Not allowed to join transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
            }
            EntityManager target = EntityManagerFactoryUtils.doGetTransactionalEntityManager(this.targetFactory, this.properties);
            if (method.getName().equals("getTargetEntityManager")) {
                if (target == null) {
                    throw new IllegalStateException("No transactional EntityManager available");
                }
                return target;
            }
            boolean isNewEm = false;
            if (target == null) {
                this.logger.debug((Object)"Creating new EntityManager for shared EntityManager invocation");
                target = !CollectionUtils.isEmpty((Map)this.properties) ? this.targetFactory.createEntityManager(this.properties) : this.targetFactory.createEntityManager();
                isNewEm = true;
            }
            try {
                Object object = method.invoke((Object)target, args);
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (isNewEm) {
                    EntityManagerFactoryUtils.closeEntityManager(target);
                }
            }
        }
    }
}

