/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.StrutsResultSupport;

public class StreamResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -1468409635999059850L;
    protected static final Logger LOG = LoggerFactory.getLogger(StreamResult.class);
    public static final String DEFAULT_PARAM = "inputName";
    protected String contentType = "text/plain";
    protected String contentLength;
    protected String contentDisposition = "inline";
    protected String inputName = "inputStream";
    protected InputStream inputStream;
    protected int bufferSize = 1024;
    protected boolean allowCaching = true;

    public StreamResult() {
    }

    public StreamResult(InputStream in) {
        this.inputStream = in;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    public void setAllowCaching(boolean allowCaching) {
        this.allowCaching = allowCaching;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(String contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        this.resolveParamsFromStack(invocation.getStack());
        OutputStream oOutput = null;
        try {
            int iSize;
            if (this.inputStream == null) {
                this.inputStream = (InputStream)invocation.getStack().findValue(this.conditionalParse(this.inputName, invocation));
            }
            if (this.inputStream == null) {
                String msg = "Can not find a java.io.InputStream with the name [" + this.inputName + "] in the invocation stack. " + "Check the <param name=\"inputName\"> tag specified for this action.";
                LOG.error(msg, new String[0]);
                throw new IllegalArgumentException(msg);
            }
            HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
            if (this.contentLength != null) {
                String _contentLength = this.conditionalParse(this.contentLength, invocation);
                int _contentLengthAsInt = -1;
                try {
                    _contentLengthAsInt = Integer.parseInt(_contentLength);
                    if (_contentLengthAsInt >= 0) {
                        oResponse.setContentLength(_contentLengthAsInt);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn("failed to recongnize " + _contentLength + " as a number, contentLength header will not be set", (Throwable)e, new String[0]);
                }
            }
            if (this.contentDisposition != null) {
                oResponse.addHeader("Content-Disposition", this.conditionalParse(this.contentDisposition, invocation));
            }
            if (!this.allowCaching) {
                oResponse.addHeader("Pragma", "no-cache");
                oResponse.addHeader("Cache-Control", "no-cache");
            }
            oOutput = oResponse.getOutputStream();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Streaming result [" + this.inputName + "] type=[" + this.contentType + "] length=[" + this.contentLength + "] content-disposition=[" + this.contentDisposition + "]", new String[0]);
            }
            LOG.debug("Streaming to output buffer +++ START +++", new String[0]);
            byte[] oBuff = new byte[this.bufferSize];
            while (-1 != (iSize = this.inputStream.read(oBuff))) {
                oOutput.write(oBuff, 0, iSize);
            }
            LOG.debug("Streaming to output buffer +++ END +++", new String[0]);
            oOutput.flush();
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (oOutput != null) {
                oOutput.close();
            }
        }
    }

    protected void resolveParamsFromStack(ValueStack stack) {
        Integer bufferSize;
        String contentLength;
        String inputName;
        String contentType;
        String disposition = stack.findString("contentDisposition");
        if (disposition != null) {
            this.setContentDisposition(disposition);
        }
        if ((contentType = stack.findString("contentType")) != null) {
            this.setContentType(contentType);
        }
        if ((inputName = stack.findString(DEFAULT_PARAM)) != null) {
            this.setInputName(inputName);
        }
        if ((contentLength = stack.findString("contentLength")) != null) {
            this.setContentLength(contentLength);
        }
        if ((bufferSize = (Integer)stack.findValue("bufferSize", Integer.class)) != null) {
            this.setBufferSize(bufferSize);
        }
    }
}

