/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jjcode.MessageProvider;

public class BundleMessageProvider
extends MessageProvider {
    private String bundleBaseName;
    private HashMap resourceBundles;

    public BundleMessageProvider(String bundleBaseName) {
        this.bundleBaseName = bundleBaseName;
        this.resourceBundles = new HashMap();
    }

    protected synchronized ResourceBundle getBundleForLocale(Locale locale) {
        ResourceBundle rb = (ResourceBundle)this.resourceBundles.get(locale);
        if (rb == null) {
            rb = ResourceBundle.getBundle(this.bundleBaseName, locale);
            this.resourceBundles.put(locale, rb);
        }
        return rb;
    }

    public String getMessage(HashMap context, String messageId, Object[] params) {
        Locale locale = (Locale)context.get("org.jjcode.messageprovider.locale");
        ResourceBundle rb = this.getBundleForLocale(locale);
        String message = rb.getString(messageId);
        if (params == null || params.length == 0) {
            return message;
        }
        int i = 0;
        while (i < params.length) {
            message = message.replaceAll("\\{" + i + "\\}", params[i].toString());
            ++i;
        }
        return message;
    }
}

