/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode;

import java.util.ArrayList;

public class Node {
    public static final int TYPE_COMMAND = 1;
    public static final int TYPE_LITERAL = 2;
    public static final int TYPE_ROOT = 3;
    protected ArrayList children = new ArrayList();
    protected Node parent;
    protected int type;
    protected String tag;
    protected String value;

    public Node(int type, String value) {
        this.type = type;
        this.value = value;
        if (type == 1) {
            this.tag = value.substring(1);
            int eq = this.tag.indexOf("=");
            this.tag = eq != -1 ? this.tag.substring(0, eq) : this.tag.substring(0, this.tag.length() - 1);
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getType() {
        return this.type;
    }

    public Node getChild(int i) {
        return (Node)this.children.get(i);
    }

    public Node getParent() {
        return this.parent;
    }

    public String getValue() {
        return this.value;
    }

    public void addChild(Node child) {
        if (this.getType() == 2) {
            throw new IllegalArgumentException("This node is a text node, and does not accept children");
        }
        child.parent = this;
        this.children.add(child);
    }

    public StringBuffer getText() {
        if (this.type == 2) {
            return new StringBuffer(this.value);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getChildCount()) {
            sb.append(this.getChild(i).getText());
            ++i;
        }
        return sb;
    }

    public void dump(int level) {
        int i = 0;
        while (i < level) {
            System.out.print("\t");
            ++i;
        }
        System.out.println(String.valueOf(this.type) + "->" + this.value);
        i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).dump(level + 1);
            ++i;
        }
    }

    public String getTag() {
        return this.tag;
    }
}

