/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.jjcode.Icon;
import org.jjcode.MessageProvider;
import org.jjcode.Node;
import org.jjcode.Parser;
import org.jjcode.RenderCommand;
import org.jjcode.RenderFilter;
import org.jjcode.commands.BoldCommand;
import org.jjcode.commands.CodeCommand;
import org.jjcode.commands.ColorCommand;
import org.jjcode.commands.ImageCommand;
import org.jjcode.commands.ItalicCommand;
import org.jjcode.commands.ListCommand;
import org.jjcode.commands.QuoteCommand;
import org.jjcode.commands.SizeCommand;
import org.jjcode.commands.SubscriptCommand;
import org.jjcode.commands.SuperscriptCommand;
import org.jjcode.commands.URLCommand;
import org.jjcode.commands.UnderlineCommand;
import org.jjcode.filters.IconFilter;
import org.jjcode.filters.UnicodeFilter;

public class RenderEngine {
    public static final String LOCALE_KEY = "org.jjcode.messageprovider.locale";
    public static final int MODE_PREPROCESS = 0;
    public static final int MODE_RENDER = 1;
    private ArrayList commandHandlers = new ArrayList();
    private ArrayList filters = new ArrayList();
    private MessageProvider messageProvider;
    private HashMap iconCache = new HashMap();

    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    public synchronized void setMessageProvider(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        int i = 0;
        while (i < this.commandHandlers.size()) {
            RenderCommand handler = (RenderCommand)this.commandHandlers.get(i);
            handler.setMessageProvider(messageProvider);
            ++i;
        }
        i = 0;
        while (i < this.filters.size()) {
            RenderFilter filter = (RenderFilter)this.filters.get(i);
            filter.setMessageProvider(messageProvider);
            ++i;
        }
    }

    public synchronized void registerHandler(Object handler) {
        if (handler instanceof RenderCommand) {
            ((RenderCommand)handler).setEngine(this);
            this.commandHandlers.add((RenderCommand)handler);
        }
        if (handler instanceof RenderFilter) {
            ((RenderFilter)handler).setEngine(this);
            this.filters.add(handler);
        }
    }

    public RenderCommand findHandler(String token) {
        int i = 0;
        while (i < this.commandHandlers.size()) {
            RenderCommand cmd = (RenderCommand)this.commandHandlers.get(i);
            if (cmd.recognized(token)) {
                return cmd;
            }
            ++i;
        }
        return null;
    }

    public String render(String s, int mode, HashMap info) {
        StringBuffer source = new StringBuffer(s);
        int i = 0;
        while (i < this.filters.size()) {
            RenderFilter filter = (RenderFilter)this.filters.get(i);
            if (mode != 0 || filter.preProcessingAllowed()) {
                source = filter.render(source, info);
            }
            ++i;
        }
        Parser p = new Parser();
        Node root = p.parse(source.toString());
        return this.renderChildren(root, mode, info).toString();
    }

    public String render(String s, int mode, Locale locale) {
        HashMap<String, Locale> context = new HashMap<String, Locale>();
        context.put(LOCALE_KEY, locale);
        return this.render(s, mode, context);
    }

    public StringBuffer renderChildren(Node parent, int mode, HashMap info) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < parent.getChildCount()) {
            Node child = parent.getChild(i);
            switch (child.getType()) {
                case 2: {
                    sb.append(child.getValue());
                    break;
                }
                case 1: {
                    RenderCommand cmd = this.findHandler(child.getValue());
                    if (cmd == null) {
                        sb.append(this.renderChildren(child, mode, info));
                        break;
                    }
                    if (!cmd.preProcessingAllowed() && mode == 0) {
                        sb.append(child.getValue());
                        sb.append(this.renderChildren(child, mode, info));
                        sb.append("[/");
                        sb.append(child.getTag());
                        sb.append("]");
                        break;
                    }
                    sb.append(cmd.render(child, mode, info));
                }
            }
            ++i;
        }
        return sb;
    }

    public ArrayList getCommands() {
        return this.commandHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcon(Icon icon) {
        HashMap hashMap = this.iconCache;
        synchronized (hashMap) {
            this.iconCache.put(icon.id, icon);
        }
    }

    public Icon getIcon(String id) {
        return (Icon)this.iconCache.get(id);
    }

    public Set getIcons() {
        return this.iconCache.keySet();
    }

    public void registerAll() {
        this.registerHandler(new BoldCommand());
        this.registerHandler(new ColorCommand());
        this.registerHandler(new ItalicCommand());
        this.registerHandler(new QuoteCommand());
        this.registerHandler(new SizeCommand());
        this.registerHandler(new SubscriptCommand());
        this.registerHandler(new SuperscriptCommand());
        this.registerHandler(new UnderlineCommand());
        this.registerHandler(new URLCommand());
        this.registerHandler(new ImageCommand());
        this.registerHandler(new UnicodeFilter());
        this.registerHandler(new IconFilter());
        this.registerHandler(new ListCommand());
        this.registerHandler(new CodeCommand());
    }
}

