/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode.commands;

import java.util.HashMap;
import org.jjcode.Node;
import org.jjcode.RenderCommand;

public class CodeCommand
extends RenderCommand {
    public boolean preProcessingAllowed() {
        return true;
    }

    public boolean recognized(String token) {
        return token.startsWith("[code");
    }

    public StringBuffer render(Node node, int mode, HashMap info) {
        String token = node.getValue().toString();
        int equal = token.indexOf("=");
        String language = "java";
        if (equal != -1) {
            language = token.substring(equal + 1, token.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        if (language.equals("csharp")) {
            sb.append("<pre class='brush: csharp;'>");
        } else if (language.equals("css")) {
            sb.append("<pre class='brush: css;'>");
        } else if (language.equals("jscript")) {
            sb.append("<pre class='brush: jscript;'>");
        } else if (language.equals("plain")) {
            sb.append("<pre class='brush: plain;'>");
        } else if (language.equals("sql")) {
            sb.append("<pre class='brush: sql;'>");
        } else if (language.equals("xml") || language.equals("html")) {
            sb.append("<pre class='brush: xml;'>");
        } else {
            sb.append("<pre class='brush: java;'>");
        }
        sb.append(this.renderChildren(node, mode, info).toString().replaceAll("<br />", ""));
        sb.append("</pre>");
        return sb;
    }

    public StringBuffer renderControl(String fieldName, String helpFieldName, HashMap info) {
        return this.renderButtonControl("code", "code.help", "[code]", "[/code]", fieldName, helpFieldName, "code", "code", info);
    }
}

