/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode.commands;

import java.util.HashMap;
import org.jjcode.Node;
import org.jjcode.RenderCommand;

public class ColorCommand
extends RenderCommand {
    protected String[] colors = new String[]{"black", "darkred", "red", "orange", "brown", "yellow", "green", "olive", "cyan", "blue", "darkblue", "indigo", "violet", "white", "black"};

    public boolean recognized(String token) {
        return token.startsWith("[color");
    }

    public StringBuffer render(Node tree, int mode, HashMap info) {
        String token = tree.getValue();
        int equal = token.indexOf("=");
        String color = "black";
        if (equal != -1 && equal != token.length() - 2) {
            color = token.substring(equal + 1, token.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<span style='color:");
        sb.append(color);
        sb.append("'>");
        sb.append(this.renderChildren(tree, mode, info));
        sb.append("</span>");
        return sb;
    }

    public StringBuffer renderControl(String fieldName, String helpFieldName, HashMap info) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"");
        sb.append(this.textControlClassName);
        sb.append("\"> &nbsp;");
        sb.append(this.mp.getMessage(info, String.valueOf(this.rootMessageKey) + "color"));
        sb.append(" <select class='");
        sb.append(this.controlClassName);
        sb.append("' name='color' onChange=\"");
        sb.append(this.insertFunctionName);
        sb.append("('" + fieldName + "','[color='+this.options[this.selectedIndex].value+']','[/color]')\" ");
        sb.append("onMouseOver=\"");
        sb.append(this.helpFunctionName);
        sb.append("('" + helpFieldName + "','" + this.mp.getMessage(info, String.valueOf(this.rootMessageKey) + "color.help") + "')\">");
        int i = 0;
        while (i < this.colors.length) {
            String messageId = String.valueOf(this.rootMessageKey) + "color." + this.colors[i];
            sb.append("<option style=\"color:");
            sb.append(this.colors[i]);
            sb.append("; font-weight:bold; background-color: #FAFAFA\" value=\"");
            sb.append(this.colors[i]);
            sb.append("\" class=\"");
            sb.append(this.textControlClassName);
            sb.append("\">");
            sb.append(this.mp.getMessage(info, messageId));
            sb.append("</option>");
            ++i;
        }
        sb.append("</select></span>");
        return sb;
    }

    public boolean preProcessingAllowed() {
        return true;
    }
}

