/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode.commands;

import java.util.HashMap;
import org.jjcode.Node;
import org.jjcode.RenderCommand;

public class ImageCommand
extends RenderCommand {
    protected String imageClass = "jjCodeImage";

    public boolean recognized(String token) {
        return token.startsWith("[img");
    }

    public StringBuffer render(Node node, int mode, HashMap info) {
        String token = node.getValue();
        int equal = token.indexOf("=");
        String url = node.getText().toString();
        if (equal != -1) {
            url = token.substring(equal + 1, token.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<img class='");
        sb.append(this.imageClass);
        sb.append("' src='");
        sb.append(url);
        sb.append("' alt='");
        sb.append(this.renderChildren(node, mode, info));
        sb.append("' />");
        return sb;
    }

    public StringBuffer renderControl(String fieldName, String helpFieldName, HashMap info) {
        return this.renderButtonControl("image", "image.help", "[img=http://]alt-text", "[/img]", fieldName, helpFieldName, null, null, info);
    }

    public boolean preProcessingAllowed() {
        return true;
    }
}

