/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode.commands;

import java.util.HashMap;
import org.jjcode.Node;
import org.jjcode.RenderCommand;

public class ListCommand
extends RenderCommand {
    public boolean preProcessingAllowed() {
        return true;
    }

    public boolean recognized(String token) {
        return token.startsWith("[list]");
    }

    public StringBuffer render(Node node, int mode, HashMap info) {
        String content = node.getChild(0).getValue();
        String[] contentArray = content.split("\\[\\*\\]");
        StringBuffer sb = new StringBuffer();
        sb.append("<ul>");
        if (contentArray.length <= 1) {
            sb.append("<li>");
            sb.append(content);
            sb.append("</li>");
        } else if (contentArray.length >= 2) {
            int i = 0;
            while (i < contentArray.length) {
                if (i != 0) {
                    sb.append("<li>");
                    sb.append(contentArray[i]);
                    sb.append("</li>");
                }
                ++i;
            }
        }
        sb.append("</ul>");
        return sb;
    }

    public StringBuffer renderControl(String fieldName, String helpFieldName, HashMap info) {
        return this.renderButtonControl("list", "list.help", "[list]", "[/list]", fieldName, helpFieldName, "list", "list", info);
    }
}

