/*
 * Decompiled with CFR 0.152.
 */
package org.jjcode.commands;

import java.util.HashMap;
import org.jjcode.Node;
import org.jjcode.RenderCommand;

public class URLCommand
extends RenderCommand {
    public boolean recognized(String token) {
        return token.startsWith("[url");
    }

    public StringBuffer render(Node node, int mode, HashMap info) {
        String token = node.getValue();
        int equal = token.indexOf("=");
        String url = node.getText().toString();
        if (equal != -1) {
            url = token.substring(equal + 1, token.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a target='_blank' href='");
        sb.append(url);
        sb.append("' class='");
        sb.append(this.linkClassName);
        sb.append("'>");
        sb.append(this.renderChildren(node, mode, info));
        sb.append("</a>");
        return sb;
    }

    public StringBuffer renderControl(String fieldName, String helpFieldName, HashMap info) {
        return this.renderButtonControl("link", "link.help", "[url=http://]", "[/url]", fieldName, helpFieldName, null, null, info);
    }

    public boolean preProcessingAllowed() {
        return true;
    }
}

