﻿/*
MySQL Data Transfer
Source Host: localhost
Source Database: wmj_back
Target Host: localhost
Target Database: wmj_back
Date: 2009-9-16 22:12:10
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for digg_log
-- ----------------------------
DROP TABLE IF EXISTS `digg_log`;
CREATE TABLE `digg_log` (
  `LogID` int(10) unsigned NOT NULL auto_increment,
  `InfoID` int(10) unsigned default NULL,
  `IP` varchar(15) default '',
  `CreateTime` int(10) unsigned default NULL,
  PRIMARY KEY  (`LogID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_admin
-- ----------------------------
DROP TABLE IF EXISTS `wmj_admin`;
CREATE TABLE `wmj_admin` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `UserName` varchar(60) NOT NULL default '',
  `Password` varchar(32) NOT NULL default '',
  `LastLoginIP` varchar(15) default NULL,
  `LastLoginTime` varchar(30) default NULL,
  `LastLogoutTime` varchar(30) default NULL,
  `LoginTimes` int(10) unsigned default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_article
-- ----------------------------
DROP TABLE IF EXISTS `wmj_article`;
CREATE TABLE `wmj_article` (
  `ArticleID` int(10) unsigned NOT NULL auto_increment,
  `CID` int(10) unsigned NOT NULL default '0',
  `Title` varchar(120) NOT NULL default '',
  `Subheading` varchar(120) default NULL,
  `Author` varchar(20) default NULL,
  `CopyFrom` varchar(200) default NULL,
  `Inputer` varchar(200) default NULL,
  `Keyword` varchar(255) NOT NULL default '',
  `Hits` int(10) unsigned NOT NULL default '0',
  `CommentCount` int(10) unsigned default NULL,
  `UpdateTime` int(10) unsigned NOT NULL default '0',
  `CreateTime` int(10) unsigned default NULL,
  `OnTop` tinyint(1) unsigned NOT NULL default '0',
  `Elite` tinyint(1) unsigned NOT NULL default '0',
  `Status` tinyint(1) unsigned NOT NULL default '0',
  `Content` longtext NOT NULL,
  `IncludePic` int(10) unsigned NOT NULL default '0',
  `DefaultPicUrl` varchar(255) default NULL,
  `UploadFiles` text,
  `Deleted` tinyint(1) unsigned NOT NULL default '0',
  `Stars` int(10) unsigned default NULL,
  PRIMARY KEY  (`ArticleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_ask
-- ----------------------------
DROP TABLE IF EXISTS `wmj_ask`;
CREATE TABLE `wmj_ask` (
  `AskID` mediumint(8) unsigned NOT NULL auto_increment,
  `CID` mediumint(8) NOT NULL default '0',
  `Title` varchar(50) NOT NULL default '',
  `Content` text NOT NULL,
  `Reward` smallint(6) unsigned NOT NULL default '0',
  `ReplyCount` smallint(5) unsigned NOT NULL default '0',
  `Closed` tinyint(1) unsigned NOT NULL default '0',
  `Solved` tinyint(1) unsigned NOT NULL default '0',
  `Hot` tinyint(1) unsigned NOT NULL default '0',
  `Replenished` tinyint(1) NOT NULL default '0',
  `CreateDate` int(10) NOT NULL default '0',
  `UpdateDate` int(10) default NULL,
  `IpAddress` varchar(15) NOT NULL default '',
  `UserID` mediumint(9) unsigned NOT NULL default '0',
  `UserName` varchar(100) NOT NULL default '',
  `SolveUserID` mediumint(9) NOT NULL default '0',
  `SolveUserName` varchar(100) NOT NULL default '',
  `IsAttachment` tinyint(4) unsigned NOT NULL default '0',
  `Deleted` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`AskID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_ask_replenish
-- ----------------------------
DROP TABLE IF EXISTS `wmj_ask_replenish`;
CREATE TABLE `wmj_ask_replenish` (
  `ReplenishID` mediumint(9) unsigned NOT NULL auto_increment,
  `AskID` mediumint(9) NOT NULL default '0',
  `Content` text NOT NULL,
  `CreateDate` int(10) NOT NULL default '0',
  `Deleted` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ReplenishID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_ask_reply
-- ----------------------------
DROP TABLE IF EXISTS `wmj_ask_reply`;
CREATE TABLE `wmj_ask_reply` (
  `RelpyAskID` mediumint(8) unsigned NOT NULL auto_increment,
  `AskID` mediumint(8) unsigned NOT NULL default '0',
  `Content` text NOT NULL,
  `CreateDate` int(10) NOT NULL default '0',
  `IpAddress` varchar(15) NOT NULL default '',
  `Accepted` tinyint(1) unsigned NOT NULL default '0',
  `UserID` mediumint(8) unsigned NOT NULL default '0',
  `UserName` varchar(100) NOT NULL default '',
  `Deleted` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`RelpyAskID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_attachment
-- ----------------------------
DROP TABLE IF EXISTS `wmj_attachment`;
CREATE TABLE `wmj_attachment` (
  `AttachID` mediumint(9) unsigned NOT NULL auto_increment,
  `InfoID` mediumint(9) NOT NULL default '0',
  `FileName` char(100) NOT NULL default '',
  `FileType` char(50) NOT NULL default '',
  `FileSize` int(11) NOT NULL default '0',
  `Attachment` char(100) NOT NULL default '',
  `CreateDate` int(10) NOT NULL default '0',
  `UserID` mediumint(8) NOT NULL default '0',
  PRIMARY KEY  (`AttachID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_category
-- ----------------------------
DROP TABLE IF EXISTS `wmj_category`;
CREATE TABLE `wmj_category` (
  `CID` int(10) unsigned NOT NULL auto_increment,
  `ChannelID` int(10) unsigned NOT NULL default '0',
  `ClassName` varchar(20) NOT NULL default '',
  `CnName` varchar(40) NOT NULL default '',
  `ClassPicUrl` varchar(100) default NULL,
  `LFT` int(10) unsigned NOT NULL default '0',
  `RGT` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`CID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_comment
-- ----------------------------
DROP TABLE IF EXISTS `wmj_comment`;
CREATE TABLE `wmj_comment` (
  `CommentID` int(10) unsigned NOT NULL auto_increment,
  `InfoID` int(10) unsigned NOT NULL default '0',
  `IP` varchar(15) default NULL,
  `WriteTime` int(10) unsigned default NULL,
  `Passed` tinyint(1) unsigned default '0',
  `Content` text,
  `UserID` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`CommentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_news
-- ----------------------------
DROP TABLE IF EXISTS `wmj_news`;
CREATE TABLE `wmj_news` (
  `NewsID` int(10) unsigned NOT NULL auto_increment,
  `ClassName` varchar(45) NOT NULL default '',
  `Title` varchar(90) NOT NULL default '',
  `KeyWord` varchar(45) default NULL,
  `Content` longtext NOT NULL,
  `CopyFrom` varchar(45) default NULL,
  `CopyFromUrl` varchar(150) default NULL,
  `PermanentLink` varchar(150) default NULL COMMENT '永久链接',
  `UpdateTime` int(10) unsigned default '0',
  `CreateTime` int(10) unsigned NOT NULL default '0',
  `IpAddress` varchar(15) NOT NULL default '',
  `Hits` int(10) unsigned NOT NULL default '0',
  `CommentCount` int(10) unsigned NOT NULL default '0',
  `Digg` int(10) unsigned NOT NULL default '0' COMMENT '顶',
  `Bury` int(10) unsigned NOT NULL default '0' COMMENT '踩',
  `UserID` int(10) NOT NULL default '0',
  `UserName` varchar(100) NOT NULL default '',
  `IsPass` tinyint(1) unsigned NOT NULL default '0',
  `IsAttachment` tinyint(1) NOT NULL default '0',
  `Deleted` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`NewsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_ranks
-- ----------------------------
DROP TABLE IF EXISTS `wmj_ranks`;
CREATE TABLE `wmj_ranks` (
  `RankID` smallint(6) unsigned NOT NULL auto_increment,
  `RankType` tinyint(2) unsigned NOT NULL default '0',
  `RankTitle` varchar(30) NOT NULL default '',
  `Postshigher` mediumint(8) unsigned NOT NULL default '0',
  `Stars` tinyint(3) unsigned NOT NULL default '0',
  `Color` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`RankID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_soft
-- ----------------------------
DROP TABLE IF EXISTS `wmj_soft`;
CREATE TABLE `wmj_soft` (
  `SoftID` int(10) unsigned NOT NULL auto_increment,
  `ClassName` varchar(45) NOT NULL default '',
  `SoftName` varchar(200) NOT NULL default '',
  `Author` varchar(30) default NULL,
  `DemoUrl` varchar(80) default NULL,
  `SoftLanguage` varchar(45) default NULL,
  `OperatingSystem` varchar(100) default NULL,
  `Inputer` varchar(20) default NULL,
  `Keyword` varchar(200) default '',
  `SoftSize` int(10) unsigned default '0',
  `Stars` int(10) unsigned default '0',
  `SoftIntro` text,
  `DownloadUrl` text NOT NULL,
  `Hits` int(10) unsigned default '0',
  `DayHits` int(10) unsigned default '0',
  `WeekHits` int(10) unsigned default '0',
  `MonthHits` int(10) unsigned default '0',
  `CommentCount` int(10) unsigned default '0',
  `UpdateTime` int(10) unsigned default NULL,
  `CreateTime` int(10) unsigned default NULL,
  `IpAddress` int(10) unsigned default NULL,
  `OnTop` tinyint(1) unsigned default '0',
  `Elite` tinyint(1) unsigned default '0',
  `HasAttachment` tinyint(1) unsigned default NULL,
  `IsPass` tinyint(1) unsigned default NULL,
  `Deleted` tinyint(1) unsigned default NULL,
  PRIMARY KEY  (`SoftID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_tags
-- ----------------------------
DROP TABLE IF EXISTS `wmj_tags`;
CREATE TABLE `wmj_tags` (
  `TagID` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`TagID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_tags_relation
-- ----------------------------
DROP TABLE IF EXISTS `wmj_tags_relation`;
CREATE TABLE `wmj_tags_relation` (
  `InfoID` mediumint(9) unsigned NOT NULL default '0',
  `TagID` mediumint(9) unsigned NOT NULL default '0',
  PRIMARY KEY  (`InfoID`,`TagID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_user
-- ----------------------------
DROP TABLE IF EXISTS `wmj_user`;
CREATE TABLE `wmj_user` (
  `UserID` int(10) unsigned NOT NULL auto_increment,
  `Email` varchar(50) NOT NULL default '',
  `UserName` varchar(100) NOT NULL default '',
  `Password` varchar(32) NOT NULL default '',
  `Gender` tinyint(1) unsigned NOT NULL default '2',
  `GroupID` smallint(6) unsigned NOT NULL default '0' COMMENT '组ID',
  `RegIP` varchar(15) NOT NULL default '',
  `RegDate` int(10) unsigned NOT NULL default '0',
  `LastIP` varchar(15) default '',
  `LastVisitDate` int(10) default NULL,
  `NewsCredit` int(10) unsigned NOT NULL default '0' COMMENT '新闻积分',
  `AskCredit` int(10) NOT NULL default '30' COMMENT '问答积分',
  `Location` varchar(30) NOT NULL default '',
  `Signature` text NOT NULL,
  `Identifying` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for wmj_user_group
-- ----------------------------
DROP TABLE IF EXISTS `wmj_user_group`;
CREATE TABLE `wmj_user_group` (
  `GroupID` smallint(6) unsigned NOT NULL auto_increment,
  `GroupType` tinyint(1) unsigned NOT NULL default '0',
  `GroupTitle` char(30) NOT NULL default '',
  `CreditsHigher` int(10) NOT NULL default '0',
  `CreditSlower` int(10) NOT NULL default '0',
  PRIMARY KEY  (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `wmj_admin` VALUES ('1', 'admin', 'c4ca4238a0b923820dcc509a6f75849b', '127.0.0.1', '1252826604', null, '987');
INSERT INTO `wmj_category` VALUES ('1', '0', 'root', '', null, '1', '56');
INSERT INTO `wmj_category` VALUES ('2', '1', 'Article', '', null, '2', '49');
INSERT INTO `wmj_category` VALUES ('3', '2', 'Soft', '', null, '50', '55');
INSERT INTO `wmj_category` VALUES ('4', '3', 'Ask', '', null, '57', '142');
