/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.cms.impl;

import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.cms.IArticleCommentDao;
import com.lxinet.jeesns.model.cms.Article;
import com.lxinet.jeesns.model.cms.ArticleComment;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.cms.IArticleCommentService;
import com.lxinet.jeesns.service.cms.IArticleService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="articleCommentService")
public class ArticleCommentServiceImpl
extends BaseServiceImpl<ArticleComment>
implements IArticleCommentService {
    @Resource
    private IArticleCommentDao articleCommentDao;
    @Resource
    private IArticleService articleService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;

    public ArticleComment findById(Integer id) {
        return this.atFormat((ArticleComment)super.findById(id));
    }

    @Override
    public boolean save(Member loginMember, String content, Integer articleId) {
        Article article = (Article)this.articleService.findById(articleId);
        ValidUtill.checkIsNull((Object)article, (String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
        ValidUtill.checkIsBlank((String)content, (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        ArticleComment articleComment = new ArticleComment();
        articleComment.setMemberId(loginMember.getId());
        articleComment.setArticleId(articleId);
        articleComment.setContent(content);
        boolean result = super.save((Object)articleComment);
        if (!result) {
            throw new OpeErrorException();
        }
        this.messageService.atDeal(loginMember.getId(), content, 1, MessageType.CMS_ARTICLE_COMMENT_REFER, articleComment.getId());
        this.messageService.diggDeal(loginMember.getId(), article.getMemberId(), content, 1, MessageType.CMS_ARTICLR_REPLY, article.getId());
        this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_REVIEWS, articleComment.getId());
        return true;
    }

    public List listByPage(Page page, int articleId, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key + "%";
        }
        List<ArticleComment> list = this.articleCommentDao.list(page, articleId, key);
        this.atFormat(list);
        return list;
    }

    @Override
    public void deleteByArticle(Integer articleId) {
        this.articleCommentDao.deleteByArticle(articleId);
    }

    @Override
    @Transactional
    public boolean delete(Member loginMember, int id) {
        boolean result = super.deleteById(Integer.valueOf(id));
        if (!result) {
            throw new OpeErrorException();
        }
        this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_REVIEWS, id);
        this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_ARTICLE_COMMENT, "ID\uff1a" + id);
        return true;
    }

    public ArticleComment atFormat(ArticleComment articleComment) {
        articleComment.setContent(this.memberService.atFormat(articleComment.getContent()));
        return articleComment;
    }

    public List<ArticleComment> atFormat(List<ArticleComment> articleCommentList) {
        for (ArticleComment articleComment : articleCommentList) {
            this.atFormat(articleComment);
        }
        return articleCommentList;
    }
}

